/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.client.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.client.BundleClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.RequestConfig;
import org.apache.nifi.registry.client.impl.AbstractJerseyClient;
import org.apache.nifi.registry.extension.bundle.Bundle;
import org.apache.nifi.registry.extension.bundle.BundleFilterParams;

public class JerseyBundleClient
extends AbstractJerseyClient
implements BundleClient {
    private final WebTarget bucketExtensionBundlesTarget;
    private final WebTarget extensionBundlesTarget;

    public JerseyBundleClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyBundleClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.bucketExtensionBundlesTarget = baseTarget.path("buckets/{bucketId}/bundles");
        this.extensionBundlesTarget = baseTarget.path("bundles");
    }

    @Override
    public List<Bundle> getAll() throws IOException, NiFiRegistryException {
        return this.getAll(null);
    }

    @Override
    public List<Bundle> getAll(BundleFilterParams filterParams) throws IOException, NiFiRegistryException {
        return this.executeAction("Error getting extension bundles", () -> {
            Bundle[] bundles;
            WebTarget target = this.extensionBundlesTarget;
            if (filterParams != null) {
                if (!StringUtils.isBlank((CharSequence)filterParams.getBucketName())) {
                    target = target.queryParam("bucketName", new Object[]{filterParams.getBucketName()});
                }
                if (!StringUtils.isBlank((CharSequence)filterParams.getGroupId())) {
                    target = target.queryParam("groupId", new Object[]{filterParams.getGroupId()});
                }
                if (!StringUtils.isBlank((CharSequence)filterParams.getArtifactId())) {
                    target = target.queryParam("artifactId", new Object[]{filterParams.getArtifactId()});
                }
            }
            return (bundles = (Bundle[])this.getRequestBuilder(target).get(Bundle[].class)) == null ? Collections.emptyList() : Arrays.asList(bundles);
        });
    }

    @Override
    public List<Bundle> getByBucket(String bucketId) throws IOException, NiFiRegistryException {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket id cannot be null or blank");
        }
        return this.executeAction("Error getting extension bundles for bucket", () -> {
            WebTarget target = this.bucketExtensionBundlesTarget.resolveTemplate("bucketId", (Object)bucketId);
            Bundle[] bundles = (Bundle[])this.getRequestBuilder(target).get(Bundle[].class);
            return bundles == null ? Collections.emptyList() : Arrays.asList(bundles);
        });
    }

    @Override
    public Bundle get(String bundleId) throws IOException, NiFiRegistryException {
        if (StringUtils.isBlank((CharSequence)bundleId)) {
            throw new IllegalArgumentException("Bundle id cannot be null or blank");
        }
        return this.executeAction("Error getting extension bundle", () -> {
            WebTarget target = this.extensionBundlesTarget.path("{bundleId}").resolveTemplate("bundleId", (Object)bundleId);
            return (Bundle)this.getRequestBuilder(target).get(Bundle.class);
        });
    }

    @Override
    public Bundle delete(String bundleId) throws IOException, NiFiRegistryException {
        if (StringUtils.isBlank((CharSequence)bundleId)) {
            throw new IllegalArgumentException("Bundle id cannot be null or blank");
        }
        return this.executeAction("Error deleting extension bundle", () -> {
            WebTarget target = this.extensionBundlesTarget.path("{bundleId}").resolveTemplate("bundleId", (Object)bundleId);
            return (Bundle)this.getRequestBuilder(target).delete(Bundle.class);
        });
    }
}

