/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.lineage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.provenance.lineage.Lineage;
import org.apache.nifi.provenance.lineage.LineageEdge;
import org.apache.nifi.provenance.lineage.LineageNode;

public class FlowFileLineage
implements Lineage {
    private final List<LineageNode> nodes;
    private final List<LineageEdge> edges;

    public FlowFileLineage(Collection<LineageNode> nodes, Collection<LineageEdge> edges) {
        this.nodes = new ArrayList<LineageNode>(Objects.requireNonNull(nodes));
        this.edges = new ArrayList<LineageEdge>(Objects.requireNonNull(edges));
    }

    public List<LineageNode> getNodes() {
        return this.nodes;
    }

    public List<LineageEdge> getEdges() {
        return this.edges;
    }

    public int hashCode() {
        int sum = 923;
        for (LineageNode node : this.nodes) {
            sum += node.hashCode();
        }
        for (LineageEdge edge : this.edges) {
            sum += edge.hashCode();
        }
        return sum;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FlowFileLineage)) {
            return false;
        }
        FlowFileLineage other = (FlowFileLineage)obj;
        return this.nodes.equals(other.nodes) && this.edges.equals(other.edges);
    }
}

