/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.nifi.authorization.AuthorizationAuditor;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;

public class AuthorizationAuditorInvocationHandler
implements InvocationHandler {
    private final Authorizer authorizer;
    private final AuthorizationAuditor auditor;
    private static final Method auditAccessAttemptMethod;

    public AuthorizationAuditorInvocationHandler(Authorizer authorizer, AuthorizationAuditor auditor) {
        this.authorizer = authorizer;
        this.auditor = auditor;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (auditAccessAttemptMethod.equals(method)) {
                return method.invoke((Object)this.auditor, args);
            }
            return method.invoke((Object)this.authorizer, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    static {
        try {
            auditAccessAttemptMethod = AuthorizationAuditor.class.getMethod("auditAccessAttempt", AuthorizationRequest.class, AuthorizationResult.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to obtain necessary class information for AccessPolicyProvider", e);
        }
    }
}

