/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum DataUnit {
    B{

        @Override
        public double toB(double value) {
            return value;
        }

        @Override
        public double toKB(double value) {
            return value / POWERS[1];
        }

        @Override
        public double toMB(double value) {
            return value / POWERS[2];
        }

        @Override
        public double toGB(double value) {
            return value / POWERS[3];
        }

        @Override
        public double toTB(double value) {
            return value / POWERS[4];
        }

        @Override
        public double convert(double sourceSize, DataUnit sourceUnit) {
            return sourceUnit.toB(sourceSize);
        }
    }
    ,
    KB{

        @Override
        public double toB(double value) {
            return value * POWERS[1];
        }

        @Override
        public double toKB(double value) {
            return value;
        }

        @Override
        public double toMB(double value) {
            return value / POWERS[1];
        }

        @Override
        public double toGB(double value) {
            return value / POWERS[2];
        }

        @Override
        public double toTB(double value) {
            return value / POWERS[3];
        }

        @Override
        public double convert(double sourceSize, DataUnit sourceUnit) {
            return sourceUnit.toKB(sourceSize);
        }
    }
    ,
    MB{

        @Override
        public double toB(double value) {
            return value * POWERS[2];
        }

        @Override
        public double toKB(double value) {
            return value * POWERS[1];
        }

        @Override
        public double toMB(double value) {
            return value;
        }

        @Override
        public double toGB(double value) {
            return value / POWERS[1];
        }

        @Override
        public double toTB(double value) {
            return value / POWERS[2];
        }

        @Override
        public double convert(double sourceSize, DataUnit sourceUnit) {
            return sourceUnit.toMB(sourceSize);
        }
    }
    ,
    GB{

        @Override
        public double toB(double value) {
            return value * POWERS[3];
        }

        @Override
        public double toKB(double value) {
            return value * POWERS[2];
        }

        @Override
        public double toMB(double value) {
            return value * POWERS[1];
        }

        @Override
        public double toGB(double value) {
            return value;
        }

        @Override
        public double toTB(double value) {
            return value / POWERS[1];
        }

        @Override
        public double convert(double sourceSize, DataUnit sourceUnit) {
            return sourceUnit.toGB(sourceSize);
        }
    }
    ,
    TB{

        @Override
        public double toB(double value) {
            return value * POWERS[4];
        }

        @Override
        public double toKB(double value) {
            return value * POWERS[3];
        }

        @Override
        public double toMB(double value) {
            return value * POWERS[2];
        }

        @Override
        public double toGB(double value) {
            return value * POWERS[1];
        }

        @Override
        public double toTB(double value) {
            return value;
        }

        @Override
        public double convert(double sourceSize, DataUnit sourceUnit) {
            return sourceUnit.toTB(sourceSize);
        }
    };

    public static final double[] POWERS;
    public static final String DATA_SIZE_REGEX = "(\\d+(?:\\.\\d+)?)\\s*(B|KB|MB|GB|TB)";
    public static final Pattern DATA_SIZE_PATTERN;

    public double convert(double sourceSize, DataUnit sourceUnit) {
        throw new AbstractMethodError();
    }

    public double toB(double size) {
        throw new AbstractMethodError();
    }

    public double toKB(double size) {
        throw new AbstractMethodError();
    }

    public double toMB(double size) {
        throw new AbstractMethodError();
    }

    public double toGB(double size) {
        throw new AbstractMethodError();
    }

    public double toTB(double size) {
        throw new AbstractMethodError();
    }

    public static Double parseDataSize(String value, DataUnit units) {
        if (value == null) {
            return null;
        }
        Matcher matcher = DATA_SIZE_PATTERN.matcher(value.toUpperCase());
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid data size: " + value);
        }
        String sizeValue = matcher.group(1);
        String unitValue = matcher.group(2);
        DataUnit sourceUnit = DataUnit.valueOf(unitValue);
        double size = Double.parseDouble(sizeValue);
        return units.convert(size, sourceUnit);
    }

    static {
        POWERS = new double[]{1.0, 1024.0, 1048576.0, 1.073741824E9, 1.099511627776E12};
        DATA_SIZE_PATTERN = Pattern.compile(DATA_SIZE_REGEX);
    }
}

