/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.lang.management.ThreadInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.lifecycle.OnConfigurationRestored;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.annotation.lifecycle.OnUnscheduled;
import org.apache.nifi.annotation.notification.OnPrimaryNodeStateChange;
import org.apache.nifi.annotation.notification.PrimaryNodeState;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.validation.ValidationState;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ActiveThreadInfo;
import org.apache.nifi.controller.BackoffMechanism;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorDetails;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.SchedulingAgentCallback;
import org.apache.nifi.controller.TerminationAwareLogger;
import org.apache.nifi.controller.ThreadDetails;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.scheduling.LifecycleState;
import org.apache.nifi.controller.scheduling.SchedulingAgent;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.tasks.ActiveTask;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.GroupedComponent;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.logging.LoggingContext;
import org.apache.nifi.logging.StandardLoggingContext;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.parameter.ExpressionLanguageAgnosticParameterParser;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.parameter.ParameterReference;
import org.apache.nifi.parameter.ParameterTokenList;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.registry.ComponentVariableRegistry;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.CharacterFilterUtils;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.ReflectionUtils;
import org.apache.nifi.util.ThreadUtils;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardProcessorNode
extends ProcessorNode
implements Connectable {
    private static final Logger LOG = LoggerFactory.getLogger(StandardProcessorNode.class);
    public static final String BULLETIN_OBSERVER_ID = "bulletin-observer";
    public static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    public static final String DEFAULT_YIELD_PERIOD = "1 sec";
    public static final String DEFAULT_PENALIZATION_PERIOD = "30 sec";
    private static final String RUN_SCHEDULE = "Run Schedule";
    private final AtomicReference<ProcessGroup> processGroup;
    private final AtomicReference<ProcessorDetails> processorRef;
    private final AtomicReference<String> identifier;
    private final Map<Connection, Connectable> destinations;
    private final Map<Relationship, Set<Connection>> connections;
    private final AtomicReference<Set<Relationship>> undefinedRelationshipsToTerminate;
    private final AtomicReference<List<Connection>> incomingConnections;
    private final AtomicBoolean lossTolerant;
    private final AtomicReference<String> comments;
    private final AtomicReference<Position> position;
    private final AtomicReference<String> schedulingPeriod;
    private final AtomicReference<String> yieldPeriod;
    private final AtomicReference<String> penalizationPeriod;
    private final AtomicReference<Map<String, String>> style;
    private final AtomicInteger concurrentTaskCount;
    private final AtomicLong yieldExpiration;
    private final AtomicLong schedulingNanos;
    private final AtomicReference<String> versionedComponentId;
    private final ProcessScheduler processScheduler;
    private long runNanos;
    private volatile long yieldNanos;
    private volatile ScheduledState desiredState;
    private volatile LogLevel bulletinLevel;
    private volatile List<ParameterReference> parameterReferences;
    private final AtomicReference<List<CompletableFuture<Void>>> stopFutures;
    private SchedulingStrategy schedulingStrategy;
    private ExecutionNode executionNode;
    private final Map<Thread, ActiveTask> activeThreads;
    private final int hashCode;
    private volatile boolean hasActiveThreads;
    private volatile int retryCount;
    private volatile Set<String> retriedRelationships;
    private volatile BackoffMechanism backoffMechanism;
    private volatile String maxBackoffPeriod;

    public StandardProcessorNode(LoggableComponent<Processor> processor, String uuid, ValidationContextFactory validationContextFactory, ProcessScheduler scheduler, ControllerServiceProvider controllerServiceProvider, ComponentVariableRegistry variableRegistry, ReloadComponent reloadComponent, ExtensionManager extensionManager, ValidationTrigger validationTrigger) {
        this(processor, uuid, validationContextFactory, scheduler, controllerServiceProvider, ((Processor)processor.getComponent()).getClass().getSimpleName(), ((Processor)processor.getComponent()).getClass().getCanonicalName(), variableRegistry, reloadComponent, extensionManager, validationTrigger, false);
    }

    public StandardProcessorNode(LoggableComponent<Processor> processor, String uuid, ValidationContextFactory validationContextFactory, ProcessScheduler scheduler, ControllerServiceProvider controllerServiceProvider, String componentType, String componentCanonicalClass, ComponentVariableRegistry variableRegistry, ReloadComponent reloadComponent, ExtensionManager extensionManager, ValidationTrigger validationTrigger, boolean isExtensionMissing) {
        block9: {
            super(uuid, validationContextFactory, controllerServiceProvider, componentType, componentCanonicalClass, variableRegistry, reloadComponent, extensionManager, validationTrigger, isExtensionMissing);
            this.versionedComponentId = new AtomicReference();
            this.runNanos = 0L;
            this.desiredState = ScheduledState.STOPPED;
            this.bulletinLevel = LogLevel.WARN;
            this.parameterReferences = Collections.emptyList();
            this.stopFutures = new AtomicReference(new ArrayList());
            this.activeThreads = new ConcurrentHashMap<Thread, ActiveTask>(48);
            this.hasActiveThreads = false;
            ProcessorDetails processorDetails = new ProcessorDetails(processor);
            this.processorRef = new AtomicReference<ProcessorDetails>(processorDetails);
            this.identifier = new AtomicReference<String>(uuid);
            this.destinations = new ConcurrentHashMap<Connection, Connectable>();
            this.connections = new ConcurrentHashMap<Relationship, Set<Connection>>();
            this.incomingConnections = new AtomicReference(new ArrayList());
            this.lossTolerant = new AtomicBoolean(false);
            this.undefinedRelationshipsToTerminate = new AtomicReference(Collections.emptySet());
            this.comments = new AtomicReference<String>("");
            this.schedulingPeriod = new AtomicReference<String>("0 sec");
            this.schedulingNanos = new AtomicLong(1L);
            this.yieldPeriod = new AtomicReference<String>(DEFAULT_YIELD_PERIOD);
            this.yieldNanos = Math.round(FormatUtils.getPreciseTimeDuration((String)DEFAULT_YIELD_PERIOD, (TimeUnit)TimeUnit.NANOSECONDS));
            this.yieldExpiration = new AtomicLong(0L);
            this.concurrentTaskCount = new AtomicInteger(1);
            this.position = new AtomicReference<Position>(new Position(0.0, 0.0));
            this.style = new AtomicReference(Collections.unmodifiableMap(new HashMap()));
            this.processGroup = new AtomicReference();
            this.processScheduler = scheduler;
            this.penalizationPeriod = new AtomicReference<String>(DEFAULT_PENALIZATION_PERIOD);
            this.schedulingStrategy = SchedulingStrategy.TIMER_DRIVEN;
            this.executionNode = this.isExecutionNodeRestricted() ? ExecutionNode.PRIMARY : ExecutionNode.ALL;
            this.hashCode = new HashCodeBuilder(7, 67).append(this.identifier).toHashCode();
            this.retryCount = 10;
            this.retriedRelationships = new HashSet<String>();
            this.backoffMechanism = DEFAULT_BACKOFF_MECHANISM;
            this.maxBackoffPeriod = "10 mins";
            try {
                if (!processorDetails.getProcClass().isAnnotationPresent(DefaultSchedule.class)) break block9;
                DefaultSchedule dsc = processorDetails.getProcClass().getAnnotation(DefaultSchedule.class);
                try {
                    this.setSchedulingStrategy(dsc.strategy());
                }
                catch (Throwable ex) {
                    LOG.error(String.format("Error while setting scheduling strategy from DefaultSchedule annotation: %s", ex.getMessage()), ex);
                }
                try {
                    this.setSchedulingPeriod(dsc.period());
                }
                catch (Throwable ex) {
                    this.setSchedulingStrategy(SchedulingStrategy.TIMER_DRIVEN);
                    LOG.error(String.format("Error while setting scheduling period from DefaultSchedule annotation: %s", ex.getMessage()), ex);
                }
                if (!processorDetails.isTriggeredSerially()) {
                    try {
                        this.setMaxConcurrentTasks(dsc.concurrentTasks());
                    }
                    catch (Throwable ex) {
                        LOG.error(String.format("Error while setting max concurrent tasks from DefaultSchedule annotation: %s", ex.getMessage()), ex);
                    }
                }
            }
            catch (Throwable ex) {
                LOG.error(String.format("Error while setting default schedule from DefaultSchedule annotation: %s", ex.getMessage()), ex);
            }
        }
    }

    public ConfigurableComponent getComponent() {
        return this.processorRef.get().getProcessor();
    }

    public TerminationAwareLogger getLogger() {
        return this.processorRef.get().getComponentLog();
    }

    public Object getRunnableComponent() {
        return this.getProcessor();
    }

    public BundleCoordinate getBundleCoordinate() {
        return this.processorRef.get().getBundleCoordinate();
    }

    public String getComments() {
        return this.comments.get();
    }

    public Authorizable getParentAuthorizable() {
        return this.getProcessGroup();
    }

    public Resource getResource() {
        return ResourceFactory.getComponentResource((ResourceType)ResourceType.Processor, (String)this.getIdentifier(), (String)this.getName());
    }

    public boolean isRestricted() {
        return this.getProcessor().getClass().isAnnotationPresent(Restricted.class);
    }

    public Class<?> getComponentClass() {
        return this.getProcessor().getClass();
    }

    public boolean isDeprecated() {
        return this.getProcessor().getClass().isAnnotationPresent(DeprecationNotice.class);
    }

    public synchronized void setComments(String comments) {
        this.comments.set(CharacterFilterUtils.filterInvalidXmlCharacters((String)comments));
    }

    public Position getPosition() {
        return this.position.get();
    }

    public synchronized void setPosition(Position position) {
        this.position.set(position);
    }

    public Map<String, String> getStyle() {
        return this.style.get();
    }

    public synchronized void setStyle(Map<String, String> style) {
        if (style != null) {
            this.style.set(Collections.unmodifiableMap(new HashMap<String, String>(style)));
        }
    }

    public String getIdentifier() {
        return this.identifier.get();
    }

    public boolean isLossTolerant() {
        return this.lossTolerant.get();
    }

    public boolean isIsolated() {
        return this.schedulingStrategy == SchedulingStrategy.PRIMARY_NODE_ONLY || this.executionNode == ExecutionNode.PRIMARY;
    }

    public boolean isTriggerWhenEmpty() {
        return this.processorRef.get().isTriggerWhenEmpty();
    }

    public boolean isSideEffectFree() {
        return this.processorRef.get().isSideEffectFree();
    }

    public boolean isSessionBatchingSupported() {
        return this.processorRef.get().isBatchSupported();
    }

    public boolean isTriggerWhenAnyDestinationAvailable() {
        return this.processorRef.get().isTriggerWhenAnyDestinationAvailable();
    }

    public boolean isExecutionNodeRestricted() {
        return this.processorRef.get().isExecutionNodeRestricted();
    }

    public synchronized void setLossTolerant(boolean lossTolerant) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify configuration of " + (Object)((Object)this) + " while the Processor is running");
        }
        this.lossTolerant.set(lossTolerant);
    }

    public boolean isAutoTerminated(Relationship relationship) {
        boolean markedAutoTerminate = relationship.isAutoTerminated() || this.undefinedRelationshipsToTerminate.get().contains(relationship);
        return markedAutoTerminate && this.getConnections(relationship).isEmpty();
    }

    public void setAutoTerminatedRelationships(Set<Relationship> terminate) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify configuration of " + (Object)((Object)this) + " while the Processor is running");
        }
        this.undefinedRelationshipsToTerminate.set(new HashSet<Relationship>(terminate));
        LOG.debug("Resetting Validation State of {} due to setting auto-terminated relationships", (Object)this);
        this.resetValidationState();
    }

    public Set<Relationship> getAutoTerminatedRelationships() {
        Set<Relationship> relationships = this.undefinedRelationshipsToTerminate.get();
        if (relationships == null) {
            relationships = new HashSet<Relationship>();
        }
        return Collections.unmodifiableSet(relationships);
    }

    public String getProcessorDescription() {
        Processor processor = this.processorRef.get().getProcessor();
        CapabilityDescription capDesc = processor.getClass().getAnnotation(CapabilityDescription.class);
        String description = null;
        if (capDesc != null) {
            description = capDesc.value();
        }
        return description;
    }

    public synchronized void setName(String name) {
        super.setName(name);
    }

    public long getSchedulingPeriod(TimeUnit timeUnit) {
        return timeUnit.convert(this.schedulingNanos.get(), TimeUnit.NANOSECONDS);
    }

    public boolean isEventDrivenSupported() {
        return this.processorRef.get().isEventDrivenSupported();
    }

    public synchronized void setSchedulingStrategy(SchedulingStrategy schedulingStrategy) {
        if (schedulingStrategy == SchedulingStrategy.EVENT_DRIVEN && !this.processorRef.get().isEventDrivenSupported()) {
            return;
        }
        this.schedulingStrategy = schedulingStrategy;
    }

    public SchedulingStrategy getSchedulingStrategy() {
        return this.schedulingStrategy;
    }

    public String getSchedulingPeriod() {
        return this.schedulingPeriod.get();
    }

    public synchronized void setSchedulingPeriod(String schedulingPeriod) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify configuration of " + (Object)((Object)this) + " while the Processor is running");
        }
        this.parameterReferences.forEach(parameterReference -> this.decrementReferenceCounts(parameterReference.getParameterName()));
        ExpressionLanguageAgnosticParameterParser parameterParser = new ExpressionLanguageAgnosticParameterParser();
        ParameterTokenList parameterTokenList = parameterParser.parseTokens(schedulingPeriod);
        this.parameterReferences = new ArrayList<ParameterReference>(parameterTokenList.toReferenceList());
        this.parameterReferences.forEach(parameterReference -> this.incrementReferenceCounts(parameterReference.getParameterName()));
        this.schedulingPeriod.set(schedulingPeriod);
    }

    public synchronized void setExecutionNode(ExecutionNode executionNode) {
        this.executionNode = this.isExecutionNodeRestricted() ? ExecutionNode.PRIMARY : executionNode;
    }

    public ExecutionNode getExecutionNode() {
        return this.executionNode;
    }

    public long getRunDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.runNanos, TimeUnit.NANOSECONDS);
    }

    public synchronized void setRunDuration(long duration, TimeUnit timeUnit) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Run Duration of " + (Object)((Object)this) + " cannot be set to a negative value; cannot set to " + timeUnit.toSeconds(duration) + " seconds");
        }
        this.runNanos = timeUnit.toNanos(duration);
    }

    public long getYieldPeriod(TimeUnit timeUnit) {
        TimeUnit unit = timeUnit == null ? DEFAULT_TIME_UNIT : timeUnit;
        return unit.convert(this.yieldNanos, TimeUnit.NANOSECONDS);
    }

    public String getYieldPeriod() {
        return this.yieldPeriod.get();
    }

    public synchronized void setYieldPeriod(String yieldPeriod) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify configuration of " + (Object)((Object)this) + " while the Processor is running");
        }
        long yieldNanos = FormatUtils.getTimeDuration((String)Objects.requireNonNull(yieldPeriod), (TimeUnit)TimeUnit.NANOSECONDS);
        if (yieldNanos < 0L) {
            throw new IllegalArgumentException("Yield duration of " + (Object)((Object)this) + " cannot be set to a negative value: " + yieldNanos + " nanos");
        }
        this.yieldPeriod.set(yieldPeriod);
        this.yieldNanos = yieldNanos;
    }

    public void yield() {
        Processor processor = this.processorRef.get().getProcessor();
        long yieldMillis = this.getYieldPeriod(TimeUnit.MILLISECONDS);
        this.yield(yieldMillis, TimeUnit.MILLISECONDS);
        String yieldDuration = yieldMillis > 1000L ? yieldMillis / 1000L + " seconds" : yieldMillis + " milliseconds";
        LoggerFactory.getLogger(processor.getClass()).trace("{} has chosen to yield its resources; will not be scheduled to run again for {}", (Object)processor, (Object)yieldDuration);
    }

    public void yield(long period, TimeUnit timeUnit) {
        long yieldMillis = TimeUnit.MILLISECONDS.convert(period, timeUnit);
        this.yieldExpiration.set(Math.max(this.yieldExpiration.get(), System.currentTimeMillis() + yieldMillis));
        this.processScheduler.yield((ProcessorNode)this);
    }

    public long getYieldExpiration() {
        return this.yieldExpiration.get();
    }

    public long getPenalizationPeriod(TimeUnit timeUnit) {
        return FormatUtils.getTimeDuration((String)this.getPenalizationPeriod(), (TimeUnit)(timeUnit == null ? DEFAULT_TIME_UNIT : timeUnit));
    }

    public String getPenalizationPeriod() {
        return this.penalizationPeriod.get();
    }

    public synchronized void setPenalizationPeriod(String penalizationPeriod) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify configuration of " + (Object)((Object)this) + " while the Processor is running");
        }
        long penalizationMillis = FormatUtils.getTimeDuration((String)Objects.requireNonNull(penalizationPeriod), (TimeUnit)TimeUnit.MILLISECONDS);
        if (penalizationMillis < 0L) {
            throw new IllegalArgumentException("Penalization duration of " + (Object)((Object)this) + " cannot be set to a negative value: " + penalizationMillis + " millis");
        }
        this.penalizationPeriod.set(penalizationPeriod);
    }

    public synchronized void setMaxConcurrentTasks(int taskCount) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify configuration of " + (Object)((Object)this) + " while the Processor is running");
        }
        if (taskCount < 1 && this.getSchedulingStrategy() != SchedulingStrategy.EVENT_DRIVEN) {
            throw new IllegalArgumentException("Cannot set Concurrent Tasks to " + taskCount + " for component " + (Object)((Object)this) + " because Scheduling Strategy is not Event Driven");
        }
        if (!this.isTriggeredSerially()) {
            this.concurrentTaskCount.set(taskCount);
        }
    }

    public boolean isTriggeredSerially() {
        return this.processorRef.get().isTriggeredSerially();
    }

    public int getMaxConcurrentTasks() {
        return this.concurrentTaskCount.get();
    }

    public LogLevel getBulletinLevel() {
        return this.bulletinLevel;
    }

    public synchronized void setBulletinLevel(LogLevel level) {
        LogRepositoryFactory.getRepository((String)this.getIdentifier()).setObservationLevel(BULLETIN_OBSERVER_ID, level);
        this.bulletinLevel = level;
    }

    public Set<Connection> getConnections() {
        HashSet<Connection> allConnections = new HashSet<Connection>();
        for (Set<Connection> connectionSet : this.connections.values()) {
            allConnections.addAll(connectionSet);
        }
        return allConnections;
    }

    public List<Connection> getIncomingConnections() {
        return this.incomingConnections.get();
    }

    public Set<Connection> getConnections(Relationship relationship) {
        Set<Connection> applicableConnections = this.connections.get(relationship);
        return applicableConnections == null ? Collections.emptySet() : Collections.unmodifiableSet(applicableConnections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Connection connection) {
        Objects.requireNonNull(connection, "connection cannot be null");
        if (!connection.getSource().equals((Object)this) && !connection.getDestination().equals((Object)this)) {
            throw new IllegalStateException("Cannot add a connection to " + (Object)((Object)this) + " because the ProcessorNode is neither the Source nor the Destination");
        }
        try {
            Object incomingConnections;
            ArrayList<Connection> updatedIncoming = null;
            if (connection.getDestination().equals((Object)this) && !(updatedIncoming = new ArrayList<Connection>((Collection<Connection>)(incomingConnections = this.getIncomingConnections()))).contains(connection)) {
                updatedIncoming.add(connection);
            }
            if (connection.getSource().equals((Object)this) && !this.destinations.containsKey(connection)) {
                for (Relationship relationship : connection.getRelationships()) {
                    Relationship rel = this.getRelationship(relationship.getName());
                    Set<Connection> set = this.connections.get(rel);
                    if (set == null) {
                        set = new HashSet<Connection>();
                        this.connections.put(rel, set);
                    }
                    set.add(connection);
                    this.destinations.put(connection, connection.getDestination());
                }
                Set<Relationship> autoTerminated = this.undefinedRelationshipsToTerminate.get();
                if (autoTerminated != null) {
                    autoTerminated.removeAll(connection.getRelationships());
                    this.undefinedRelationshipsToTerminate.set(autoTerminated);
                }
            }
            if (updatedIncoming != null) {
                this.setIncomingConnections(Collections.unmodifiableList(updatedIncoming));
            }
        }
        finally {
            LOG.debug("Resetting Validation State of {} due to connection added", (Object)this);
            this.resetValidationState();
        }
    }

    public boolean hasIncomingConnection() {
        return !this.getIncomingConnections().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnection(Connection connection) throws IllegalStateException {
        try {
            if (Objects.requireNonNull(connection).getSource().equals((Object)this)) {
                ArrayList<Relationship> existingRelationships = new ArrayList<Relationship>();
                for (Map.Entry<Relationship, Set<Connection>> entry : this.connections.entrySet()) {
                    if (!entry.getValue().contains(connection)) continue;
                    existingRelationships.add(entry.getKey());
                }
                for (Relationship relationship : connection.getRelationships()) {
                    Set<Connection> connectionsForRelationship;
                    if (existingRelationships.contains(relationship) || (connectionsForRelationship = this.getConnections(relationship)) == null || connectionsForRelationship.size() != 1 || !this.isRunning() || this.isAutoTerminated(relationship) || !this.getRelationships().contains(relationship)) continue;
                    throw new IllegalStateException("Cannot remove relationship " + relationship.getName() + " from Connection " + connection + " because doing so would invalidate " + (Object)((Object)this) + ", which is currently running");
                }
                for (Set set : this.connections.values()) {
                    set.remove(connection);
                }
                for (Relationship relationship : connection.getRelationships()) {
                    Set<Connection> set = this.connections.get(relationship);
                    if (set == null) {
                        set = new HashSet<Connection>();
                        this.connections.put(relationship, set);
                    }
                    set.add(connection);
                }
                this.destinations.put(connection, connection.getDestination());
                Set<Relationship> autoTerminated = this.undefinedRelationshipsToTerminate.get();
                if (autoTerminated != null) {
                    autoTerminated.removeAll(connection.getRelationships());
                    this.undefinedRelationshipsToTerminate.set(autoTerminated);
                }
            }
            if (connection.getDestination().equals((Object)this)) {
                List<Connection> incomingConnections = this.getIncomingConnections();
                ArrayList<Connection> updatedIncoming = new ArrayList<Connection>(incomingConnections);
                updatedIncoming.remove(connection);
                updatedIncoming.add(connection);
                this.setIncomingConnections(Collections.unmodifiableList(updatedIncoming));
            }
        }
        finally {
            LOG.debug("Resetting Validation State of {} due to updating connection", (Object)this);
            this.resetValidationState();
        }
    }

    public void removeConnection(Connection connection) {
        List<Connection> incomingConnections;
        boolean connectionRemoved = false;
        if (Objects.requireNonNull(connection).getSource().equals((Object)this)) {
            for (Relationship relationship : connection.getRelationships()) {
                Set<Connection> connectionsForRelationship = this.getConnections(relationship);
                if (connectionsForRelationship != null && connectionsForRelationship.size() > 1 || !this.isRunning()) continue;
                throw new IllegalStateException(connection + " cannot be removed because its source is running and removing it will invalidate " + (Object)((Object)this));
            }
            for (Set set : this.connections.values()) {
                set.remove(connection);
            }
            boolean bl = connectionRemoved = this.destinations.remove(connection) != null;
        }
        if (connection.getDestination().equals((Object)this) && (incomingConnections = this.getIncomingConnections()).contains(connection)) {
            ArrayList<Connection> arrayList = new ArrayList<Connection>(incomingConnections);
            arrayList.remove(connection);
            this.setIncomingConnections(Collections.unmodifiableList(arrayList));
            return;
        }
        if (!connectionRemoved) {
            throw new IllegalArgumentException("Cannot remove " + connection + " from " + (Object)((Object)this) + " because the ProcessorNode is not the Source");
        }
        LOG.debug("Resetting Validation State of {} due to connection removed", (Object)this);
        this.resetValidationState();
    }

    private void setIncomingConnections(List<Connection> incoming) {
        this.incomingConnections.set(incoming);
        LOG.debug("Resetting Validation State of {} due to setting incoming connections", (Object)this);
        this.resetValidationState();
    }

    public Relationship getRelationship(String relationshipName) {
        Set relationships;
        Relationship specRel;
        Relationship returnRel = specRel = new Relationship.Builder().name(relationshipName).build();
        Processor processor = this.processorRef.get().getProcessor();
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), processor.getClass(), (String)processor.getIdentifier());){
            relationships = processor.getRelationships();
        }
        for (Relationship rel : relationships) {
            if (!rel.equals((Object)specRel)) continue;
            returnRel = rel;
            break;
        }
        return returnRel;
    }

    public Processor getProcessor() {
        return this.processorRef.get().getProcessor();
    }

    public synchronized void setProcessor(LoggableComponent<Processor> processor) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify configuration of " + (Object)((Object)this) + " while the Processor is running");
        }
        ProcessorDetails processorDetails = new ProcessorDetails(processor);
        this.processorRef.set(processorDetails);
    }

    public synchronized void reload(Set<URL> additionalUrls) throws ProcessorInstantiationException {
        String additionalResourcesFingerprint = ClassLoaderUtils.generateAdditionalUrlsFingerprint(additionalUrls, (String)this.determineClasloaderIsolationKey());
        this.setAdditionalResourcesFingerprint(additionalResourcesFingerprint);
        this.getReloadComponent().reload((ProcessorNode)this, this.getCanonicalClassName(), this.getBundleCoordinate(), additionalUrls);
    }

    public Set<Connectable> getDestinations() {
        HashSet<Connectable> nonSelfDestinations = new HashSet<Connectable>();
        for (Connectable connectable : this.destinations.values()) {
            if (connectable == this) continue;
            nonSelfDestinations.add(connectable);
        }
        return nonSelfDestinations;
    }

    public Set<Connectable> getDestinations(Relationship relationship) {
        HashSet<Connectable> destinationSet = new HashSet<Connectable>();
        Set<Connection> relationshipConnections = this.connections.get(relationship);
        if (relationshipConnections != null) {
            for (Connection connection : relationshipConnections) {
                destinationSet.add(this.destinations.get(connection));
            }
        }
        return destinationSet;
    }

    public Set<Relationship> getUndefinedRelationships() {
        Set relationships;
        HashSet<Relationship> undefined = new HashSet<Relationship>();
        Processor processor = this.processorRef.get().getProcessor();
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), processor.getClass(), (String)processor.getIdentifier());){
            relationships = processor.getRelationships();
        }
        if (relationships == null) {
            return undefined;
        }
        for (Relationship relation : relationships) {
            Set<Connection> connectionSet = this.connections.get(relation);
            if (connectionSet != null && !connectionSet.isEmpty()) continue;
            undefined.add(relation);
        }
        return undefined;
    }

    boolean isRelated(ProcessorNode node) {
        return this.destinations.containsValue(node);
    }

    public boolean isRunning() {
        return this.getScheduledState().equals((Object)ScheduledState.RUNNING) || this.hasActiveThreads;
    }

    public boolean isValidationNecessary() {
        switch (this.getPhysicalScheduledState()) {
            case STOPPED: 
            case STOPPING: 
            case STARTING: {
                return true;
            }
        }
        return false;
    }

    public int getActiveThreadCount() {
        int activeThreadCount = this.processScheduler.getActiveThreadCount((Object)this);
        if (activeThreadCount == 0 && this.getPhysicalScheduledState() == ScheduledState.STOPPING) {
            return 1;
        }
        return activeThreadCount;
    }

    List<Connection> getIncomingNonLoopConnections() {
        List<Connection> connections = this.getIncomingConnections();
        ArrayList<Connection> nonLoopConnections = new ArrayList<Connection>(connections.size());
        for (Connection connection : connections) {
            if (connection.getSource().equals((Object)this)) continue;
            nonLoopConnections.add(connection);
        }
        return nonLoopConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigVerificationResult> verifyConfiguration(ProcessContext context, ComponentLog logger, Map<String, String> attributes, ExtensionManager extensionManager) {
        ArrayList<ConfigVerificationResult> results;
        block33: {
            results = new ArrayList<ConfigVerificationResult>();
            try {
                this.verifyCanPerformVerification();
                long startNanos = System.nanoTime();
                results.addAll(super.verifyConfig(context.getProperties(), context.getAnnotationData(), this.getProcessGroup().getParameterContext()));
                long validationComplete = System.nanoTime();
                if (!results.isEmpty() && results.stream().anyMatch(result -> result.getOutcome() == ConfigVerificationResult.Outcome.FAILED)) {
                    return results;
                }
                Processor processor = this.getProcessor();
                if (processor instanceof VerifiableProcessor) {
                    block32: {
                        LOG.debug("{} is a VerifiableProcessor. Will perform full verification of configuration.", (Object)this);
                        VerifiableProcessor verifiable = (VerifiableProcessor)this.getProcessor();
                        boolean classpathDifferent = this.isClasspathDifferent(context.getProperties());
                        if (classpathDifferent) {
                            Bundle bundle = extensionManager.getBundle(this.getBundleCoordinate());
                            Set classpathUrls = this.getAdditionalClasspathResources(context.getProperties().keySet(), descriptor -> context.getProperty(descriptor).getValue());
                            String classloaderIsolationKey = this.getClassLoaderIsolationKey((PropertyContext)context);
                            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
                            try (InstanceClassLoader detectedClassLoader = extensionManager.createInstanceClassLoader(this.getComponentType(), this.getIdentifier(), bundle, classpathUrls, false, classloaderIsolationKey);){
                                Thread.currentThread().setContextClassLoader((ClassLoader)detectedClassLoader);
                                results.addAll(verifiable.verify(context, logger, attributes));
                                break block32;
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(currentClassLoader);
                            }
                        }
                        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, processor.getClass(), (String)this.getIdentifier());){
                            results.addAll(verifiable.verify(context, logger, attributes));
                        }
                    }
                    long validationNanos = validationComplete - startNanos;
                    long verificationNanos = System.nanoTime() - validationComplete;
                    LOG.debug("{} completed full configuration validation in {} plus {} for validation", new Object[]{this, FormatUtils.formatNanos((long)verificationNanos, (boolean)false), FormatUtils.formatNanos((long)validationNanos, (boolean)false)});
                    break block33;
                }
                LOG.debug("{} is not a VerifiableProcessor, so will not perform full verification of configuration. Validation took {}", (Object)this, (Object)FormatUtils.formatNanos((long)(validationComplete - startNanos), (boolean)false));
            }
            catch (Throwable t) {
                LOG.error("Failed to perform verification of processor's configuration for {}", (Object)this, (Object)t);
                results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Perform Verification").explanation("Encountered unexpected failure when attempting to perform verification: " + t).build());
            }
        }
        return results;
    }

    public Collection<ValidationResult> getValidationErrors() {
        ValidationState validationState = this.getValidationState();
        return validationState.getValidationErrors();
    }

    protected Collection<ValidationResult> computeValidationErrors(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        try {
            Collection validationResults = super.computeValidationErrors(validationContext);
            validationResults.stream().filter(result -> !result.isValid()).forEach(results::add);
            if (validationContext.isValidateConnections()) {
                for (Relationship relationship : this.getUndefinedRelationships()) {
                    if (this.isAutoTerminated(relationship)) continue;
                    ValidationResult error = new ValidationResult.Builder().explanation("Relationship '" + relationship.getName() + "' is not connected to any component and is not auto-terminated").subject("Relationship " + relationship.getName()).valid(false).build();
                    results.add(error);
                }
                switch (this.getInputRequirement()) {
                    case INPUT_ALLOWED: {
                        break;
                    }
                    case INPUT_FORBIDDEN: {
                        int incomingConnCount = this.getIncomingNonLoopConnections().size();
                        if (incomingConnCount == 0) break;
                        results.add(new ValidationResult.Builder().explanation("Processor does not allow upstream connections but currently has " + incomingConnCount).subject("Upstream Connections").valid(false).build());
                        break;
                    }
                    case INPUT_REQUIRED: {
                        if (!this.getIncomingNonLoopConnections().isEmpty()) break;
                        results.add(new ValidationResult.Builder().explanation("Processor requires an upstream connection but currently has none").subject("Upstream Connections").valid(false).build());
                    }
                }
            }
            if (this.getExecutionNode() == ExecutionNode.PRIMARY && this.hasIncomingConnection()) {
                results.add(new ValidationResult.Builder().explanation("Processors with incoming connections cannot be scheduled for Primary Node Only.").subject("Execution Node").valid(false).build());
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to perform validation", t);
            results.add(new ValidationResult.Builder().explanation("Failed to run validation due to " + t.toString()).valid(false).build());
        }
        return results;
    }

    public List<ValidationResult> validateConfig() {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        ParameterContext parameterContext = this.getParameterContext();
        if (parameterContext == null && !this.parameterReferences.isEmpty()) {
            results.add(new ValidationResult.Builder().subject(RUN_SCHEDULE).input("Parameter Context").valid(false).explanation("Processor configuration references one or more Parameters but no Parameter Context is currently set on the Process Group.").build());
        } else {
            for (ParameterReference paramRef : this.parameterReferences) {
                Optional parameterRef = parameterContext.getParameter(paramRef.getParameterName());
                if (!parameterRef.isPresent()) {
                    results.add(new ValidationResult.Builder().subject(RUN_SCHEDULE).input(paramRef.getParameterName()).valid(false).explanation("Processor configuration references Parameter '" + paramRef.getParameterName() + "' but the currently selected Parameter Context does not have a Parameter with that name").build());
                    continue;
                }
                ParameterDescriptor parameterDescriptor = ((Parameter)parameterRef.get()).getDescriptor();
                if (!parameterDescriptor.isSensitive()) continue;
                results.add(new ValidationResult.Builder().subject(RUN_SCHEDULE).input(parameterDescriptor.getName()).valid(false).explanation("Processor configuration cannot reference sensitive parameters").build());
            }
            String schedulingPeriod = this.getSchedulingPeriod();
            String evaluatedSchedulingPeriod = this.evaluateParameters(schedulingPeriod);
            if (evaluatedSchedulingPeriod != null) {
                switch (this.schedulingStrategy) {
                    case CRON_DRIVEN: {
                        try {
                            new CronExpression(evaluatedSchedulingPeriod);
                        }
                        catch (Exception e) {
                            results.add(new ValidationResult.Builder().subject(RUN_SCHEDULE).input(schedulingPeriod).valid(false).explanation("Scheduling Period is not a valid cron expression").build());
                        }
                        break;
                    }
                    case PRIMARY_NODE_ONLY: 
                    case TIMER_DRIVEN: {
                        try {
                            long schedulingNanos = FormatUtils.getTimeDuration((String)Objects.requireNonNull(evaluatedSchedulingPeriod), (TimeUnit)TimeUnit.NANOSECONDS);
                            if (schedulingNanos < 0L) {
                                results.add(new ValidationResult.Builder().subject(RUN_SCHEDULE).input(schedulingPeriod).valid(false).explanation("Scheduling Period must be positive").build());
                            }
                            this.schedulingNanos.set(Math.max(1L, schedulingNanos));
                        }
                        catch (Exception e) {
                            results.add(new ValidationResult.Builder().subject(RUN_SCHEDULE).input(schedulingPeriod).valid(false).explanation("Scheduling Period is not a valid time duration").build());
                        }
                        break;
                    }
                    default: {
                        return results;
                    }
                }
            }
        }
        return results;
    }

    public InputRequirement.Requirement getInputRequirement() {
        return this.processorRef.get().getInputRequirement();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ProcessorNode)) {
            return false;
        }
        ProcessorNode on = (ProcessorNode)other;
        return new EqualsBuilder().append((Object)this.identifier.get(), (Object)on.getIdentifier()).isEquals();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Collection<Relationship> getRelationships() {
        Processor processor = this.processorRef.get().getProcessor();
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), processor.getClass(), (String)processor.getIdentifier());){
            Set set = this.getProcessor().getRelationships();
            return set;
        }
    }

    public String toString() {
        Processor processor = this.processorRef.get().getProcessor();
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), processor.getClass(), (String)processor.getIdentifier());){
            String string = this.getProcessor().toString();
            return string;
        }
    }

    public ProcessGroup getProcessGroup() {
        return this.processGroup.get();
    }

    protected ParameterContext getParameterContext() {
        ProcessGroup processGroup = this.getProcessGroup();
        return processGroup == null ? null : processGroup.getParameterContext();
    }

    public ParameterLookup getParameterLookup() {
        return this.getParameterContext();
    }

    public synchronized void setProcessGroup(ProcessGroup group) {
        this.processGroup.set(group);
        LOG.debug("Resetting Validation State of {} due to setting process group", (Object)this);
        this.resetValidationState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) {
        Processor processor = this.processorRef.get().getProcessor();
        this.activateThread();
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), processor.getClass(), (String)processor.getIdentifier());){
            processor.onTrigger(context, sessionFactory);
        }
        finally {
            this.deactivateThread();
        }
    }

    public ConnectableType getConnectableType() {
        return ConnectableType.PROCESSOR;
    }

    public void setAnnotationData(String data) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot set AnnotationData on " + (Object)((Object)this) + " while processor is running");
        }
        super.setAnnotationData(data);
    }

    public void verifyCanDelete() throws IllegalStateException {
        this.verifyCanDelete(false);
    }

    public void verifyCanDelete(boolean ignoreConnections) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot delete " + (Object)((Object)this) + " because Processor is running");
        }
        if (!ignoreConnections) {
            for (Set<Connection> connectionSet : this.connections.values()) {
                for (Connection connection : connectionSet) {
                    connection.verifyCanDelete();
                }
            }
            for (Connection connection : this.getIncomingConnections()) {
                if (connection.getSource().equals((Object)this)) {
                    connection.verifyCanDelete();
                    continue;
                }
                throw new IllegalStateException("Cannot delete " + (Object)((Object)this) + " because it is the destination of another component");
            }
        }
    }

    public void verifyCanStart() {
        this.verifyCanStart(null);
    }

    public void verifyCanStart(Set<ControllerServiceNode> ignoredReferences) {
        ScheduledState currentState = this.getPhysicalScheduledState();
        if (currentState != ScheduledState.STOPPED && currentState != ScheduledState.DISABLED) {
            throw new IllegalStateException((Object)((Object)this) + " cannot be started because it is not stopped. Current state is " + currentState.name());
        }
        this.verifyNoActiveThreads();
        switch (this.getValidationStatus()) {
            case VALID: {
                return;
            }
            case VALIDATING: {
                throw new IllegalStateException((Object)((Object)this) + " cannot be started because its validation is still being performed");
            }
        }
        Collection validationErrors = this.getValidationErrors(ignoredReferences);
        if (ignoredReferences != null && !validationErrors.isEmpty()) {
            throw new IllegalStateException((Object)((Object)this) + " cannot be started because it is not currently valid");
        }
    }

    public void verifyCanStop() {
        if (this.getScheduledState() != ScheduledState.RUNNING) {
            throw new IllegalStateException((Object)((Object)this) + " cannot be stopped because is not scheduled to run");
        }
    }

    public void verifyCanUpdate() {
        if (this.isRunning()) {
            throw new IllegalStateException((Object)((Object)this) + " cannot be updated because it is not stopped");
        }
    }

    public void verifyCanEnable() {
        if (this.getScheduledState() != ScheduledState.DISABLED) {
            throw new IllegalStateException((Object)((Object)this) + " cannot be enabled because is not disabled");
        }
        this.verifyNoActiveThreads();
    }

    public void verifyCanDisable() {
        if (this.getScheduledState() != ScheduledState.STOPPED) {
            throw new IllegalStateException((Object)((Object)this) + " cannot be disabled because is not stopped");
        }
        this.verifyNoActiveThreads();
    }

    public void verifyCanClearState() throws IllegalStateException {
        this.verifyCanUpdate();
    }

    private void verifyNoActiveThreads() throws IllegalStateException {
        int threadCount;
        if (this.hasActiveThreads && (threadCount = this.getActiveThreadCount()) > 0) {
            throw new IllegalStateException((Object)((Object)this) + " has " + threadCount + " threads still active");
        }
    }

    public void verifyModifiable() throws IllegalStateException {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify configuration of " + (Object)((Object)this) + " while the Processor is running");
        }
    }

    public void enable() {
        this.desiredState = ScheduledState.STOPPED;
        boolean updated = this.scheduledState.compareAndSet(ScheduledState.DISABLED, ScheduledState.STOPPED);
        if (updated) {
            LOG.info("{} enabled so ScheduledState transitioned from DISABLED to STOPPED", (Object)this);
        } else {
            LOG.info("{} enabled but not currently DISABLED so set desired state to STOPPED; current state is {}", (Object)this, this.scheduledState.get());
        }
    }

    public void disable() {
        this.desiredState = ScheduledState.DISABLED;
        boolean updated = this.scheduledState.compareAndSet(ScheduledState.STOPPED, ScheduledState.DISABLED);
        if (updated) {
            LOG.info("{} disabled so ScheduledState transitioned from STOPPED to DISABLED", (Object)this);
        } else {
            LOG.info("{} disabled but not currently STOPPED so set desired state to DISABLED; current state is {}", (Object)this, this.scheduledState.get());
        }
    }

    public void start(ScheduledExecutorService taskScheduler, long administrativeYieldMillis, long timeoutMillis, Supplier<ProcessContext> processContextFactory, SchedulingAgentCallback schedulingAgentCallback, boolean failIfStopping) {
        this.run(taskScheduler, administrativeYieldMillis, timeoutMillis, processContextFactory, schedulingAgentCallback, failIfStopping, ScheduledState.RUNNING, ScheduledState.STARTING);
    }

    public void runOnce(ScheduledExecutorService taskScheduler, long administrativeYieldMillis, long timeoutMillis, Supplier<ProcessContext> processContextFactory, SchedulingAgentCallback schedulingAgentCallback) {
        this.run(taskScheduler, administrativeYieldMillis, timeoutMillis, processContextFactory, schedulingAgentCallback, true, ScheduledState.RUN_ONCE, ScheduledState.RUN_ONCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(ScheduledExecutorService taskScheduler, long administrativeYieldMillis, long timeoutMillis, Supplier<ProcessContext> processContextFactory, SchedulingAgentCallback schedulingAgentCallback, boolean failIfStopping, ScheduledState desiredState, ScheduledState scheduledState) {
        boolean starting;
        ScheduledState currentState;
        Processor processor = this.processorRef.get().getProcessor();
        SimpleProcessLogger procLog = new SimpleProcessLogger(this.getIdentifier(), processor, (LoggingContext)new StandardLoggingContext((GroupedComponent)this));
        LOG.info("Starting {}", (Object)this);
        StandardProcessorNode standardProcessorNode = this;
        synchronized (standardProcessorNode) {
            currentState = (ScheduledState)this.scheduledState.get();
            if (currentState == ScheduledState.STOPPED) {
                starting = this.scheduledState.compareAndSet(ScheduledState.STOPPED, scheduledState);
                if (starting) {
                    this.desiredState = desiredState;
                }
            } else {
                if (currentState == ScheduledState.STOPPING && !failIfStopping) {
                    this.desiredState = desiredState;
                    return;
                }
                starting = false;
            }
        }
        if (starting) {
            this.initiateStart(taskScheduler, administrativeYieldMillis, timeoutMillis, new AtomicLong(0L), processContextFactory, schedulingAgentCallback);
        } else {
            String procName = this.processorRef.get().getProcessor().toString();
            procLog.warn("Cannot start {} because it is not currently stopped. Current state is {}", new Object[]{procName, currentState});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPrimaryNodeChanged(PrimaryNodeState nodeState, LifecycleState lifecycleState) {
        Class<?> implClass = this.getProcessor().getClass();
        List<Method> methods = ReflectionUtils.findMethodsWithAnnotations(implClass, new Class[]{OnPrimaryNodeStateChange.class});
        if (methods.isEmpty()) {
            return;
        }
        lifecycleState.incrementActiveThreadCount(null);
        this.activateThread();
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), implClass, (String)this.getIdentifier());){
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnPrimaryNodeStateChange.class, (Object)this.getProcessor(), nodeState);
        }
        finally {
            this.deactivateThread();
            lifecycleState.decrementActiveThreadCount();
        }
    }

    private void activateThread() {
        Thread thread = Thread.currentThread();
        Long timestamp = System.currentTimeMillis();
        this.activeThreads.put(thread, new ActiveTask(timestamp));
    }

    private void deactivateThread() {
        this.activeThreads.remove(Thread.currentThread());
    }

    public List<ActiveThreadInfo> getActiveThreads(ThreadDetails threadDetails) {
        long now = System.currentTimeMillis();
        Map threadInfoMap = Stream.of(threadDetails.getThreadInfos()).collect(Collectors.toMap(ThreadInfo::getThreadId, Function.identity(), (a, b) -> a));
        ArrayList<ActiveThreadInfo> threadList = new ArrayList<ActiveThreadInfo>(this.activeThreads.size());
        for (Map.Entry<Thread, ActiveTask> entry : this.activeThreads.entrySet()) {
            Thread thread = entry.getKey();
            ActiveTask activeTask = entry.getValue();
            Long timestamp = activeTask.getStartTime();
            long activeMillis = now - timestamp;
            ThreadInfo threadInfo = (ThreadInfo)threadInfoMap.get(thread.getId());
            String stackTrace = ThreadUtils.createStackTrace(threadInfo, threadDetails.getDeadlockedThreadIds(), threadDetails.getMonitorDeadlockThreadIds());
            ActiveThreadInfo activeThreadInfo = new ActiveThreadInfo(thread.getName(), stackTrace, activeMillis, activeTask.isTerminated());
            threadList.add(activeThreadInfo);
        }
        return threadList;
    }

    public int getTerminatedThreadCount() {
        int count = 0;
        for (ActiveTask task : this.activeThreads.values()) {
            if (!task.isTerminated()) continue;
            ++count;
        }
        return count;
    }

    public int terminate() {
        this.verifyCanTerminate();
        int count = 0;
        for (Map.Entry<Thread, ActiveTask> entry : this.activeThreads.entrySet()) {
            Thread thread = entry.getKey();
            ActiveTask activeTask = entry.getValue();
            if (!activeTask.isTerminated()) {
                activeTask.terminate();
                thread.setName(thread.getName() + " <Terminated Task>");
                ++count;
            }
            thread.interrupt();
        }
        this.getLogger().terminate();
        this.completeStopAction();
        return count;
    }

    public boolean isTerminated(Thread thread) {
        ActiveTask activeTask = this.activeThreads.get(thread);
        if (activeTask == null) {
            return false;
        }
        return activeTask.isTerminated();
    }

    public void verifyCanTerminate() {
        ScheduledState state = this.getScheduledState();
        if (state != ScheduledState.STOPPED && state != ScheduledState.RUN_ONCE) {
            throw new IllegalStateException("Cannot terminate " + (Object)((Object)this) + " because Processor is not stopped");
        }
    }

    private void initiateStart(ScheduledExecutorService taskScheduler, long administrativeYieldMillis, long timeoutMilis, AtomicLong startupAttemptCount, Supplier<ProcessContext> processContextFactory, SchedulingAgentCallback schedulingAgentCallback) {
        Future taskFuture;
        Processor processor = this.getProcessor();
        SimpleProcessLogger procLog = new SimpleProcessLogger(this.getIdentifier(), processor, (LoggingContext)new StandardLoggingContext((GroupedComponent)this));
        final AtomicLong completionTimestampRef = new AtomicLong(Long.MAX_VALUE);
        Callable<Void> startupTask = () -> {
            block45: {
                ScheduledState currentScheduleState = (ScheduledState)this.scheduledState.get();
                if (currentScheduleState == ScheduledState.STOPPING || currentScheduleState == ScheduledState.STOPPED || this.getDesiredState() == ScheduledState.STOPPED) {
                    LOG.debug("{} is stopped. Will not call @OnScheduled lifecycle methods or begin trigger onTrigger() method", (Object)this);
                    schedulingAgentCallback.onTaskComplete();
                    this.completeStopAction();
                    return null;
                }
                ValidationStatus validationStatus = this.getValidationStatus();
                if (validationStatus != ValidationStatus.VALID) {
                    LOG.debug("Cannot start {} because Processor is currently not valid; will try again after 5 seconds", (Object)this);
                    startupAttemptCount.incrementAndGet();
                    if (startupAttemptCount.get() == 240L || startupAttemptCount.get() % 7200L == 0L) {
                        ValidationState validationState = this.getValidationState();
                        procLog.error("Encountering difficulty starting. (Validation State is {}: {}). Will continue trying to start.", new Object[]{validationState, validationState.getValidationErrors()});
                    }
                    Runnable initiateStartTask = () -> this.lambda$null$6(taskScheduler, administrativeYieldMillis, timeoutMilis, startupAttemptCount, (Supplier)processContextFactory, schedulingAgentCallback);
                    taskScheduler.schedule(initiateStartTask, 500L, TimeUnit.MILLISECONDS);
                    schedulingAgentCallback.onTaskComplete();
                    return null;
                }
                LOG.debug("Invoking @OnScheduled methods of {}", (Object)processor);
                completionTimestampRef.set(System.currentTimeMillis() + timeoutMilis);
                ProcessContext processContext = (ProcessContext)processContextFactory.get();
                try (NarCloseable nc = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), processor.getClass(), (String)processor.getIdentifier());){
                    try {
                        boolean disabled;
                        this.hasActiveThreads = true;
                        this.activateThread();
                        try {
                            ReflectionUtils.invokeMethodsWithAnnotation(OnScheduled.class, processor, processContext);
                        }
                        finally {
                            this.deactivateThread();
                        }
                        if (this.desiredState == ScheduledState.RUNNING && this.scheduledState.compareAndSet(ScheduledState.STARTING, ScheduledState.RUNNING) || this.desiredState == ScheduledState.RUN_ONCE && this.scheduledState.compareAndSet(ScheduledState.RUN_ONCE, ScheduledState.RUN_ONCE)) {
                            LOG.debug("Successfully completed the @OnScheduled methods of {}; will now start triggering processor to run", (Object)processor);
                            schedulingAgentCallback.trigger();
                            break block45;
                        }
                        LOG.info("Successfully invoked @OnScheduled methods of {} but scheduled state is no longer STARTING so will stop processor now; current state = {}, desired state = {}", new Object[]{processor, this.scheduledState.get(), this.desiredState});
                        this.activateThread();
                        try {
                            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnUnscheduled.class, (Object)processor, processContext);
                            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnStopped.class, (Object)processor, processContext);
                            this.hasActiveThreads = false;
                        }
                        finally {
                            this.deactivateThread();
                        }
                        this.completeStopAction();
                        if (this.desiredState == ScheduledState.DISABLED && (disabled = this.scheduledState.compareAndSet(ScheduledState.STOPPED, ScheduledState.DISABLED))) {
                            LOG.info("After stopping {}, determined that Desired State is DISABLED so disabled processor", (Object)processor);
                        }
                    }
                    finally {
                        schedulingAgentCallback.onTaskComplete();
                    }
                }
                catch (Exception e) {
                    Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
                    procLog.error("Failed to properly initialize Processor. If still scheduled to run, NiFi will attempt to initialize and run the Processor again after the 'Administrative Yield Duration' has elapsed. Failure is due to " + cause, cause);
                    try (NarCloseable nc2 = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), processor.getClass(), (String)processor.getIdentifier());){
                        this.activateThread();
                        try {
                            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnUnscheduled.class, (Object)processor, processContext);
                            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnStopped.class, (Object)processor, processContext);
                            this.hasActiveThreads = false;
                        }
                        finally {
                            this.deactivateThread();
                        }
                    }
                    if (this.scheduledState.get() != ScheduledState.STOPPING && this.scheduledState.get() != ScheduledState.RUN_ONCE) {
                        Runnable initiateStartTask = () -> this.lambda$null$7(taskScheduler, administrativeYieldMillis, timeoutMilis, startupAttemptCount, (Supplier)processContextFactory, schedulingAgentCallback);
                        taskScheduler.schedule(initiateStartTask, administrativeYieldMillis, TimeUnit.MILLISECONDS);
                    }
                    this.completeStopAction();
                }
            }
            return null;
        };
        try {
            taskFuture = schedulingAgentCallback.scheduleTask(startupTask);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            ValidationState validationState = this.getValidationState();
            LOG.error("Unable to start {}.  Last known validation state was {} : {}", new Object[]{this, validationState, validationState.getValidationErrors(), rejectedExecutionException});
            return;
        }
        final AtomicReference futureRef = new AtomicReference();
        Runnable monitoringTask = new Runnable(){

            @Override
            public void run() {
                Future monitoringFuture = (Future)futureRef.get();
                if (monitoringFuture == null) {
                    return;
                }
                StandardProcessorNode.this.monitorAsyncTask(taskFuture, monitoringFuture, completionTimestampRef.get());
            }
        };
        ScheduledFuture<?> future = taskScheduler.scheduleWithFixedDelay(monitoringTask, 1L, 10L, TimeUnit.MILLISECONDS);
        futureRef.set(future);
    }

    public CompletableFuture<Void> stop(final ProcessScheduler processScheduler, final ScheduledExecutorService executor, final ProcessContext processContext, final SchedulingAgent schedulingAgent, final LifecycleState lifecycleState) {
        final Processor processor = this.processorRef.get().getProcessor();
        LOG.info("Stopping processor: " + (Object)((Object)this));
        this.desiredState = ScheduledState.STOPPED;
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.addStopFuture(future);
        if (this.scheduledState.compareAndSet(ScheduledState.RUNNING, ScheduledState.STOPPING) || this.scheduledState.compareAndSet(ScheduledState.RUN_ONCE, ScheduledState.STOPPING)) {
            lifecycleState.incrementActiveThreadCount(null);
            executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block41: {
                        try {
                            boolean allThreadsComplete;
                            if (lifecycleState.isScheduled()) {
                                schedulingAgent.unschedule((Connectable)StandardProcessorNode.this, lifecycleState);
                                StandardProcessorNode.this.activateThread();
                                try (NarCloseable nc = NarCloseable.withComponentNarLoader((ExtensionManager)StandardProcessorNode.this.getExtensionManager(), processor.getClass(), (String)processor.getIdentifier());){
                                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnUnscheduled.class, (Object)processor, processContext);
                                }
                                finally {
                                    StandardProcessorNode.this.deactivateThread();
                                }
                            }
                            boolean bl = allThreadsComplete = lifecycleState.getActiveThreadCount() == 1;
                            if (allThreadsComplete) {
                                StandardProcessorNode.this.activateThread();
                                try (NarCloseable nc = NarCloseable.withComponentNarLoader((ExtensionManager)StandardProcessorNode.this.getExtensionManager(), processor.getClass(), (String)processor.getIdentifier());){
                                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnStopped.class, (Object)processor, processContext);
                                }
                                finally {
                                    StandardProcessorNode.this.deactivateThread();
                                }
                                lifecycleState.decrementActiveThreadCount();
                                StandardProcessorNode.this.completeStopAction();
                                ScheduledState desired = StandardProcessorNode.this.desiredState;
                                if (desired == ScheduledState.RUNNING) {
                                    LOG.info("Finished stopping {} but desired state is now RUNNING so will start processor", (Object)this);
                                    processScheduler.startProcessor((ProcessorNode)StandardProcessorNode.this, true);
                                } else if (desired == ScheduledState.DISABLED) {
                                    boolean updated = StandardProcessorNode.this.scheduledState.compareAndSet(ScheduledState.STOPPED, ScheduledState.DISABLED);
                                    if (updated) {
                                        LOG.info("Finished stopping {} but desired state is now DISABLED so disabled processor", (Object)this);
                                    } else {
                                        LOG.info("Finished stopping {} but desired state is now DISABLED. Scheduled State could not be transitioned from STOPPED to DISABLED, though, so will allow the other thread to finish state transition. Current state is {}", (Object)this, StandardProcessorNode.this.scheduledState.get());
                                    }
                                }
                                break block41;
                            }
                            executor.schedule(this, 100L, TimeUnit.MILLISECONDS);
                        }
                        catch (Exception e) {
                            LOG.warn("Failed while shutting down processor " + processor, (Throwable)e);
                        }
                    }
                }
            });
        } else {
            boolean updated = this.scheduledState.compareAndSet(ScheduledState.STARTING, ScheduledState.STOPPING);
            if (updated) {
                LOG.debug("Transitioned state of {} from STARTING to STOPPING", (Object)this);
            }
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeStopAction() {
        AtomicReference<List<CompletableFuture<Void>>> atomicReference = this.stopFutures;
        synchronized (atomicReference) {
            LOG.info("{} has completely stopped. Completing any associated Futures.", (Object)this);
            this.hasActiveThreads = false;
            this.scheduledState.set(ScheduledState.STOPPED);
            List futures = this.stopFutures.getAndSet(new ArrayList());
            futures.forEach(f -> f.complete(null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStopFuture(CompletableFuture<Void> future) {
        AtomicReference<List<CompletableFuture<Void>>> atomicReference = this.stopFutures;
        synchronized (atomicReference) {
            if (this.scheduledState.get() == ScheduledState.STOPPED) {
                future.complete(null);
            } else {
                this.stopFutures.get().add(future);
            }
        }
    }

    public ScheduledState getDesiredState() {
        return this.desiredState;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(Integer retryCount) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify configuration of " + (Object)((Object)this) + " while the Processor is running");
        }
        this.retryCount = retryCount == null ? 0 : retryCount;
    }

    public Set<String> getRetriedRelationships() {
        return this.retriedRelationships;
    }

    public void setRetriedRelationships(Set<String> retriedRelationships) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify configuration of " + (Object)((Object)this) + " while the Processor is running");
        }
        this.retriedRelationships = retriedRelationships == null ? Collections.emptySet() : new HashSet<String>(retriedRelationships);
    }

    public boolean isRelationshipRetried(Relationship relationship) {
        if (relationship == null) {
            return false;
        }
        return this.retriedRelationships.contains(relationship.getName());
    }

    public BackoffMechanism getBackoffMechanism() {
        return this.backoffMechanism;
    }

    public void setBackoffMechanism(BackoffMechanism backoffMechanism) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify configuration of " + (Object)((Object)this) + " while the Processor is running");
        }
        this.backoffMechanism = backoffMechanism == null ? BackoffMechanism.PENALIZE_FLOWFILE : backoffMechanism;
    }

    public String getMaxBackoffPeriod() {
        return this.maxBackoffPeriod;
    }

    public void setMaxBackoffPeriod(String maxBackoffPeriod) {
        long backoffNanos;
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify configuration of " + (Object)((Object)this) + " while the Processor is running");
        }
        if (maxBackoffPeriod == null) {
            maxBackoffPeriod = "10 mins";
        }
        if ((backoffNanos = FormatUtils.getTimeDuration((String)maxBackoffPeriod, (TimeUnit)TimeUnit.NANOSECONDS)) < 0L) {
            throw new IllegalArgumentException("Cannot set Max Backoff Period of " + (Object)((Object)this) + " to negative value: " + backoffNanos + " nanos");
        }
        this.maxBackoffPeriod = maxBackoffPeriod;
    }

    public String evaluateParameters(String value) {
        ParameterContext parameterContext = this.getParameterContext();
        ExpressionLanguageAgnosticParameterParser parameterParser = new ExpressionLanguageAgnosticParameterParser();
        ParameterTokenList parameterTokenList = parameterParser.parseTokens(value);
        return parameterTokenList.substitute((ParameterLookup)parameterContext);
    }

    private void monitorAsyncTask(Future<?> taskFuture, Future<?> monitoringFuture, long completionTimestamp) {
        if (taskFuture.isDone()) {
            monitoringFuture.cancel(false);
        } else if (System.currentTimeMillis() > completionTimestamp) {
            taskFuture.cancel(true);
            monitoringFuture.cancel(false);
            Processor processor = this.processorRef.get().getProcessor();
            LOG.warn("Timed out while waiting for OnScheduled of " + processor + " to finish. An attempt is made to cancel the task via Thread.interrupt(). However it does not guarantee that the task will be canceled since the code inside current OnScheduled operation may have been written to ignore interrupts which may result in a runaway thread. This could lead to more issues, eventually requiring NiFi to be restarted. This is usually a bug in the target Processor '" + processor + "' that needs to be documented, reported and eventually fixed.");
        }
    }

    public String getProcessGroupIdentifier() {
        ProcessGroup group = this.getProcessGroup();
        return group == null ? null : group.getIdentifier();
    }

    public Optional<String> getVersionedComponentId() {
        return Optional.ofNullable(this.versionedComponentId.get());
    }

    public void setVersionedComponentId(String versionedComponentId) {
        boolean updated = false;
        while (!updated) {
            String currentId = this.versionedComponentId.get();
            if (currentId == null) {
                updated = this.versionedComponentId.compareAndSet(null, versionedComponentId);
                continue;
            }
            if (currentId.equals(versionedComponentId)) {
                return;
            }
            if (versionedComponentId == null) {
                updated = this.versionedComponentId.compareAndSet(currentId, null);
                continue;
            }
            throw new IllegalStateException((Object)((Object)this) + " is already under version control");
        }
    }

    public void onConfigurationRestored(ProcessContext context) {
        try (NarCloseable nc = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), this.getProcessor().getClass(), (String)this.getProcessor().getIdentifier());){
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)this.getProcessor(), context);
        }
        this.updateControllerServiceReferences();
    }

    private void updateControllerServiceReferences() {
        for (Map.Entry entry : this.getProperties().entrySet()) {
            ControllerServiceNode serviceNode;
            String propertyValue;
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            PropertyConfiguration propertyConfiguration = (PropertyConfiguration)entry.getValue();
            if (descriptor.getControllerServiceDefinition() == null || propertyConfiguration == null || (propertyValue = propertyConfiguration.getEffectiveValue(this.getParameterLookup())) == null || (serviceNode = this.getControllerServiceProvider().getControllerServiceNode(propertyValue)) == null) continue;
            serviceNode.removeReference((ComponentNode)this, descriptor);
            serviceNode.addReference((ComponentNode)this, descriptor);
        }
    }

    private /* synthetic */ void lambda$null$7(ScheduledExecutorService taskScheduler, long administrativeYieldMillis, long timeoutMilis, AtomicLong startupAttemptCount, Supplier processContextFactory, SchedulingAgentCallback schedulingAgentCallback) {
        this.initiateStart(taskScheduler, administrativeYieldMillis, timeoutMilis, startupAttemptCount, processContextFactory, schedulingAgentCallback);
    }

    private /* synthetic */ void lambda$null$6(ScheduledExecutorService taskScheduler, long administrativeYieldMillis, long timeoutMilis, AtomicLong startupAttemptCount, Supplier processContextFactory, SchedulingAgentCallback schedulingAgentCallback) {
        this.initiateStart(taskScheduler, administrativeYieldMillis, timeoutMilis, startupAttemptCount, processContextFactory, schedulingAgentCallback);
    }
}

