/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.storage.questdb;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.status.NodeStatus;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.StandardMetricDescriptor;
import org.apache.nifi.controller.status.history.questdb.QuestDbReadingTemplate;
import org.apache.nifi.controller.status.history.storage.questdb.QuestDbNodeStatusStorage;

public class StorageStatusReadingTemplate
extends QuestDbReadingTemplate<Map<Long, Map<StandardMetricDescriptor<NodeStatus>, Long>>> {
    private static final String STORAGE_FREE_DESCRIPTION = "The usable space available for use by the underlying storage mechanism.";
    private static final String STORAGE_USED_DESCRIPTION = "The space in use on the underlying storage mechanism";
    private static final String STORAGE_READING_QUERY = "SELECT * FROM storageStatus WHERE capturedAt > to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') AND capturedAt < to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') ORDER BY capturedAt ASC";

    public StorageStatusReadingTemplate() {
        super(STORAGE_READING_QUERY, e -> Collections.emptyMap());
    }

    @Override
    protected Map<Long, Map<StandardMetricDescriptor<NodeStatus>, Long>> processResult(RecordCursor cursor) {
        HashMap<Long, Map<StandardMetricDescriptor<NodeStatus>, Long>> result = new HashMap<Long, Map<StandardMetricDescriptor<NodeStatus>, Long>>();
        int storageNumber = 1;
        while (cursor.hasNext()) {
            Record record = cursor.getRecord();
            long createdAt = TimeUnit.MICROSECONDS.toMillis(record.getTimestamp(0));
            short type = record.getShort(2);
            CharSequence name = record.getSym(1);
            if (!result.containsKey(createdAt)) {
                result.put(createdAt, new HashMap());
            }
            ((Map)result.get(createdAt)).put(this.getDescriptor(QuestDbNodeStatusStorage.getMetrics().size() + ((Map)result.get(createdAt)).size(), this.getField(type, storageNumber, StorageMetric.FREE), this.getLabel(type, name, StorageMetric.FREE), STORAGE_FREE_DESCRIPTION), record.getLong(3));
            ((Map)result.get(createdAt)).put(this.getDescriptor(QuestDbNodeStatusStorage.getMetrics().size() + ((Map)result.get(createdAt)).size(), this.getField(type, storageNumber, StorageMetric.USED), this.getLabel(type, name, StorageMetric.USED), STORAGE_USED_DESCRIPTION), record.getLong(4));
            ++storageNumber;
        }
        return result;
    }

    private StandardMetricDescriptor<NodeStatus> getDescriptor(int ordinal, String field, String label, String description) {
        return new StandardMetricDescriptor<NodeStatus>(() -> ordinal, field, label, STORAGE_FREE_DESCRIPTION, MetricDescriptor.Formatter.DATA_SIZE, v -> 0L);
    }

    private String getField(int type, int storageNumber, StorageMetric storageMetric) {
        return StorageType.getById(type).getField() + storageNumber + storageMetric.getField();
    }

    private String getLabel(int type, CharSequence name, StorageMetric storageMetric) {
        return StorageType.getById(type).getLabel() + " (" + name + ") " + storageMetric.getLabel();
    }

    private static enum StorageMetric {
        FREE("Free", "Free Space"),
        USED("Used", "Used Space");

        private final String field;
        private final String label;

        private StorageMetric(String field, String label) {
            this.field = field;
            this.label = label;
        }

        public String getField() {
            return this.field;
        }

        public String getLabel() {
            return this.label;
        }
    }

    private static enum StorageType {
        CONTENT("contentStorage", "Content Repository"),
        PROVENANCE("provenanceStorage", "Provenance Repository");

        private final String field;
        private final String label;

        private StorageType(String field, String label) {
            this.field = field;
            this.label = label;
        }

        public static StorageType getById(int id) {
            return StorageType.values()[id];
        }

        public String getField() {
            return this.field;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

