/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.storage.questdb;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.griffin.SqlExecutionContext;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.nifi.controller.status.NodeStatus;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.NodeStatusDescriptor;
import org.apache.nifi.controller.status.history.StandardMetricDescriptor;
import org.apache.nifi.controller.status.history.StandardStatusHistory;
import org.apache.nifi.controller.status.history.StandardStatusSnapshot;
import org.apache.nifi.controller.status.history.StatusHistory;
import org.apache.nifi.controller.status.history.StatusSnapshot;
import org.apache.nifi.controller.status.history.questdb.QuestDbContext;
import org.apache.nifi.controller.status.history.questdb.QuestDbEntityWritingTemplate;
import org.apache.nifi.controller.status.history.questdb.QuestDbReadingTemplate;
import org.apache.nifi.controller.status.history.questdb.QuestDbWritingTemplate;
import org.apache.nifi.controller.status.history.storage.NodeStatusStorage;
import org.apache.nifi.controller.status.history.storage.questdb.StorageStatusReadingTemplate;
import org.apache.nifi.controller.status.history.storage.questdb.StorageStatusWritingTemplate;

public class QuestDbNodeStatusStorage
implements NodeStatusStorage {
    private static final String TABLE_NAME = "nodeStatus";
    private static final String READING_QUERY = "SELECT * FROM nodeStatus WHERE capturedAt > to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') AND capturedAt < to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') ORDER BY capturedAt ASC";
    private static final Map<Integer, MetricDescriptor<NodeStatus>> METRICS = new HashMap<Integer, MetricDescriptor<NodeStatus>>();
    private final QuestDbContext dbContext;
    private static final QuestDbEntityWritingTemplate<NodeStatus> WRITING_TEMPLATE;
    private static final StorageStatusReadingTemplate STORAGE_READING_TEMPLATE;
    private static final QuestDbWritingTemplate<Pair<Instant, NodeStatus>> STORAGE_WRITING_TEMPLATE;

    public QuestDbNodeStatusStorage(QuestDbContext dbContext) {
        this.dbContext = dbContext;
    }

    @Override
    public StatusHistory read(Instant start, Instant end) {
        SqlExecutionContext executionContext = this.dbContext.getSqlExecutionContext();
        Map storageMetrics = (Map)STORAGE_READING_TEMPLATE.read(this.dbContext.getEngine(), executionContext, Arrays.asList(DATE_FORMATTER.format(start), DATE_FORMATTER.format(end)));
        NodeStatusReadingTemplate nodeStatusReadingTemplate = new NodeStatusReadingTemplate(storageMetrics);
        List snapshots = (List)nodeStatusReadingTemplate.read(this.dbContext.getEngine(), executionContext, Arrays.asList(DATE_FORMATTER.format(start), DATE_FORMATTER.format(end)));
        return new StandardStatusHistory(snapshots, new HashMap<String, String>(), new Date());
    }

    @Override
    public void store(List<Pair<Instant, NodeStatus>> statusEntries) {
        SqlExecutionContext executionContext = this.dbContext.getSqlExecutionContext();
        WRITING_TEMPLATE.insert(this.dbContext.getEngine(), executionContext, statusEntries);
        STORAGE_WRITING_TEMPLATE.insert(this.dbContext.getEngine(), executionContext, statusEntries);
    }

    public static Map<Integer, MetricDescriptor<NodeStatus>> getMetrics() {
        return METRICS;
    }

    static {
        METRICS.put(1, NodeStatusDescriptor.FREE_HEAP.getDescriptor());
        METRICS.put(2, NodeStatusDescriptor.USED_HEAP.getDescriptor());
        METRICS.put(3, NodeStatusDescriptor.HEAP_UTILIZATION.getDescriptor());
        METRICS.put(4, NodeStatusDescriptor.FREE_NON_HEAP.getDescriptor());
        METRICS.put(5, NodeStatusDescriptor.USED_NON_HEAP.getDescriptor());
        METRICS.put(6, NodeStatusDescriptor.OPEN_FILE_HANDLES.getDescriptor());
        METRICS.put(7, NodeStatusDescriptor.PROCESSOR_LOAD_AVERAGE.getDescriptor());
        METRICS.put(8, NodeStatusDescriptor.TOTAL_THREADS.getDescriptor());
        METRICS.put(9, NodeStatusDescriptor.EVENT_DRIVEN_THREADS.getDescriptor());
        METRICS.put(10, NodeStatusDescriptor.TIME_DRIVEN_THREADS.getDescriptor());
        WRITING_TEMPLATE = new QuestDbEntityWritingTemplate<NodeStatus>(TABLE_NAME, (statusEntry, row) -> METRICS.keySet().forEach(ord -> row.putLong(ord.intValue(), METRICS.get(ord).getValueFunction().getValue(statusEntry).longValue())));
        STORAGE_READING_TEMPLATE = new StorageStatusReadingTemplate();
        STORAGE_WRITING_TEMPLATE = new StorageStatusWritingTemplate();
    }

    private static class NodeStatusReadingTemplate
    extends QuestDbReadingTemplate<List<StatusSnapshot>> {
        private final Map<Long, Map<StandardMetricDescriptor<NodeStatus>, Long>> storageMetricsByTime;

        public NodeStatusReadingTemplate(Map<Long, Map<StandardMetricDescriptor<NodeStatus>, Long>> storageMetricsByTime) {
            super(QuestDbNodeStatusStorage.READING_QUERY, e -> Collections.emptyList());
            this.storageMetricsByTime = storageMetricsByTime;
        }

        @Override
        protected List<StatusSnapshot> processResult(RecordCursor cursor) {
            LinkedList<StatusSnapshot> entities = new LinkedList<StatusSnapshot>();
            while (cursor.hasNext()) {
                entities.add(this.map(cursor.getRecord()));
            }
            return entities;
        }

        private StandardStatusSnapshot map(Record record) {
            long createdAt = TimeUnit.MICROSECONDS.toMillis(record.getTimestamp(0));
            Map<StandardMetricDescriptor<NodeStatus>, Long> statusMetrics = this.storageMetricsByTime.get(createdAt);
            HashSet snapshotMetrics = new HashSet(METRICS.values().size() + statusMetrics.keySet().size());
            snapshotMetrics.addAll(METRICS.values());
            snapshotMetrics.addAll(statusMetrics.keySet());
            StandardStatusSnapshot snapshot = new StandardStatusSnapshot(snapshotMetrics);
            snapshot.setTimestamp(new Date(createdAt));
            METRICS.keySet().forEach(ordinal -> snapshot.addStatusMetric((MetricDescriptor)METRICS.get(ordinal), record.getLong(ordinal.intValue())));
            statusMetrics.entrySet().forEach(entry -> snapshot.addStatusMetric((MetricDescriptor)entry.getKey(), (Long)entry.getValue()));
            return snapshot;
        }
    }
}

