/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.questdb;

import io.questdb.cairo.sql.Record;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.StandardStatusSnapshot;

public class QuestDbStatusSnapshotMapper<T>
implements Function<Record, StandardStatusSnapshot> {
    private final Map<Integer, MetricDescriptor<T>> metrics = new HashMap<Integer, MetricDescriptor<T>>();

    public QuestDbStatusSnapshotMapper(Map<Integer, MetricDescriptor<T>> metrics) {
        this.metrics.putAll(metrics);
    }

    @Override
    public StandardStatusSnapshot apply(Record record) {
        StandardStatusSnapshot snapshot = new StandardStatusSnapshot(new HashSet(this.metrics.values()));
        snapshot.setTimestamp(new Date(TimeUnit.MICROSECONDS.toMillis(record.getTimestamp(0))));
        this.metrics.keySet().forEach(ordinal -> snapshot.addStatusMetric(this.metrics.get(ordinal), record.getLong(ordinal.intValue())));
        return snapshot;
    }
}

