/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.inheritance;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.controller.inheritance.FlowInheritability;
import org.apache.nifi.controller.inheritance.FlowInheritabilityCheck;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.serialization.FlowEncodingVersion;
import org.apache.nifi.controller.serialization.FlowFromDOMFactory;
import org.apache.nifi.controller.serialization.FlowSynchronizationException;
import org.apache.nifi.flow.ComponentType;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.registry.flow.diff.DifferenceType;
import org.apache.nifi.registry.flow.diff.FlowComparison;
import org.apache.nifi.registry.flow.diff.FlowDifference;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConnectionMissingCheck
implements FlowInheritabilityCheck {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionMissingCheck.class);
    private final FlowComparison flowComparison;

    public ConnectionMissingCheck(FlowComparison flowComparison) {
        this.flowComparison = flowComparison;
    }

    @Override
    public FlowInheritability checkInheritability(DataFlow existingFlow, DataFlow proposedFlow, FlowController flowController) {
        if (proposedFlow.isXml()) {
            return this.checkInheritability(proposedFlow.getFlowDocument(), flowController);
        }
        return this.checkInheritability(existingFlow.getVersionedDataflow(), proposedFlow.getVersionedDataflow(), flowController);
    }

    private FlowInheritability checkInheritability(VersionedDataflow existingFlow, VersionedDataflow proposedFlow, FlowController flowController) {
        Set queuesWithFlowFiles;
        FlowManager flowManager = flowController.getFlowManager();
        if (flowController.isInitialized()) {
            queuesWithFlowFiles = Collections.emptySet();
        } else {
            FlowFileRepository flowFileRepository = flowController.getRepositoryContextFactory().getFlowFileRepository();
            try {
                queuesWithFlowFiles = flowFileRepository.findQueuesWithFlowFiles(flowController.createSwapManager());
            }
            catch (IOException ioe) {
                throw new FlowSynchronizationException("Failed to determine which connections have FlowFiles queued", ioe);
            }
            logger.debug("The following {} Connections/Queues have data queued up currently: {}", (Object)queuesWithFlowFiles.size(), (Object)queuesWithFlowFiles);
        }
        for (FlowDifference difference : this.flowComparison.getDifferences()) {
            boolean queueEmpty;
            VersionedComponent component = difference.getComponentA();
            if (DifferenceType.COMPONENT_REMOVED != difference.getDifferenceType() || component.getComponentType() != ComponentType.CONNECTION) continue;
            if (queuesWithFlowFiles.contains(component.getInstanceIdentifier())) {
                return FlowInheritability.notInheritable("Inheriting cluster's flow would mean removing Connection with ID " + component.getInstanceIdentifier() + ", and the connection has data queued");
            }
            Connection connection = flowManager.getConnection(component.getInstanceIdentifier());
            if (connection == null || (queueEmpty = connection.getFlowFileQueue().isEmpty())) continue;
            return FlowInheritability.notInheritable("Inheriting cluster's flow would mean removing Connection with ID " + component.getInstanceIdentifier() + ", and the connection has data queued");
        }
        return FlowInheritability.inheritable();
    }

    private FlowInheritability checkInheritability(Document flowDocument, FlowController flowController) {
        Set queuesWithFlowFiles;
        Element rootGroupElement = (Element)flowDocument.getDocumentElement().getElementsByTagName("rootGroup").item(0);
        FlowEncodingVersion encodingVersion = FlowEncodingVersion.parse(flowDocument.getDocumentElement());
        ProcessGroupDTO rootGroupDto = FlowFromDOMFactory.getProcessGroup(null, rootGroupElement, null, encodingVersion);
        Set<String> connectionIds = this.findAllConnectionIds(rootGroupDto);
        FlowFileRepository flowFileRepository = flowController.getRepositoryContextFactory().getFlowFileRepository();
        try {
            queuesWithFlowFiles = flowFileRepository.findQueuesWithFlowFiles(flowController.createSwapManager());
        }
        catch (IOException ioe) {
            throw new FlowSynchronizationException("Failed to determine which connections have FlowFiles queued", ioe);
        }
        logger.debug("The following {} Connections/Queues have data queued up currently: {}", (Object)queuesWithFlowFiles.size(), (Object)queuesWithFlowFiles);
        for (String queueId : queuesWithFlowFiles) {
            if (connectionIds.contains(queueId)) continue;
            return FlowInheritability.notInheritable("Proposed Flow does not contain a Connection with ID " + queueId + " but this instance has data queued in that connection");
        }
        return FlowInheritability.inheritable();
    }

    private Set<String> findAllConnectionIds(ProcessGroupDTO group) {
        HashSet<String> connectionIds = new HashSet<String>();
        this.findAllConnectionIds(group, connectionIds);
        return connectionIds;
    }

    private void findAllConnectionIds(ProcessGroupDTO group, Set<String> ids) {
        for (ConnectionDTO connectionDTO : group.getContents().getConnections()) {
            ids.add(connectionDTO.getId());
        }
        for (ProcessGroupDTO childGroup : group.getContents().getProcessGroups()) {
            this.findAllConnectionIds(childGroup, ids);
        }
    }
}

