/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.connectable.Positionable;
import org.apache.nifi.groups.ProcessGroup;

class PositionScaler {
    PositionScaler() {
    }

    public static void scale(ProcessGroup processGroup, double factorX, double factorY) {
        processGroup.findAllPositionables().stream().forEach(p -> PositionScaler.scale(p, factorX, factorY));
        Map<Connection, List> bendPointsByConnection = processGroup.findAllConnections().stream().collect(Collectors.toMap(connection -> connection, Connection::getBendPoints));
        bendPointsByConnection.entrySet().stream().forEach(connectionListEntry -> ((Connection)connectionListEntry.getKey()).setBendPoints(((List)connectionListEntry.getValue()).stream().map(p -> PositionScaler.scalePosition(p, factorX, factorY)).collect(Collectors.toList())));
    }

    public static void scale(Positionable positionable, double factorX, double factorY) {
        Position startingPosition = positionable.getPosition();
        Position scaledPosition = PositionScaler.scalePosition(startingPosition, factorX, factorY);
        positionable.setPosition(scaledPosition);
    }

    private static Position scalePosition(Position position, double factorX, double factorY) {
        return new Position(position.getX() * factorX, position.getY() * factorY);
    }
}

