/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.Metrics;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.security.CairoSecurityContextImpl;
import io.questdb.cutlass.http.HttpChunkedResponseSocket;
import io.questdb.cutlass.http.HttpContextConfiguration;
import io.questdb.cutlass.http.HttpException;
import io.questdb.cutlass.http.HttpHeaderParser;
import io.questdb.cutlass.http.HttpMultipartContentListener;
import io.questdb.cutlass.http.HttpMultipartContentParser;
import io.questdb.cutlass.http.HttpRawSocket;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.HttpRequestProcessorSelector;
import io.questdb.cutlass.http.HttpResponseHeader;
import io.questdb.cutlass.http.HttpResponseSink;
import io.questdb.cutlass.http.LocalValueMap;
import io.questdb.cutlass.http.Locality;
import io.questdb.cutlass.http.MultipartParserState;
import io.questdb.cutlass.http.RescheduleContext;
import io.questdb.cutlass.http.Retry;
import io.questdb.cutlass.http.RetryAttemptAttributes;
import io.questdb.cutlass.http.ex.BufferOverflowException;
import io.questdb.cutlass.http.ex.NotEnoughLinesException;
import io.questdb.cutlass.http.ex.RetryFailedOperationException;
import io.questdb.cutlass.http.ex.RetryOperationException;
import io.questdb.cutlass.http.ex.TooFewBytesReceivedException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.AbstractMutableIOContext;
import io.questdb.network.IODispatcher;
import io.questdb.network.Net;
import io.questdb.network.NetworkFacade;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.QueryPausedException;
import io.questdb.network.ServerDisconnectException;
import io.questdb.network.SuspendEvent;
import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.ObjectPool;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.StdoutSink;

public class HttpConnectionContext
extends AbstractMutableIOContext<HttpConnectionContext>
implements Locality,
Retry {
    private static final Log LOG = LogFactory.getLog(HttpConnectionContext.class);
    private final boolean allowDeflateBeforeSend;
    private final CairoSecurityContext cairoSecurityContext;
    private final ObjectPool<DirectByteCharSequence> csPool;
    private final boolean dumpNetworkTraffic;
    private final HttpHeaderParser headerParser;
    private final LocalValueMap localValueMap = new LocalValueMap();
    private final Metrics metrics;
    private final HttpHeaderParser multipartContentHeaderParser;
    private final HttpMultipartContentParser multipartContentParser;
    private final long multipartIdleSpinCount;
    private final MultipartParserState multipartParserState = new MultipartParserState();
    private final NetworkFacade nf;
    private final Runnable onPeerDisconnect;
    private final int recvBufferSize;
    private final HttpResponseSink responseSink;
    private final RetryAttemptAttributes retryAttemptAttributes = new RetryAttemptAttributes();
    private final RescheduleContext retryRescheduleContext = retry -> {
        LOG.info().$("Retry is requested after successful writer allocation. Retry will be re-scheduled [thread=").$(Thread.currentThread().getId()).$(']');
        throw RetryOperationException.INSTANCE;
    };
    private final boolean serverKeepAlive;
    private int nCompletedRequests;
    private boolean pendingRetry = false;
    private int receivedBytes;
    private long recvBuffer;
    private HttpRequestProcessor resumeProcessor = null;
    private SuspendEvent suspendEvent;
    private long totalBytesSent;

    public HttpConnectionContext(HttpContextConfiguration configuration, Metrics metrics) {
        this.nf = configuration.getNetworkFacade();
        this.csPool = new ObjectPool<DirectByteCharSequence>(DirectByteCharSequence.FACTORY, configuration.getConnectionStringPoolCapacity());
        this.headerParser = new HttpHeaderParser(configuration.getRequestHeaderBufferSize(), this.csPool);
        this.multipartContentHeaderParser = new HttpHeaderParser(configuration.getMultipartHeaderBufferSize(), this.csPool);
        this.multipartContentParser = new HttpMultipartContentParser(this.multipartContentHeaderParser);
        this.responseSink = new HttpResponseSink(configuration);
        this.recvBufferSize = configuration.getRecvBufferSize();
        this.multipartIdleSpinCount = configuration.getMultipartIdleSpinCount();
        this.dumpNetworkTraffic = configuration.getDumpNetworkTraffic();
        this.allowDeflateBeforeSend = configuration.allowDeflateBeforeSend();
        this.cairoSecurityContext = new CairoSecurityContextImpl(!configuration.readOnlySecurityContext());
        this.serverKeepAlive = configuration.getServerKeepAlive();
        this.onPeerDisconnect = configuration.onPeerDisconnect();
        this.metrics = metrics;
    }

    @Override
    public void clear() {
        LOG.debug().$("clear [fd=").$(this.fd).$(']').$();
        this.totalBytesSent += this.responseSink.getTotalBytesSent();
        this.responseSink.clear();
        ++this.nCompletedRequests;
        this.resumeProcessor = null;
        this.headerParser.clear();
        this.multipartContentParser.clear();
        this.multipartContentHeaderParser.clear();
        this.csPool.clear();
        this.localValueMap.clear();
        if (this.pendingRetry) {
            LOG.error().$("reused context with retry pending").$();
        }
        this.pendingRetry = false;
        this.multipartParserState.multipartRetry = false;
        this.retryAttemptAttributes.waitStartTimestamp = 0L;
        this.retryAttemptAttributes.lastRunTimestamp = 0L;
        this.retryAttemptAttributes.attempt = 0;
        this.receivedBytes = 0;
        this.clearSuspendEvent();
    }

    @Override
    public void clearSuspendEvent() {
        this.suspendEvent = Misc.free(this.suspendEvent);
    }

    @Override
    public void close() {
        LOG.debug().$("close [fd=").$(this.fd).$(']').$();
        if (this.pendingRetry) {
            this.pendingRetry = false;
            LOG.info().$("closed context with retry pending [fd=").$(this.fd).$(']').$();
            if (this.fd > 0) {
                Net.close(this.fd);
            }
        }
        this.fd = -1;
        this.dispatcher = null;
        this.nCompletedRequests = 0;
        this.totalBytesSent = 0L;
        this.csPool.clear();
        this.multipartContentParser.close();
        this.multipartContentHeaderParser.close();
        this.headerParser.close();
        this.localValueMap.close();
        this.recvBuffer = Unsafe.free(this.recvBuffer, this.recvBufferSize, 11);
        this.responseSink.close();
        this.receivedBytes = 0;
        this.clearSuspendEvent();
        LOG.debug().$("closed").$();
    }

    @Override
    public void fail(HttpRequestProcessorSelector selector, HttpException e) {
        LOG.info().$("failed to retry query [fd=").$(this.fd).$(']').$();
        HttpRequestProcessor processor = this.getHttpRequestProcessor(selector);
        this.failProcessor(processor, e, 6);
    }

    @Override
    public RetryAttemptAttributes getAttemptDetails() {
        return this.retryAttemptAttributes;
    }

    public CairoSecurityContext getCairoSecurityContext() {
        return this.cairoSecurityContext;
    }

    public HttpChunkedResponseSocket getChunkedResponseSocket() {
        return this.responseSink.getChunkedSocket();
    }

    public long getLastRequestBytesSent() {
        return this.responseSink.getTotalBytesSent();
    }

    @Override
    public LocalValueMap getMap() {
        return this.localValueMap;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public int getNCompletedRequests() {
        return this.nCompletedRequests;
    }

    public HttpRawSocket getRawResponseSocket() {
        return this.responseSink.getRawSocket();
    }

    public HttpRequestHeader getRequestHeader() {
        return this.headerParser;
    }

    public HttpResponseHeader getResponseHeader() {
        return this.responseSink.getHeader();
    }

    @Override
    public SuspendEvent getSuspendEvent() {
        return this.suspendEvent;
    }

    public long getTotalBytesSent() {
        return this.totalBytesSent;
    }

    public boolean handleClientOperation(int operation, HttpRequestProcessorSelector selector, RescheduleContext rescheduleContext) {
        boolean keepGoing;
        switch (operation) {
            case 1: {
                keepGoing = this.handleClientRecv(selector, rescheduleContext);
                break;
            }
            case 4: {
                keepGoing = this.handleClientSend();
                break;
            }
            default: {
                this.dispatcher.disconnect(this, 0);
                keepGoing = false;
            }
        }
        boolean useful = keepGoing;
        if (keepGoing) {
            if (this.serverKeepAlive) {
                while (keepGoing = this.handleClientRecv(selector, rescheduleContext)) {
                }
            } else {
                this.dispatcher.disconnect(this, 1);
            }
        }
        return useful;
    }

    @Override
    public boolean invalid() {
        return this.pendingRetry || this.receivedBytes > 0 || this.fd == -1;
    }

    @Override
    public HttpConnectionContext of(int fd, IODispatcher<HttpConnectionContext> dispatcher) {
        HttpConnectionContext r = (HttpConnectionContext)super.of(fd, dispatcher);
        if (fd == -1) {
            this.recvBuffer = Unsafe.free(this.recvBuffer, this.recvBufferSize, 11);
            this.responseSink.close();
        } else {
            if (this.recvBuffer == 0L) {
                this.recvBuffer = Unsafe.malloc(this.recvBufferSize, 11);
            }
            this.responseSink.of(fd);
        }
        return r;
    }

    public void resumeResponseSend() throws PeerIsSlowToReadException, PeerDisconnectedException {
        this.responseSink.resumeSend();
    }

    public void scheduleRetry(HttpRequestProcessor processor, RescheduleContext rescheduleContext) {
        try {
            this.pendingRetry = true;
            rescheduleContext.reschedule(this);
        }
        catch (RetryFailedOperationException e) {
            this.failProcessor(processor, e, 6);
        }
    }

    public HttpResponseSink.SimpleResponseImpl simpleResponse() {
        return this.responseSink.getSimple();
    }

    @Override
    public boolean tryRerun(HttpRequestProcessorSelector selector, RescheduleContext rescheduleContext) {
        if (this.pendingRetry) {
            this.pendingRetry = false;
            HttpRequestProcessor processor = this.getHttpRequestProcessor(selector);
            try {
                LOG.info().$("retrying query [fd=").$(this.fd).$(']').$();
                processor.onRequestRetry(this);
                if (this.multipartParserState.multipartRetry) {
                    if (this.continueConsumeMultipart(this.fd, this.multipartParserState.start, this.multipartParserState.buf, this.multipartParserState.bufRemaining, (HttpMultipartContentListener)((Object)processor), processor, this.retryRescheduleContext)) {
                        LOG.info().$("success retried multipart import [fd=").$(this.fd).$(']').$();
                        this.busyRcvLoop(selector, rescheduleContext);
                    } else {
                        LOG.info().$("retry success but import not finished [fd=").$(this.fd).$(']').$();
                    }
                } else {
                    this.busyRcvLoop(selector, rescheduleContext);
                }
            }
            catch (RetryOperationException e2) {
                this.pendingRetry = true;
                return false;
            }
            catch (PeerDisconnectedException ignore) {
                this.handlePeerDisconnect(10);
            }
            catch (PeerIsSlowToReadException e2) {
                LOG.info().$("peer is slow on running the rerun [fd=").$(this.fd).$(", thread=").$(Thread.currentThread().getId()).$(']').$();
                processor.parkRequest(this, false);
                this.resumeProcessor = processor;
                this.getDispatcher().registerChannel(this, 4);
            }
            catch (QueryPausedException e) {
                LOG.info().$("partition is in cold storage, suspending query [fd=").$(this.fd).$(", thread=").$(Thread.currentThread().getId()).$(']').$();
                processor.parkRequest(this, true);
                this.resumeProcessor = processor;
                this.suspendEvent = e.getEvent();
                this.getDispatcher().registerChannel(this, 4);
            }
            catch (ServerDisconnectException e) {
                LOG.info().$("kicked out [fd=").$(this.fd).$(']').$();
                this.dispatcher.disconnect(this, 2);
            }
        }
        return true;
    }

    private void busyRcvLoop(HttpRequestProcessorSelector selector, RescheduleContext rescheduleContext) {
        this.clear();
        if (this.serverKeepAlive) {
            while (this.handleClientRecv(selector, rescheduleContext)) {
            }
        } else {
            this.dispatcher.disconnect(this, 4);
        }
    }

    private void completeRequest(HttpRequestProcessor processor, RescheduleContext rescheduleContext) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
        LOG.debug().$("complete [fd=").$(this.fd).$(']').$();
        try {
            processor.onRequestComplete(this);
            this.clear();
        }
        catch (RetryOperationException e) {
            this.pendingRetry = true;
            this.scheduleRetry(processor, rescheduleContext);
        }
    }

    private boolean consumeMultipart(int fd, HttpRequestProcessor processor, long headerEnd, int read, boolean newRequest, RescheduleContext rescheduleContext) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
        int bufRemaining;
        long buf;
        long start;
        if (newRequest) {
            processor.onHeadersReady(this);
            this.multipartContentParser.of(this.headerParser.getBoundary());
        }
        processor.resumeRecv(this);
        HttpMultipartContentListener multipartListener = (HttpMultipartContentListener)((Object)processor);
        long bufferEnd = this.recvBuffer + (long)read;
        LOG.debug().$("multipart").$();
        if (headerEnd < bufferEnd) {
            start = headerEnd;
            buf = bufferEnd;
            bufRemaining = (int)((long)this.recvBufferSize - (bufferEnd - this.recvBuffer));
        } else {
            start = this.recvBuffer;
            buf = start + (long)this.receivedBytes;
            bufRemaining = this.recvBufferSize - this.receivedBytes;
            this.receivedBytes = 0;
        }
        return this.continueConsumeMultipart(fd, start, buf, bufRemaining, multipartListener, processor, rescheduleContext);
    }

    private boolean continueConsumeMultipart(int fd, long start, long buf, int bufRemaining, HttpMultipartContentListener multipartListener, HttpRequestProcessor processor, RescheduleContext rescheduleContext) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
        boolean keepGoing = false;
        if (buf > start) {
            try {
                if (this.parseMultipartResult(start, buf, bufRemaining, multipartListener, processor, rescheduleContext)) {
                    return true;
                }
                buf = start = this.recvBuffer;
                bufRemaining = this.recvBufferSize;
            }
            catch (TooFewBytesReceivedException e) {
                start = this.multipartContentParser.getResumePtr();
            }
        }
        long spinsRemaining = this.multipartIdleSpinCount;
        while (true) {
            int n;
            if ((n = this.nf.recv(fd, buf, bufRemaining)) < 0) {
                this.handlePeerDisconnect(8);
                break;
            }
            if (n == 0) {
                if (spinsRemaining-- > 0L) continue;
                if (buf > start) {
                    try {
                        if (this.parseMultipartResult(start, buf, bufRemaining, multipartListener, processor, rescheduleContext)) {
                            keepGoing = true;
                            break;
                        }
                        buf = start = this.recvBuffer;
                        bufRemaining = this.recvBufferSize;
                        continue;
                    }
                    catch (TooFewBytesReceivedException e) {
                        start = this.multipartContentParser.getResumePtr();
                        this.shiftReceiveBufferUnprocessedBytes(start, (int)(buf - start));
                        this.dispatcher.registerChannel(this, 1);
                        break;
                    }
                }
                LOG.debug().$("peer is slow [multipart]").$();
                this.dispatcher.registerChannel(this, 1);
                break;
            }
            LOG.debug().$("multipart recv [len=").$(n).$(']').$();
            this.dumpBuffer(buf, n);
            buf += (long)n;
            if ((bufRemaining -= n) != 0) continue;
            try {
                if (buf - start > 1L && this.parseMultipartResult(start, buf, bufRemaining, multipartListener, processor, rescheduleContext)) {
                    keepGoing = true;
                    break;
                }
                buf = start = this.recvBuffer;
                bufRemaining = this.recvBufferSize;
            }
            catch (TooFewBytesReceivedException e) {
                start = this.multipartContentParser.getResumePtr();
                int unprocessedSize = (int)(buf - start);
                if (unprocessedSize < this.recvBufferSize) {
                    start = this.multipartContentParser.getResumePtr();
                    this.shiftReceiveBufferUnprocessedBytes(start, unprocessedSize);
                    this.dispatcher.registerChannel(this, 1);
                    break;
                }
                this.failProcessor(processor, BufferOverflowException.INSTANCE, 9);
                break;
            }
        }
        return keepGoing;
    }

    private void dumpBuffer(long buffer, int size) {
        if (this.dumpNetworkTraffic && size > 0) {
            StdoutSink.INSTANCE.put('>');
            Net.dump(buffer, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failProcessor(HttpRequestProcessor processor, HttpException e, int reason) {
        this.pendingRetry = false;
        boolean canClear = true;
        try {
            LOG.info().$("failed query result cannot be delivered. Kicked out [fd=").$(this.fd).$(", error=").$(e.getFlyweightMessage()).I$();
            processor.failRequest(this, e);
            this.dispatcher.disconnect(this, reason);
        }
        catch (PeerDisconnectedException peerDisconnectedException) {
            this.handlePeerDisconnect(11);
        }
        catch (PeerIsSlowToReadException peerIsSlowToReadException) {
            LOG.info().$("peer is slow to receive failed to retry response [fd=").$(this.fd).$(']').$();
            processor.parkRequest(this, false);
            this.resumeProcessor = processor;
            this.dispatcher.registerChannel(this, 4);
            canClear = false;
        }
        catch (ServerDisconnectException serverDisconnectException) {
            this.dispatcher.disconnect(this, reason);
        }
        finally {
            if (canClear) {
                this.clear();
            }
        }
    }

    private HttpRequestProcessor getHttpRequestProcessor(HttpRequestProcessorSelector selector) {
        HttpRequestProcessor processor = selector.select(this.headerParser.getUrl());
        if (processor == null) {
            processor = selector.getDefaultProcessor();
        }
        return processor;
    }

    private boolean handleClientRecv(HttpRequestProcessorSelector selector, RescheduleContext rescheduleContext) {
        boolean busyRecv;
        block18: {
            busyRecv = true;
            try {
                CharSequence url;
                int fd = this.fd;
                long headerEnd = this.recvBuffer;
                int read = 0;
                boolean newRequest = this.headerParser.isIncomplete();
                if (newRequest) {
                    while (this.headerParser.isIncomplete()) {
                        read = this.nf.recv(fd, this.recvBuffer, this.recvBufferSize);
                        LOG.debug().$("recv [fd=").$(fd).$(", count=").$(read).$(']').$();
                        if (read < 0) {
                            LOG.debug().$("done [fd=").$(fd).$(", errno=").$(this.nf.errno()).$(']').$();
                            this.handlePeerDisconnect(12);
                            return false;
                        }
                        if (read == 0) {
                            this.dispatcher.registerChannel(this, 1);
                            return false;
                        }
                        this.dumpBuffer(this.recvBuffer, read);
                        headerEnd = this.headerParser.parse(this.recvBuffer, this.recvBuffer + (long)read, true);
                    }
                }
                if ((url = this.headerParser.getUrl()) == null) {
                    throw HttpException.instance("missing URL");
                }
                HttpRequestProcessor processor = this.getHttpRequestProcessor(selector);
                boolean multipartRequest = Chars.equalsNc((CharSequence)"multipart/form-data", this.headerParser.getContentType());
                boolean multipartProcessor = processor instanceof HttpMultipartContentListener;
                if (this.allowDeflateBeforeSend && Chars.contains(this.headerParser.getHeader("Accept-Encoding"), "gzip")) {
                    this.responseSink.setDeflateBeforeSend(true);
                }
                try {
                    if (multipartRequest && !multipartProcessor) {
                        busyRecv = this.rejectRequest("Bad request. non-multipart GET expected.");
                        break block18;
                    }
                    if (!multipartRequest && multipartProcessor) {
                        busyRecv = this.rejectRequest("Bad request. Multipart POST expected.");
                        break block18;
                    }
                    if (multipartProcessor) {
                        busyRecv = this.consumeMultipart(fd, processor, headerEnd, read, newRequest, rescheduleContext);
                        break block18;
                    }
                    read = this.nf.recv(fd, this.recvBuffer, 1);
                    if (read != 0) {
                        this.dumpBuffer(this.recvBuffer, read);
                        LOG.info().$("disconnect after request [fd=").$(fd).$(']').$();
                        this.handlePeerDisconnect(13);
                        busyRecv = false;
                        break block18;
                    }
                    processor.onHeadersReady(this);
                    LOG.debug().$("good [fd=").$(fd).$(']').$();
                    processor.onRequestComplete(this);
                    this.resumeProcessor = null;
                    this.clear();
                }
                catch (RetryOperationException e) {
                    this.pendingRetry = true;
                    this.scheduleRetry(processor, rescheduleContext);
                    busyRecv = false;
                }
                catch (PeerDisconnectedException e) {
                    this.handlePeerDisconnect(15);
                    busyRecv = false;
                }
                catch (ServerDisconnectException e) {
                    LOG.info().$("kicked out [fd=").$(fd).$(']').$();
                    this.dispatcher.disconnect(this, 5);
                    busyRecv = false;
                }
                catch (PeerIsSlowToReadException e) {
                    LOG.debug().$("peer is slow reader [two]").$();
                    processor.parkRequest(this, false);
                    this.resumeProcessor = processor;
                    this.dispatcher.registerChannel(this, 4);
                    busyRecv = false;
                }
                catch (QueryPausedException e) {
                    LOG.debug().$("partition is in cold storage").$();
                    processor.parkRequest(this, true);
                    this.resumeProcessor = processor;
                    this.suspendEvent = e.getEvent();
                    this.dispatcher.registerChannel(this, 4);
                    busyRecv = false;
                }
            }
            catch (HttpException e) {
                LOG.error().$("http error [fd=").$(this.fd).$(", e=`").$(e.getFlyweightMessage()).$("`]").$();
                this.dispatcher.disconnect(this, 7);
                busyRecv = false;
            }
        }
        return busyRecv;
    }

    private boolean handleClientSend() {
        if (this.resumeProcessor != null) {
            try {
                this.resumeProcessor.resumeSend(this);
                this.clear();
                return true;
            }
            catch (PeerIsSlowToReadException ignore) {
                this.resumeProcessor.parkRequest(this, false);
                LOG.debug().$("peer is slow reader").$();
                this.dispatcher.registerChannel(this, 4);
            }
            catch (QueryPausedException e) {
                this.resumeProcessor.parkRequest(this, true);
                this.suspendEvent = e.getEvent();
                LOG.debug().$("partition is in cold storage").$();
                this.dispatcher.registerChannel(this, 4);
            }
            catch (PeerDisconnectedException ignore) {
                this.handlePeerDisconnect(11);
            }
            catch (ServerDisconnectException ignore) {
                LOG.info().$("kicked out [fd=").$(this.fd).$(']').$();
                this.dispatcher.disconnect(this, 3);
            }
        } else {
            LOG.error().$("spurious write request [fd=").$(this.fd).I$();
        }
        return false;
    }

    private void handlePeerDisconnect(int reason) {
        this.dispatcher.disconnect(this, reason);
        this.onPeerDisconnect.run();
    }

    private boolean parseMultipartResult(long start, long buf, int bufRemaining, HttpMultipartContentListener multipartListener, HttpRequestProcessor processor, RescheduleContext rescheduleContext) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException, TooFewBytesReceivedException {
        boolean parseResult;
        try {
            parseResult = this.multipartContentParser.parse(start, buf, multipartListener);
        }
        catch (RetryOperationException e) {
            this.multipartParserState.saveFdBufferPosition(this.multipartContentParser.getResumePtr(), buf, bufRemaining);
            throw e;
        }
        catch (NotEnoughLinesException e) {
            this.failProcessor(processor, e, 14);
            parseResult = false;
        }
        if (parseResult) {
            this.completeRequest(processor, rescheduleContext);
            return true;
        }
        return false;
    }

    private boolean rejectRequest(CharSequence userMessage) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.clear();
        LOG.error().$(userMessage).$();
        this.simpleResponse().sendStatus(404, userMessage);
        this.dispatcher.registerChannel(this, 1);
        return false;
    }

    private void shiftReceiveBufferUnprocessedBytes(long start, int receivedBytes) {
        this.receivedBytes = receivedBytes;
        Vect.memcpy(this.recvBuffer, start, receivedBytes);
        LOG.debug().$("peer is slow, waiting for bigger part to parse [multipart]").$();
    }
}

