/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectapi.nb;

import java.lang.ref.WeakReference;
import org.openide.util.BaseUtilities;
import org.openide.util.RequestProcessor;

public final class TimedWeakReference<T>
extends WeakReference<T>
implements Runnable {
    public static int TIMEOUT = 15000;
    private static final RequestProcessor RP = new RequestProcessor("TimedWeakReference");
    private RequestProcessor.Task task;
    private T o;
    private long touched;

    public TimedWeakReference(T o) {
        super(o, BaseUtilities.activeReferenceQueue());
        this.o = o;
        this.task = RP.create(this);
        this.task.schedule(TIMEOUT);
    }

    @Override
    public synchronized void run() {
        if (this.o != null) {
            long unused = System.currentTimeMillis() - this.touched;
            if (unused > (long)(TIMEOUT / 2)) {
                this.o = null;
                this.touched = 0L;
            } else {
                this.task.schedule(TIMEOUT - (int)unused);
            }
        }
    }

    @Override
    public synchronized T get() {
        if (this.o == null) {
            this.o = super.get();
        }
        if (this.o != null) {
            if (this.touched == 0L) {
                this.task.schedule(TIMEOUT);
            }
            this.touched = System.currentTimeMillis();
            return this.o;
        }
        return null;
    }
}

