/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.hints.declarative.Condition;
import org.netbeans.modules.java.hints.declarative.Hacks;
import org.netbeans.modules.java.hints.declarative.conditionapi.Context;
import org.netbeans.modules.java.hints.declarative.conditionapi.DefaultRuleUtilities;
import org.netbeans.modules.java.hints.declarative.conditionapi.Matcher;
import org.netbeans.modules.java.hints.declarative.conditionapi.Variable;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class MethodInvocationContext {
    final List<Class<?>> ruleUtilities = new LinkedList();
    private static final AtomicInteger c = new AtomicInteger();
    static final String[] AUXILIARY_IMPORTS = new String[]{"import org.netbeans.modules.java.hints.declarative.conditionapi.Context;", "import org.netbeans.modules.java.hints.declarative.conditionapi.Matcher;", "import org.netbeans.modules.java.hints.declarative.conditionapi.Variable;"};

    public MethodInvocationContext() {
        this.ruleUtilities.add(DefaultRuleUtilities.class);
    }

    public Method linkMethod(String methodName, Map<? extends String, ? extends Condition.MethodInvocation.ParameterKind> params) {
        LinkedList paramTypes = new LinkedList();
        for (Map.Entry<? extends String, ? extends Condition.MethodInvocation.ParameterKind> e : params.entrySet()) {
            switch (e.getValue()) {
                case VARIABLE: {
                    paramTypes.add(Variable.class);
                    break;
                }
                case STRING_LITERAL: {
                    paramTypes.add(String.class);
                    break;
                }
                case INT_LITERAL: {
                    paramTypes.add(Integer.TYPE);
                    break;
                }
                case ENUM_CONSTANT: {
                    paramTypes.add(MethodInvocationContext.loadEnumConstant(e.getKey()).getDeclaringClass());
                }
            }
        }
        Method varArgMethod = null;
        for (Class<?> clazz : this.ruleUtilities) {
            block8: for (Method m : clazz.getDeclaredMethods()) {
                if (!methodName.equals(m.getName())) continue;
                Class<?>[] p = m.getParameterTypes();
                int c = 0;
                Iterator it = paramTypes.iterator();
                while (it.hasNext() && c < p.length) {
                    Class<?> declaredClass;
                    Class paramClass = (Class)it.next();
                    if ((declaredClass = p[c++]).equals(paramClass)) continue;
                    if (!m.isVarArgs() || !declaredClass.isArray() || !declaredClass.getComponentType().equals(paramClass) || c != p.length) continue block8;
                    while (it.hasNext()) {
                        if (paramClass.equals(it.next())) continue;
                        continue block8;
                    }
                    break block9;
                }
                if (it.hasNext() || c != p.length) continue;
                if (!m.isVarArgs()) {
                    return m;
                }
                if (varArgMethod != null) continue;
                varArgMethod = m;
            }
        }
        return varArgMethod;
    }

    public boolean invokeMethod(Context ctx, @NonNull Method method, Map<? extends String, ? extends Condition.MethodInvocation.ParameterKind> params) {
        LinkedList<Object[]> paramValues = new LinkedList<Object[]>();
        int i = 0;
        LinkedList<Object> vararg = null;
        for (Map.Entry<? extends String, ? extends Condition.MethodInvocation.ParameterKind> e : params.entrySet()) {
            Object toAdd;
            if (++i == method.getParameterTypes().length && method.isVarArgs()) {
                vararg = new LinkedList<Object>();
            }
            switch (e.getValue()) {
                case VARIABLE: {
                    toAdd = new Variable(e.getKey());
                    break;
                }
                case STRING_LITERAL: {
                    toAdd = e.getKey();
                    break;
                }
                case INT_LITERAL: {
                    toAdd = Integer.valueOf(e.getKey());
                    break;
                }
                case ENUM_CONSTANT: {
                    toAdd = MethodInvocationContext.loadEnumConstant(e.getKey());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            (vararg != null ? vararg : paramValues).add(toAdd);
        }
        if (method.isVarArgs()) {
            Object[] arr = (Object[])Array.newInstance(method.getParameterTypes()[method.getParameterTypes().length - 1].getComponentType(), vararg.size());
            vararg.toArray(arr);
            paramValues.add(arr);
        }
        Matcher matcher = new Matcher(ctx);
        Class<?> clazz = method.getDeclaringClass();
        try {
            Constructor<?> c = clazz.getDeclaredConstructor(Context.class, Matcher.class);
            method.setAccessible(true);
            c.setAccessible(true);
            Object instance = c.newInstance(ctx, matcher);
            return (Boolean)method.invoke(instance, paramValues.toArray(new Object[0]));
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static Enum<?> loadEnumConstant(String fqn) {
        int lastDot = fqn.lastIndexOf(46);
        assert (lastDot != -1);
        String className = fqn.substring(0, lastDot);
        String constantName = fqn.substring(lastDot + 1);
        try {
            Class<?> c = Class.forName(className);
            return Enum.valueOf(c, constantName);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }

    void setCode(String imports, Iterable<? extends String> blocks) {
        if (!blocks.iterator().hasNext()) {
            return;
        }
        String className = "RuleUtilities$" + c.getAndIncrement();
        StringBuilder code = new StringBuilder();
        code.append("package $;\n");
        for (String imp : AUXILIARY_IMPORTS) {
            code.append(imp);
            code.append("\n");
        }
        if (imports != null) {
            code.append(imports);
        }
        code.append("class " + className + "{\n");
        code.append("private final Context context;\n");
        code.append("private final Matcher matcher;\n");
        code.append(className + "(Context context, Matcher matcher) {this.context = context; this.matcher = matcher;}");
        for (String string : blocks) {
            code.append(string);
        }
        code.append("}\n");
        try {
            final Map<String, byte[]> classes = Hacks.compile(MethodInvocationContext.computeCompileClassPath(), code.toString());
            if (!classes.containsKey("$." + className)) {
                return;
            }
            ClassLoader classLoader = new ClassLoader(MethodInvocationContext.class.getClassLoader()){

                @Override
                protected Class<?> findClass(String name) throws ClassNotFoundException {
                    byte[] bytes = (byte[])classes.get(name);
                    if (bytes != null) {
                        return this.defineClass(name, bytes, 0, bytes.length);
                    }
                    return super.findClass(name);
                }
            };
            Class<?> c = classLoader.loadClass("$." + className);
            this.ruleUtilities.add(c);
        }
        catch (IOException | ClassNotFoundException ex) {
            Exceptions.printStackTrace(ex);
        }
    }

    static ClassPath computeCompileClassPath() {
        return ClassPathSupport.createClassPath(MethodInvocationContext.apiJarURL());
    }

    public static URL apiJarURL() {
        URL jarFile = MethodInvocationContext.class.getProtectionDomain().getCodeSource().getLocation();
        return FileUtil.urlForArchiveOrDir(FileUtil.archiveOrDirForURL(jarFile));
    }
}

