/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import jpt.sun.source.tree.ExpressionStatementTree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.AnnotationMirror;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.TypeKind;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class CheckReturnValueHint {
    private static final Set<String> JDK_IMMUTABLE_CLASSES = new HashSet<String>(Arrays.asList("java.lang.String"));

    public static ErrorDescription hint(HintContext ctx) {
        Element invoked = ctx.getInfo().getTrees().getElement(new TreePath(ctx.getPath(), ((ExpressionStatementTree)ctx.getPath().getLeaf()).getExpression()));
        if (invoked == null || invoked.getKind() != ElementKind.METHOD || ((ExecutableElement)invoked).getReturnType().getKind() == TypeKind.VOID) {
            return null;
        }
        boolean found = false;
        for (AnnotationMirror annotationMirror : invoked.getAnnotationMirrors()) {
            String simpleName = annotationMirror.getAnnotationType().asElement().getSimpleName().toString();
            if (!"CheckReturnValue".equals(simpleName)) continue;
            found = true;
            break;
        }
        if (!found && !CheckReturnValueHint.checkReturnValueForJDKMethods((ExecutableElement)invoked)) {
            return null;
        }
        String displayName = NbBundle.getMessage(CheckReturnValueHint.class, "ERR_org.netbeans.modules.java.hints.bugs.CheckReturnValueHint");
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), displayName, new Fix[0]);
    }

    private static boolean checkReturnValueForJDKMethods(ExecutableElement method) {
        Element owner = method.getEnclosingElement();
        if (!owner.getKind().isClass() && !owner.getKind().isInterface()) {
            return false;
        }
        return JDK_IMMUTABLE_CLASSES.contains(((TypeElement)owner).getQualifiedName().toString());
    }
}

