/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0202_entity_time;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.vysper.xmpp.modules.core.base.handler.DefaultIQHandler;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;

public class EntityTimeXEP0090IQHandler
extends DefaultIQHandler {
    private static final TimeZone TIME_ZONE_UTC = TimeZone.getTimeZone("UTC");
    protected SimpleDateFormat utcDateFormatter;
    protected SimpleDateFormat localDateFormatter = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.ENGLISH);

    public EntityTimeXEP0090IQHandler() {
        this.utcDateFormatter = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
        this.utcDateFormatter.setTimeZone(TIME_ZONE_UTC);
    }

    protected boolean verifyNamespace(Stanza stanza) {
        return this.verifyInnerNamespace(stanza, "jabber:iq:time");
    }

    protected boolean verifyInnerElement(Stanza stanza) {
        return this.verifyInnerElementWorker(stanza, "query");
    }

    protected Stanza handleGet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        Date now = new Date();
        String timeZone = TimeZone.getDefault().getDisplayName(TimeZone.getDefault().inDaylightTime(now), 0);
        String utcTime = this.utcDateFormatter.format(now);
        String displayTime = this.localDateFormatter.format(now);
        StanzaBuilder stanzaBuilder = (StanzaBuilder)((StanzaBuilder)((StanzaBuilder)((StanzaBuilder)((StanzaBuilder)((StanzaBuilder)((StanzaBuilder)((StanzaBuilder)((StanzaBuilder)((StanzaBuilder)((StanzaBuilder)StanzaBuilder.createIQStanza(stanza.getTo(), stanza.getFrom(), IQStanzaType.RESULT, stanza.getID()).startInnerElement("query", "jabber:iq:time")).startInnerElement("utc", "jabber:iq:time")).addText(utcTime)).endInnerElement()).startInnerElement("tz", "jabber:iq:time")).addText(timeZone)).endInnerElement()).startInnerElement("display", "jabber:iq:time")).addText(displayTime)).endInnerElement()).endInnerElement();
        return (Stanza)stanzaBuilder.build();
    }
}

