/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0160_offline_storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.extension.xep0160_offline_storage.AbstractOfflineStorageProvider;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryOfflineStorageProvider
extends AbstractOfflineStorageProvider {
    final Logger logger = LoggerFactory.getLogger(MemoryOfflineStorageProvider.class);
    private long timeout;
    private Map<String, List<Entry>> offlineStorageMap = new HashMap<String, List<Entry>>();

    public MemoryOfflineStorageProvider() {
        this(604800000L);
    }

    public MemoryOfflineStorageProvider(long timeout) {
        this.timeout = timeout;
        Thread checker = new Thread((Runnable)new TimeoutChecker(), "OfflineTimeoutCheckerThread");
        checker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void storeStanza(Stanza stanza) {
        Entity to = stanza.getTo();
        String bareJID = to.getBareJID().getFullQualifiedName();
        Map<String, List<Entry>> map = this.offlineStorageMap;
        synchronized (map) {
            List<Entry> entriesForJID = this.offlineStorageMap.get(bareJID);
            if (entriesForJID == null) {
                entriesForJID = new ArrayList<Entry>();
                this.offlineStorageMap.put(bareJID, entriesForJID);
            }
            entriesForJID.add(new Entry(stanza, new Date().getTime()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Stanza> getStanzasForBareJID(String bareJID) {
        Map<String, List<Entry>> map = this.offlineStorageMap;
        synchronized (map) {
            List<Entry> entries = this.offlineStorageMap.remove(bareJID);
            if (entries == null) {
                return Collections.emptyList();
            }
            ArrayList<Stanza> stanzas = new ArrayList<Stanza>();
            for (Entry entry : entries) {
                stanzas.add(entry.getStanza());
            }
            return stanzas;
        }
    }

    private class TimeoutChecker
    implements Runnable {
        private TimeoutChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block5: while (true) {
                try {
                    Thread.sleep(6000000L);
                }
                catch (InterruptedException e) {
                    MemoryOfflineStorageProvider.this.logger.warn("Interrupted", (Throwable)e);
                }
                MemoryOfflineStorageProvider.this.logger.debug("Running timeout checker for offline stanzas");
                long timestamp = new Date().getTime() - MemoryOfflineStorageProvider.this.timeout;
                Set jids = MemoryOfflineStorageProvider.this.offlineStorageMap.keySet();
                Iterator i$ = jids.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block5;
                    String jid = (String)i$.next();
                    Map map = MemoryOfflineStorageProvider.this.offlineStorageMap;
                    synchronized (map) {
                        List entries = (List)MemoryOfflineStorageProvider.this.offlineStorageMap.get(jid);
                        if (entries != null) {
                            Iterator it = entries.iterator();
                            while (it.hasNext()) {
                                Entry entry = (Entry)it.next();
                                if (entry.getTimeStamp() >= timestamp) continue;
                                MemoryOfflineStorageProvider.this.logger.debug("Removed timed out offline stanza");
                                it.remove();
                            }
                        }
                    }
                }
                break;
            }
        }
    }

    private static class Entry {
        private Stanza stanza;
        private long timeStamp;

        public Entry(Stanza stanza, long timeStamp) {
            this.stanza = stanza;
            this.timeStamp = timeStamp;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public Stanza getStanza() {
            return this.stanza;
        }
    }
}

