/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.delivery.failure;

import java.util.List;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.delivery.StanzaRelay;
import org.apache.vysper.xmpp.delivery.failure.DeliveryException;
import org.apache.vysper.xmpp.delivery.failure.DeliveryFailureStrategy;
import org.apache.vysper.xmpp.delivery.failure.IgnoreFailureStrategy;
import org.apache.vysper.xmpp.delivery.failure.LocalRecipientOfflineException;
import org.apache.vysper.xmpp.delivery.failure.NoSuchLocalUserException;
import org.apache.vysper.xmpp.delivery.failure.SmartDeliveryException;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.MessageStanza;
import org.apache.vysper.xmpp.stanza.PresenceStanza;
import org.apache.vysper.xmpp.stanza.PresenceStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.StanzaErrorCondition;
import org.apache.vysper.xmpp.stanza.StanzaErrorType;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReturnErrorToSenderFailureStrategy
implements DeliveryFailureStrategy {
    private StanzaRelay stanzaRelay;

    public ReturnErrorToSenderFailureStrategy(StanzaRelay stanzaRelay) {
        this.stanzaRelay = stanzaRelay;
    }

    @Override
    public void process(Stanza failedToDeliverStanza, List<DeliveryException> deliveryExceptions) throws DeliveryException {
        StanzaErrorCondition stanzaErrorCondition = StanzaErrorCondition.SERVICE_UNAVAILABLE;
        StanzaErrorType errorType = StanzaErrorType.CANCEL;
        if (!(failedToDeliverStanza instanceof XMPPCoreStanza)) {
            throw new DeliveryException("could not return to sender");
        }
        XMPPCoreStanza failedCoreStanza = (XMPPCoreStanza)failedToDeliverStanza;
        if ("error".equals(failedCoreStanza.getType())) {
            return;
        }
        if (deliveryExceptions == null) {
            XMPPCoreStanza error = XMPPCoreStanza.getWrapper(ServerErrorResponses.getStanzaError(stanzaErrorCondition, failedCoreStanza, errorType, "stanza could not be delivered", "en", null));
            this.stanzaRelay.relay(error.getTo(), error, IgnoreFailureStrategy.IGNORE_FAILURE_STRATEGY);
        } else if (deliveryExceptions.size() == 1) {
            DeliveryException deliveryException = deliveryExceptions.get(0);
            if (deliveryException instanceof LocalRecipientOfflineException) {
                stanzaErrorCondition = StanzaErrorCondition.RECIPIENT_UNAVAILABLE;
                if (failedCoreStanza instanceof MessageStanza || failedCoreStanza instanceof IQStanza) {
                    stanzaErrorCondition = StanzaErrorCondition.SERVICE_UNAVAILABLE;
                }
            } else if (deliveryException instanceof NoSuchLocalUserException) {
                stanzaErrorCondition = StanzaErrorCondition.SERVICE_UNAVAILABLE;
                if (failedCoreStanza instanceof PresenceStanza) {
                    PresenceStanzaType presenceStanzaType = ((PresenceStanza)failedCoreStanza).getPresenceType();
                    if (presenceStanzaType == null || presenceStanzaType == PresenceStanzaType.SUBSCRIBED || presenceStanzaType == PresenceStanzaType.UNSUBSCRIBE || presenceStanzaType == PresenceStanzaType.UNSUBSCRIBED || presenceStanzaType == PresenceStanzaType.UNAVAILABLE || presenceStanzaType == PresenceStanzaType.ERROR) {
                        return;
                    }
                    if (presenceStanzaType == PresenceStanzaType.SUBSCRIBE) {
                        Entity from = failedToDeliverStanza.getTo();
                        Entity to = failedToDeliverStanza.getFrom();
                        StanzaBuilder builder = StanzaBuilder.createPresenceStanza(from, to, null, PresenceStanzaType.UNSUBSCRIBED, null, null);
                        Stanza finalStanza = (Stanza)builder.build();
                        this.stanzaRelay.relay(to, finalStanza, IgnoreFailureStrategy.IGNORE_FAILURE_STRATEGY);
                        return;
                    }
                }
            } else if (deliveryException instanceof SmartDeliveryException) {
                SmartDeliveryException smartDeliveryException = (SmartDeliveryException)deliveryException;
                XMPPCoreStanza error = XMPPCoreStanza.getWrapper(ServerErrorResponses.getStanzaError(smartDeliveryException.getStanzaErrorCondition(), failedCoreStanza, smartDeliveryException.getStanzaErrorType(), smartDeliveryException.getErrorText(), "en", null));
                this.stanzaRelay.relay(error.getTo(), error, IgnoreFailureStrategy.IGNORE_FAILURE_STRATEGY);
            }
        } else if (deliveryExceptions.size() > 1) {
            throw new RuntimeException("cannot return to sender for multiple failed deliveries");
        }
    }
}

