/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.spring;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.vysper.storage.StorageProviderRegistry;
import org.apache.vysper.xmpp.addressing.EntityFormatException;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.authorization.AccountCreationException;
import org.apache.vysper.xmpp.authorization.AccountManagement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddUserHelper {
    private final Map<String, String> userPasswordMap = new HashMap<String, String>();

    public AddUserHelper(Map<String, String> userPasswordMap) {
        this.userPasswordMap.putAll(userPasswordMap);
    }

    public void setStorageProviderRegistry(StorageProviderRegistry storageProviderRegistry) throws AccountCreationException, EntityFormatException {
        AccountManagement accountManagement = (AccountManagement)storageProviderRegistry.retrieve(AccountManagement.class);
        if (accountManagement == null) {
            throw new IllegalStateException("no account manager accessible.");
        }
        for (String user : this.userPasswordMap.keySet()) {
            EntityImpl entity = EntityImpl.parse(user);
            if (accountManagement.verifyAccountExists(entity)) continue;
            String password = this.userPasswordMap.get(user);
            if (StringUtils.isEmpty((String)password)) {
                password = RandomStringUtils.randomAlphanumeric((int)8);
                System.out.println(user + " user will be added with random password: '" + password + "'");
            }
            accountManagement.addUser(entity, password);
        }
    }
}

