/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.manager.btm;

import bitronix.tm.internal.BitronixRuntimeException;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.ResourceObjectFactory;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.RecoveryXAResourceHolder;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.resource.common.XAStatefulHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.transaction.xa.XAResource;
import net.sf.ehcache.transaction.manager.btm.EhCacheXAResourceHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EhCacheXAResourceProducer
extends ResourceBean
implements XAResourceProducer {
    private static final Logger LOG = LoggerFactory.getLogger((String)EhCacheXAResourceProducer.class.getName());
    private static final Map PRODUCERS = new HashMap();
    private final List xaResourceHolders = new ArrayList();
    private RecoveryXAResourceHolder recoveryXAResourceHolder;

    private EhCacheXAResourceProducer() {
        this.setApplyTransactionTimeout(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerXAResource(String uniqueName, XAResource xaResource) {
        Map map = PRODUCERS;
        synchronized (map) {
            EhCacheXAResourceProducer xaResourceProducer = (EhCacheXAResourceProducer)((Object)PRODUCERS.get(uniqueName));
            if (xaResourceProducer == null) {
                xaResourceProducer = new EhCacheXAResourceProducer();
                xaResourceProducer.setUniqueName(uniqueName);
                xaResourceProducer.addXAResource(xaResource);
                xaResourceProducer.init();
                PRODUCERS.put(uniqueName, xaResourceProducer);
            } else {
                xaResourceProducer.addXAResource(xaResource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void unregisterXAResource(String uniqueName, XAResource xaResource) {
        Map map = PRODUCERS;
        synchronized (map) {
            EhCacheXAResourceProducer xaResourceProducer = (EhCacheXAResourceProducer)((Object)PRODUCERS.get(uniqueName));
            if (xaResourceProducer != null) {
                boolean found = xaResourceProducer.removeXAResource(xaResource);
                if (!found) {
                    LOG.error("no XAResource " + xaResource + " found in XAResourceProducer with name " + uniqueName);
                }
            } else {
                LOG.error("no XAResourceProducer registered with name " + uniqueName);
            }
        }
    }

    private static boolean isBtm13() {
        try {
            XAResourceHolder.class.getMethod("getResourceBean", new Class[0]);
            return false;
        }
        catch (NoSuchMethodException e) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addXAResource(XAResource xaResource) {
        List list = this.xaResourceHolders;
        synchronized (list) {
            EhCacheXAResourceHolder xaResourceHolder = new EhCacheXAResourceHolder(xaResource, this);
            if (EhCacheXAResourceProducer.isBtm13()) {
                XAResourceHolderState xaResourceHolderState = new XAResourceHolderState((XAResourceHolder)xaResourceHolder, (ResourceBean)this);
                xaResourceHolder.setXAResourceHolderState(xaResourceHolderState);
            }
            this.xaResourceHolders.add(xaResourceHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeXAResource(XAResource xaResource) {
        List list = this.xaResourceHolders;
        synchronized (list) {
            for (int i = 0; i < this.xaResourceHolders.size(); ++i) {
                EhCacheXAResourceHolder xaResourceHolder = (EhCacheXAResourceHolder)((Object)this.xaResourceHolders.get(i));
                if (xaResourceHolder.getXAResource() != xaResource) continue;
                this.xaResourceHolders.remove(i);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAResourceHolderState startRecovery() throws RecoveryException {
        List list = this.xaResourceHolders;
        synchronized (list) {
            if (this.recoveryXAResourceHolder != null) {
                throw new RecoveryException("recovery already in progress on " + (Object)((Object)this));
            }
            if (this.xaResourceHolders.isEmpty()) {
                throw new RecoveryException("no XAResource registered, recovery cannot be done on " + (Object)((Object)this));
            }
            this.recoveryXAResourceHolder = new RecoveryXAResourceHolder((XAResourceHolder)this.xaResourceHolders.get(0));
            return new XAResourceHolderState((XAResourceHolder)this.recoveryXAResourceHolder, (ResourceBean)this);
        }
    }

    public void endRecovery() throws RecoveryException {
        this.recoveryXAResourceHolder = null;
    }

    public void setFailed(boolean failed) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAResourceHolder findXAResourceHolder(XAResource xaResource) {
        List list = this.xaResourceHolders;
        synchronized (list) {
            for (int i = 0; i < this.xaResourceHolders.size(); ++i) {
                EhCacheXAResourceHolder xaResourceHolder = (EhCacheXAResourceHolder)((Object)this.xaResourceHolders.get(i));
                if (xaResource != xaResourceHolder.getXAResource()) continue;
                return xaResourceHolder;
            }
            return null;
        }
    }

    public void init() {
        try {
            ResourceRegistrar.register((XAResourceProducer)this);
        }
        catch (RecoveryException e) {
            throw new BitronixRuntimeException("error recovering " + (Object)((Object)this), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List list = this.xaResourceHolders;
        synchronized (list) {
            this.xaResourceHolders.clear();
            ResourceRegistrar.unregister((XAResourceProducer)this);
        }
    }

    public XAStatefulHolder createPooledConnection(Object xaFactory, ResourceBean bean) throws Exception {
        throw new UnsupportedOperationException("EhCache is not connection-oriented");
    }

    public Reference getReference() throws NamingException {
        return new Reference(EhCacheXAResourceProducer.class.getName(), new StringRefAddr("uniqueName", this.getUniqueName()), ResourceObjectFactory.class.getName(), null);
    }
}

