/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.extension.xep0124;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.vysper.xml.fragment.Attribute;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.extension.xep0124.BoshBackedSessionContext;
import org.apache.vysper.xmpp.extension.xep0124.BoshRequest;
import org.apache.vysper.xmpp.extension.xep0124.InactivityChecker;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.server.response.ServerResponses;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoshHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoshHandler.class);
    private ServerRuntimeContext serverRuntimeContext;
    private Map<String, BoshBackedSessionContext> sessions = new ConcurrentHashMap<String, BoshBackedSessionContext>();
    private InactivityChecker inactivityChecker = new InactivityChecker();

    public BoshHandler() {
        this.inactivityChecker.start();
    }

    public ServerRuntimeContext getServerRuntimeContext() {
        return this.serverRuntimeContext;
    }

    public void setServerRuntimeContext(ServerRuntimeContext serverRuntimeContext) {
        this.serverRuntimeContext = serverRuntimeContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(HttpServletRequest httpRequest, Stanza body) {
        if (!body.getNamespaceURI().equalsIgnoreCase("http://jabber.org/protocol/httpbind")) {
            LOGGER.error("Invalid namespace for body wrapper '{}', must be '{}'!", (Object)body.getNamespaceURI(), (Object)"http://jabber.org/protocol/httpbind");
            return;
        }
        if (!body.getName().equalsIgnoreCase("body")) {
            LOGGER.error("Invalid body wrapper '{}'!", (Object)body.getName());
            return;
        }
        if (body.getAttribute("rid") == null) {
            LOGGER.error("Invalid request that does not have a request identifier (rid) attribute!");
            return;
        }
        BoshRequest br = new BoshRequest(httpRequest, body, Long.parseLong(body.getAttributeValue("rid")));
        if (body.getAttribute("sid") == null) {
            try {
                this.createSession(br);
            }
            catch (IOException e) {
                LOGGER.error("Exception thrown while processing the session creation request", (Throwable)e);
                return;
            }
        }
        BoshBackedSessionContext session = this.sessions.get(body.getAttributeValue("sid"));
        if (session == null) {
            LOGGER.warn("Received an invalid 'sid'!");
            return;
        }
        BoshBackedSessionContext boshBackedSessionContext = session;
        synchronized (boshBackedSessionContext) {
            session.insertRequest(br);
            while ((br = session.getNextRequest()) != null) {
                this.processSession(session, br);
            }
        }
    }

    private void processSession(BoshBackedSessionContext session, BoshRequest br) {
        if (session.getState() == SessionState.ENCRYPTED) {
            if (br.getBody().getInnerElements().isEmpty()) {
                return;
            }
            for (XMLElement element : br.getBody().getInnerElements()) {
                if (!element.getNamespaceURI().equals("urn:ietf:params:xml:ns:xmpp-sasl")) continue;
                this.processStanza(session, element);
            }
        } else if (session.getState() == SessionState.AUTHENTICATED) {
            if ("true".equals(br.getBody().getAttributeValue("urn:xmpp:xbosh", "restart"))) {
                session.write0(this.getRestartResponse());
            } else {
                for (XMLElement element : br.getBody().getInnerElements()) {
                    this.processStanza(session, element);
                }
                if ("terminate".equals(br.getBody().getAttributeValue("type"))) {
                    this.terminateSession(session);
                }
            }
        }
    }

    private void terminateSession(BoshBackedSessionContext session) {
        this.sessions.remove(session.getSessionId());
        session.write0(this.getTerminateResponse());
        session.close();
    }

    private void processStanza(BoshBackedSessionContext session, XMLElement element) {
        Stanza stanza = element instanceof Stanza ? (Stanza)element : new Stanza(element.getNamespaceURI(), element.getName(), element.getNamespacePrefix(), element.getAttributes(), element.getInnerFragments());
        this.serverRuntimeContext.getStanzaProcessor().processStanza(this.serverRuntimeContext, (SessionContext)session, stanza, session.getStateHolder());
    }

    private void createSession(BoshRequest br) throws IOException {
        BoshBackedSessionContext session = new BoshBackedSessionContext(this, this.serverRuntimeContext, this.inactivityChecker);
        if (br.getBody().getAttribute("content") != null) {
            session.setContentType(br.getBody().getAttributeValue("content"));
        }
        if (br.getBody().getAttribute("wait") != null) {
            int wait = Integer.parseInt(br.getBody().getAttributeValue("wait"));
            session.setWait(wait);
        }
        if (br.getBody().getAttribute("hold") != null) {
            int hold = Integer.parseInt(br.getBody().getAttributeValue("hold"));
            session.setHold(hold);
        }
        if (br.getBody().getAttribute("ver") != null) {
            String ver = br.getBody().getAttributeValue("ver");
            session.setBoshVersion(ver);
        }
        if (br.getBody().getAttribute("http://www.w3.org/XML/1998/namespace", "lang") != null) {
            String lang = br.getBody().getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
            session.setXMLLang(lang);
        }
        if ("1".equals(br.getBody().getAttributeValue("ack"))) {
            session.setClientAcknowledgements(true);
        }
        session.insertRequest(br);
        this.sessions.put(session.getSessionId(), session);
        session.write0(this.getSessionCreationResponse(session));
    }

    private Stanza getSessionCreationResponse(BoshBackedSessionContext session) {
        StanzaBuilder body = new StanzaBuilder("body", "http://jabber.org/protocol/httpbind");
        body.addAttribute("wait", Integer.toString(session.getWait()));
        body.addAttribute("inactivity", Integer.toString(session.getInactivity()));
        body.addAttribute("polling", Integer.toString(session.getPolling()));
        body.addAttribute("requests", Integer.toString(session.getRequests()));
        body.addAttribute("hold", Integer.toString(session.getHold()));
        body.addAttribute("sid", session.getSessionId());
        body.addAttribute("ver", session.getBoshVersion());
        body.addAttribute("from", session.getServerJID().getFullQualifiedName());
        body.addAttribute("secure", "true");
        body.addAttribute("maxpause", Integer.toString(session.getMaxPause()));
        body.addAttribute("ack", Long.toString(session.getHighestReadRid()));
        Stanza features = new ServerResponses().getFeaturesForAuthentication(this.serverRuntimeContext.getServerFeatures().getAuthenticationMethods());
        body.addPreparedElement((XMLElement)features);
        return (Stanza)body.build();
    }

    public Stanza getEmptyResponse() {
        StanzaBuilder stanzaBuilder = new StanzaBuilder("body", "http://jabber.org/protocol/httpbind");
        return (Stanza)stanzaBuilder.build();
    }

    public Stanza wrapStanza(Stanza stanza) {
        StanzaBuilder body = new StanzaBuilder("body", "http://jabber.org/protocol/httpbind");
        body.addPreparedElement((XMLElement)stanza);
        return (Stanza)body.build();
    }

    public Stanza mergeResponses(Stanza response1, Stanza response2) {
        if (response1 == null && response2 == null) {
            return null;
        }
        if (response1 == null) {
            return response2;
        }
        if (response2 == null) {
            return response1;
        }
        StanzaBuilder body = new StanzaBuilder("body", "http://jabber.org/protocol/httpbind");
        for (XMLElement element : response1.getInnerElements()) {
            body.addPreparedElement(element);
        }
        for (XMLElement element : response2.getInnerElements()) {
            body.addPreparedElement(element);
        }
        return (Stanza)body.build();
    }

    private Stanza getRestartResponse() {
        Stanza features = new ServerResponses().getFeaturesForSession();
        return this.wrapStanza(features);
    }

    public Stanza getTerminateResponse() {
        StanzaBuilder stanzaBuilder = new StanzaBuilder("body", "http://jabber.org/protocol/httpbind");
        stanzaBuilder.addAttribute("type", "terminate");
        return (Stanza)stanzaBuilder.build();
    }

    public Stanza addAttribute(Stanza stanza, String attributeName, String attributeValue) {
        StanzaBuilder stanzaBuilder = new StanzaBuilder("body", "http://jabber.org/protocol/httpbind");
        for (Attribute attr : stanza.getAttributes()) {
            stanzaBuilder.addAttribute(attr);
        }
        stanzaBuilder.addAttribute(attributeName, attributeValue);
        for (XMLElement element : stanza.getInnerElements()) {
            stanzaBuilder.addPreparedElement(element);
        }
        return (Stanza)stanzaBuilder.build();
    }
}

