/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import javax.jcr.NamespaceException;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.query.lucene.NamePathResolverImpl;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;

public class NSRegistryBasedNamespaceMappings
implements NamespaceResolver,
NamespaceMappings {
    private final NamespaceRegistryImpl nsReg;
    private final NameResolver nameResolver;

    NSRegistryBasedNamespaceMappings(NamespaceRegistryImpl nsReg) {
        this.nsReg = nsReg;
        this.nameResolver = NamePathResolverImpl.create(this);
    }

    public String getURI(String prefix) throws NamespaceException {
        try {
            int index = Integer.parseInt(prefix);
            return this.nsReg.indexToString(index);
        }
        catch (IllegalArgumentException e) {
            throw new NamespaceException("Unknown namespace prefix: " + prefix, (Throwable)e);
        }
    }

    public String getPrefix(String uri) throws NamespaceException {
        try {
            return String.valueOf(this.nsReg.stringToIndex(uri));
        }
        catch (IllegalArgumentException e) {
            throw new NamespaceException("Unknown namespace URI: " + uri, (Throwable)e);
        }
    }

    public String translatePropertyName(Name qName) throws IllegalNameException {
        try {
            return this.nameResolver.getJCRName(qName);
        }
        catch (NamespaceException e) {
            throw new IllegalNameException("Internal error.", (Throwable)e);
        }
    }
}

