/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.ShExQual;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.UserType;
import org.apache.derby.impl.store.access.CacheLock;
import org.apache.derby.impl.store.access.PC_XenaVersion;
import org.apache.derby.impl.store.access.RAMTransaction;
import org.apache.derby.impl.store.access.UTF;
import org.apache.derby.impl.store.access.UTFQualifier;

class PropertyConglomerate {
    protected long propertiesConglomId;
    protected Properties serviceProperties;
    private LockFactory lf;
    private Dictionary cachedSet;
    private CacheLock cachedLock;
    private PropertyFactory pf;

    PropertyConglomerate(TransactionController transactionController, boolean bl, Properties properties, PropertyFactory propertyFactory) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray;
        this.pf = propertyFactory;
        if (!bl) {
            dataValueDescriptorArray = properties.getProperty("derby.storage.propertiesId");
            if (dataValueDescriptorArray == null) {
                bl = true;
            } else {
                try {
                    this.propertiesConglomId = Long.valueOf((String)dataValueDescriptorArray);
                }
                catch (NumberFormatException numberFormatException) {
                    throw Monitor.exceptionStartingModule(numberFormatException);
                }
            }
        }
        if (bl) {
            dataValueDescriptorArray = this.makeNewTemplate();
            Properties properties2 = new Properties();
            properties2.put("derby.storage.pageSize", "2048");
            properties2.put("derby.storage.pageReservedSpace", "0");
            this.propertiesConglomId = transactionController.createConglomerate("heap", dataValueDescriptorArray, null, properties2, 0);
            properties.put("derby.storage.propertiesId", Long.toString(this.propertiesConglomId));
        }
        this.serviceProperties = properties;
        this.lf = ((RAMTransaction)transactionController).getAccessManager().getLockFactory();
        this.cachedLock = new CacheLock(this);
        dataValueDescriptorArray = new PC_XenaVersion();
        if (bl) {
            this.setProperty(transactionController, "PropertyConglomerateVersion", (Serializable)dataValueDescriptorArray, true);
        } else {
            dataValueDescriptorArray.upgradeIfNeeded(transactionController, this, properties);
        }
        this.getCachedDbProperties(transactionController);
    }

    private DataValueDescriptor[] makeNewTemplate(String string, Serializable serializable) {
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[]{new UTF(string), new UserType(serializable)};
        return dataValueDescriptorArray;
    }

    private DataValueDescriptor[] makeNewTemplate() {
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[]{new UTF(), new UserType()};
        return dataValueDescriptorArray;
    }

    private ScanController openScan(TransactionController transactionController, String string, int n) throws StandardException {
        Qualifier[][] qualifierArray = null;
        if (string != null) {
            qualifierArray = new Qualifier[][]{new Qualifier[1]};
            qualifierArray[0][0] = new UTFQualifier(0, string);
        }
        ScanController scanController = transactionController.openScan(this.propertiesConglomId, false, n, 7, 5, null, null, 0, qualifierArray, null, 0);
        return scanController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPropertyDefault(TransactionController transactionController, String string, Serializable serializable) throws StandardException {
        this.lockProperties(transactionController);
        Serializable serializable2 = null;
        if (this.propertyDefaultIsVisible(transactionController, string)) {
            serializable2 = this.validateApplyAndMap(transactionController, string, serializable, false);
        } else {
            PropertyConglomerate propertyConglomerate = this;
            synchronized (propertyConglomerate) {
                Hashtable hashtable = new Hashtable();
                this.getProperties(transactionController, hashtable, false, true);
                this.validate(string, serializable, hashtable);
                serializable2 = this.map(string, serializable, hashtable);
            }
        }
        this.savePropertyDefault(transactionController, string, serializable2);
    }

    boolean propertyDefaultIsVisible(TransactionController transactionController, String string) throws StandardException {
        this.lockProperties(transactionController);
        return this.readProperty(transactionController, string) == null;
    }

    void saveProperty(TransactionController transactionController, String string, Serializable serializable) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray;
        if (this.saveServiceProperty(string, serializable)) {
            return;
        }
        ScanController scanController = this.openScan(transactionController, string, 4);
        if (scanController.fetchNext(dataValueDescriptorArray = this.makeNewTemplate())) {
            if (serializable == null) {
                scanController.delete();
            } else {
                dataValueDescriptorArray[1] = new UserType(serializable);
                scanController.replace(dataValueDescriptorArray, null);
            }
            scanController.close();
        } else {
            scanController.close();
            scanController = null;
            if (serializable != null) {
                dataValueDescriptorArray = this.makeNewTemplate(string, serializable);
                ConglomerateController conglomerateController = transactionController.openConglomerate(this.propertiesConglomId, false, 4, 7, 5);
                conglomerateController.insert(dataValueDescriptorArray);
                conglomerateController.close();
            }
        }
    }

    private boolean saveServiceProperty(String string, Serializable serializable) {
        if (PropertyUtil.isServiceProperty(string)) {
            if (serializable != null) {
                this.serviceProperties.put(string, serializable);
            } else {
                this.serviceProperties.remove(string);
            }
            return true;
        }
        return false;
    }

    void savePropertyDefault(TransactionController transactionController, String string, Serializable serializable) throws StandardException {
        if (this.saveServiceProperty(string, serializable)) {
            return;
        }
        Dictionary dictionary = (Dictionary)((Object)this.readProperty(transactionController, "derby.defaultPropertyName"));
        if (dictionary == null) {
            dictionary = new FormatableHashtable();
        }
        if (serializable == null) {
            dictionary.remove(string);
        } else {
            dictionary.put(string, serializable);
        }
        if (dictionary.size() == 0) {
            dictionary = null;
        }
        this.saveProperty(transactionController, "derby.defaultPropertyName", (Serializable)((Object)dictionary));
    }

    private Serializable validateApplyAndMap(TransactionController transactionController, String string, Serializable serializable, boolean bl) throws StandardException {
        Hashtable hashtable = new Hashtable();
        this.getProperties(transactionController, hashtable, false, false);
        Serializable serializable2 = this.pf.doValidateApplyAndMap(transactionController, string, serializable, hashtable, bl);
        if (string.equals("logDevice")) {
            throw StandardException.newException("XSRS8.S");
        }
        if (serializable2 == null) {
            return serializable;
        }
        return serializable2;
    }

    private Serializable map(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        return this.pf.doMap(string, serializable, dictionary);
    }

    private void validate(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        this.pf.validateSingleProperty(string, serializable, dictionary);
    }

    private boolean bootPasswordChange(TransactionController transactionController, String string, Serializable serializable) throws StandardException {
        if (string.equals("bootPassword")) {
            AccessFactory accessFactory = ((TransactionManager)transactionController).getAccessManager();
            RawStoreFactory rawStoreFactory = (RawStoreFactory)Monitor.findServiceModule(accessFactory, "org.apache.derby.iapi.store.raw.RawStoreFactory");
            this.serviceProperties.remove("bootPassword");
            serializable = rawStoreFactory.changeBootPassword(this.serviceProperties, serializable);
            this.serviceProperties.put("encryptedBootPassword", serializable);
            return true;
        }
        return false;
    }

    void setProperty(TransactionController transactionController, String string, Serializable serializable, boolean bl) throws StandardException {
        this.lockProperties(transactionController);
        Serializable serializable2 = serializable;
        if (serializable == null) {
            serializable2 = this.getPropertyDefault(transactionController, string);
        }
        Serializable serializable3 = this.validateApplyAndMap(transactionController, string, serializable2, bl);
        if (this.bootPasswordChange(transactionController, string, serializable)) {
            return;
        }
        if (serializable == null) {
            this.saveProperty(transactionController, string, null);
        } else {
            this.saveProperty(transactionController, string, serializable3);
        }
    }

    private Serializable readProperty(TransactionController transactionController, String string) throws StandardException {
        ScanController scanController = this.openScan(transactionController, string, 0);
        DataValueDescriptor[] dataValueDescriptorArray = this.makeNewTemplate();
        boolean bl = scanController.fetchNext(dataValueDescriptorArray);
        scanController.close();
        if (!bl) {
            return null;
        }
        return (Serializable)((UserType)dataValueDescriptorArray[1]).getObject();
    }

    private Serializable getCachedProperty(TransactionController transactionController, String string) throws StandardException {
        Dictionary dictionary = this.getCachedDbProperties(transactionController);
        if (dictionary.get(string) != null) {
            return (Serializable)dictionary.get(string);
        }
        return this.getCachedPropertyDefault(transactionController, string, dictionary);
    }

    private Serializable getCachedPropertyDefault(TransactionController transactionController, String string, Dictionary dictionary) throws StandardException {
        Dictionary dictionary2;
        if (dictionary == null) {
            dictionary = this.getCachedDbProperties(transactionController);
        }
        if ((dictionary2 = (Dictionary)dictionary.get("derby.defaultPropertyName")) == null) {
            return null;
        }
        return (Serializable)dictionary2.get(string);
    }

    Serializable getProperty(TransactionController transactionController, String string) throws StandardException {
        if (PropertyUtil.isServiceProperty(string)) {
            return this.serviceProperties.getProperty(string);
        }
        if (this.iHoldTheUpdateLock(transactionController)) {
            Serializable serializable = this.readProperty(transactionController, string);
            if (serializable != null) {
                return serializable;
            }
            return this.getPropertyDefault(transactionController, string);
        }
        return this.getCachedProperty(transactionController, string);
    }

    Serializable getPropertyDefault(TransactionController transactionController, String string) throws StandardException {
        if (this.iHoldTheUpdateLock(transactionController)) {
            Dictionary dictionary = (Dictionary)((Object)this.readProperty(transactionController, "derby.defaultPropertyName"));
            if (dictionary == null) {
                return null;
            }
            return (Serializable)dictionary.get(string);
        }
        return this.getCachedPropertyDefault(transactionController, string, null);
    }

    private Dictionary copyValues(Dictionary dictionary, Dictionary dictionary2, boolean bl) {
        if (dictionary2 == null) {
            return dictionary;
        }
        Enumeration enumeration = dictionary2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = dictionary2.get(string);
            if (!(v instanceof String) && bl) continue;
            dictionary.put(string, v);
        }
        return dictionary;
    }

    Properties getProperties(TransactionController transactionController) throws StandardException {
        Properties properties = new Properties();
        this.getProperties(transactionController, properties, true, false);
        return properties;
    }

    public void getProperties(TransactionController transactionController, Dictionary dictionary, boolean bl, boolean bl2) throws StandardException {
        if (this.iHoldTheUpdateLock(transactionController)) {
            Dictionary dictionary2 = this.readDbProperties(transactionController);
            Dictionary dictionary3 = (Dictionary)dictionary2.get("derby.defaultPropertyName");
            this.copyValues(dictionary, dictionary3, bl);
            if (!bl2) {
                this.copyValues(dictionary, dictionary2, bl);
            }
        } else {
            Dictionary dictionary4 = this.getCachedDbProperties(transactionController);
            Dictionary dictionary5 = (Dictionary)dictionary4.get("derby.defaultPropertyName");
            this.copyValues(dictionary, dictionary5, bl);
            if (!bl2) {
                this.copyValues(dictionary, dictionary4, bl);
            }
        }
    }

    void resetCache() {
        this.cachedSet = null;
    }

    private Dictionary readDbProperties(TransactionController transactionController) throws StandardException {
        Object object;
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        ScanController scanController = this.openScan(transactionController, null, 0);
        DataValueDescriptor[] dataValueDescriptorArray = this.makeNewTemplate();
        while (scanController.fetchNext(dataValueDescriptorArray)) {
            Object object2 = ((UserType)dataValueDescriptorArray[0]).getObject();
            object = ((UserType)dataValueDescriptorArray[1]).getObject();
            ((Dictionary)hashtable).put(object2, object);
        }
        scanController.close();
        for (int i = 0; i < PropertyUtil.servicePropertyList.length; ++i) {
            object = this.serviceProperties.getProperty(PropertyUtil.servicePropertyList[i]);
            if (object == null) continue;
            ((Dictionary)hashtable).put(PropertyUtil.servicePropertyList[i], object);
        }
        return hashtable;
    }

    private Dictionary getCachedDbProperties(TransactionController transactionController) throws StandardException {
        Dictionary dictionary = this.cachedSet;
        if (dictionary == null) {
            this.cachedSet = dictionary = this.readDbProperties(transactionController);
        }
        return dictionary;
    }

    void lockProperties(TransactionController transactionController) throws StandardException {
        Object object = transactionController.getLockObject();
        this.lf.lockObject(object, object, this.cachedLock, ShExQual.EX, -2);
    }

    private boolean iHoldTheUpdateLock(TransactionController transactionController) throws StandardException {
        Object object = transactionController.getLockObject();
        return this.lf.isLockHeld(object, object, this.cachedLock, ShExQual.EX);
    }
}

