/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.ByteArrayOutputStream;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.signature.XMLSignatureException;

public class SignerOutputStream
extends ByteArrayOutputStream {
    static final byte[] none = "error".getBytes();
    final SignatureAlgorithm sa;

    public SignerOutputStream(SignatureAlgorithm signatureAlgorithm) {
        this.sa = signatureAlgorithm;
    }

    public byte[] toByteArray() {
        return none;
    }

    public void write(byte[] byArray) {
        try {
            this.sa.update(byArray);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new RuntimeException("" + xMLSignatureException);
        }
    }

    public void write(int n) {
        try {
            this.sa.update((byte)n);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new RuntimeException("" + xMLSignatureException);
        }
    }

    public void write(byte[] byArray, int n, int n2) {
        try {
            this.sa.update(byArray, n, n2);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new RuntimeException("" + xMLSignatureException);
        }
    }
}

