/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.Variable;
import org.apache.manifoldcf.scriptengine.VariableBase;
import org.apache.manifoldcf.scriptengine.VariableBoolean;
import org.apache.manifoldcf.scriptengine.VariableReference;

public class VariableURL
extends VariableBase {
    protected String encodedURL;
    protected String encodedArgs;

    public VariableURL(String baseURLValue) {
        this(baseURLValue, null);
    }

    public VariableURL(String baseURLValue, String encodedArgsValue) {
        this.encodedURL = baseURLValue;
        if (this.encodedURL.endsWith("/")) {
            this.encodedURL = this.encodedURL.substring(0, this.encodedURL.length() - 1);
        }
        this.encodedArgs = encodedArgsValue;
    }

    public int hashCode() {
        return this.encodedURL.hashCode() + this.encodedArgs.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof VariableURL)) {
            return false;
        }
        VariableURL other = (VariableURL)o;
        if (!other.encodedURL.equals(this.encodedURL)) {
            return false;
        }
        if (other.encodedArgs != null || this.encodedArgs != null) {
            if (other.encodedArgs == this.encodedArgs) {
                return true;
            }
            if (other.encodedArgs == null || this.encodedArgs == null) {
                return false;
            }
            return other.encodedArgs.equals(this.encodedArgs);
        }
        return true;
    }

    @Override
    public boolean hasStringValue() throws ScriptException {
        return true;
    }

    @Override
    public boolean hasScriptValue() throws ScriptException {
        return true;
    }

    @Override
    public String getScriptValue() throws ScriptException {
        StringBuilder sb = new StringBuilder();
        String value = this.getStringValue();
        sb.append("\"");
        int i = 0;
        while (i < value.length()) {
            char x;
            if ((x = value.charAt(i++)) == '\\' || x == '\"') {
                sb.append('\\');
            }
            sb.append(x);
        }
        sb.append("\"");
        return sb.toString();
    }

    @Override
    public String getStringValue() throws ScriptException {
        if (this.encodedArgs != null) {
            return this.encodedURL + "?" + this.encodedArgs;
        }
        return this.encodedURL;
    }

    @Override
    public VariableReference plus(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '+' operand cannot be null"));
        }
        Object urlSide = this.encodedURL;
        if (v.hasURLPathValue()) {
            urlSide = (String)urlSide + "/" + v.getURLPathValue();
        }
        Object argSide = this.encodedArgs;
        if (v.hasQueryArgumentValue()) {
            argSide = argSide == null ? v.getQueryArgumentValue() : (String)argSide + "&" + v.getQueryArgumentValue();
        }
        return new VariableURL((String)urlSide, (String)argSide);
    }

    @Override
    public VariableReference doubleEquals(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '==' operand cannot be null"));
        }
        return new VariableBoolean(this.getStringValue().equals(v.getStringValue()));
    }

    @Override
    public VariableReference exclamationEquals(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '!=' operand cannot be null"));
        }
        return new VariableBoolean(!this.getStringValue().equals(v.getStringValue()));
    }
}

