/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.ReadWriteLockSync;
import net.sf.ehcache.concurrent.StripedReadWriteLock;
import net.sf.ehcache.concurrent.StripedReadWriteLockSync;
import net.sf.ehcache.search.impl.SearchManager;
import net.sf.ehcache.store.AbstractStore;
import net.sf.ehcache.store.CacheKeySet;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.StripedReadWriteLockProvider;
import net.sf.ehcache.store.TierableStore;
import net.sf.ehcache.store.compound.ReadWriteCopyStrategy;
import net.sf.ehcache.util.SetAsList;
import net.sf.ehcache.writer.CacheWriterManager;

public abstract class FrontEndCacheTier<T extends TierableStore, U extends TierableStore>
extends AbstractStore {
    private static final int DEFAULT_LOCK_STRIPE_COUNT = 128;
    protected final T cache;
    protected final U authority;
    private final StripedReadWriteLock masterLocks;
    private final boolean copyOnRead;
    private final boolean copyOnWrite;
    private final ReadWriteCopyStrategy<Element> copyStrategy;
    private final ConcurrentMap<Object, Fault> faults = new ConcurrentHashMap<Object, Fault>();

    public FrontEndCacheTier(T cache, U authority, ReadWriteCopyStrategy<Element> copyStrategy, SearchManager searchManager, boolean copyOnWrite, boolean copyOnRead) {
        super(searchManager);
        this.cache = cache;
        this.authority = authority;
        this.copyStrategy = copyStrategy;
        this.copyOnWrite = copyOnWrite;
        this.copyOnRead = copyOnRead;
        this.masterLocks = authority instanceof StripedReadWriteLockProvider ? ((StripedReadWriteLockProvider)authority).createStripedReadWriteLock() : new StripedReadWriteLockSync(128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpinAll() {
        this.writeLock();
        try {
            this.authority.unpinAll();
            this.cache.unpinAll();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPinned(Object key) {
        Lock lock = this.getLockFor(key).readLock();
        lock.lock();
        try {
            boolean bl = this.authority.isPinned(key) || this.cache.isPinned(key);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPinned(Object key, boolean pinned) {
        Lock lock = this.getLockFor(key).writeLock();
        lock.lock();
        try {
            this.authority.setPinned(key, pinned);
            this.cache.setPinned(key, pinned);
        }
        finally {
            lock.unlock();
        }
    }

    protected Element copyElementForReadIfNeeded(Element element) {
        if (this.copyOnRead && this.copyOnWrite) {
            return this.copyStrategy.copyForRead(element);
        }
        if (this.copyOnRead) {
            return this.copyStrategy.copyForRead(this.copyStrategy.copyForWrite(element));
        }
        return element;
    }

    protected Element copyElementForWriteIfNeeded(Element element) {
        if (this.copyOnRead && this.copyOnWrite) {
            return this.copyStrategy.copyForWrite(element);
        }
        if (this.copyOnWrite) {
            return this.copyStrategy.copyForRead(this.copyStrategy.copyForWrite(element));
        }
        return element;
    }

    private Element copyElementForRemovalIfNeeded(Element element) {
        if (this.copyOnRead && this.copyOnWrite) {
            return this.copyStrategy.copyForWrite(element);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Element get(Object key) {
        if (key == null) {
            return null;
        }
        lock = this.getLockFor(key).readLock();
        lock.lock();
        try {
            e = this.cache.get(key);
            if (e == null) {
                fault = this.faults.putIfAbsent(key, new Fault());
                if (fault == null) {
                    try {
                        e = this.authority.get(key);
                        if (e == null) ** GOTO lbl20
                        this.cache.put(e);
                    }
                    finally {
                        ((Fault)this.faults.remove(key)).complete(e);
                    }
                } else {
                    e = fault.get();
                }
            }
lbl20:
            // 5 sources

            var4_4 = this.copyElementForReadIfNeeded(e);
            return var4_4;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Element getQuiet(Object key) {
        if (key == null) {
            return null;
        }
        lock = this.getLockFor(key).readLock();
        lock.lock();
        try {
            e = this.cache.getQuiet(key);
            if (e == null) {
                fault = this.faults.putIfAbsent(key, new Fault());
                if (fault == null) {
                    try {
                        e = this.authority.getQuiet(key);
                        if (e == null) ** GOTO lbl20
                        this.cache.put(e);
                    }
                    finally {
                        ((Fault)this.faults.remove(key)).complete(e);
                    }
                } else {
                    e = fault.get();
                }
            }
lbl20:
            // 5 sources

            var4_4 = this.copyElementForReadIfNeeded(e);
            return var4_4;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(Element e) {
        if (e == null) {
            return true;
        }
        Object key = e.getObjectKey();
        Lock lock = this.getLockFor(key).writeLock();
        lock.lock();
        try {
            Element copy = this.copyElementForWriteIfNeeded(e);
            boolean put = this.authority.put(copy);
            try {
                this.cache.fill(copy);
            }
            catch (OutOfMemoryError oome) {
                this.authority.remove(e.getKey());
                throw oome;
            }
            boolean bl = put;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putWithWriter(Element e, CacheWriterManager writer) {
        if (e == null) {
            return true;
        }
        Object key = e.getObjectKey();
        Lock lock = this.getLockFor(key).writeLock();
        lock.lock();
        try {
            Element copy = this.copyElementForWriteIfNeeded(e);
            boolean put = this.authority.putWithWriter(copy, writer);
            try {
                this.cache.fill(copy);
            }
            catch (OutOfMemoryError oome) {
                this.authority.remove(e.getKey());
                throw oome;
            }
            boolean bl = put;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element remove(Object key) {
        if (key == null) {
            return null;
        }
        Lock lock = this.getLockFor(key).writeLock();
        lock.lock();
        try {
            Element e = this.cache.remove(key);
            if (e == null) {
                Element element = this.copyElementForReadIfNeeded(this.authority.remove(key));
                return element;
            }
            this.authority.removeNoReturn(key);
            Element element = this.copyElementForReadIfNeeded(e);
            return element;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        if (key == null) {
            return null;
        }
        Lock lock = this.getLockFor(key).writeLock();
        lock.lock();
        try {
            this.cache.remove(key);
            Element element = this.copyElementForReadIfNeeded(this.authority.removeWithWriter(key, writerManager));
            return element;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element putIfAbsent(Element e) throws NullPointerException {
        Object key = e.getObjectKey();
        Lock lock = this.getLockFor(key).writeLock();
        lock.lock();
        try {
            Element copy = this.copyElementForWriteIfNeeded(e);
            Element old = this.authority.putIfAbsent(copy);
            if (old == null) {
                try {
                    this.cache.fill(copy);
                }
                catch (OutOfMemoryError oome) {
                    this.authority.remove(copy.getKey());
                    throw oome;
                }
            }
            Element element = this.copyElementForReadIfNeeded(old);
            return element;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element removeElement(Element e, ElementValueComparator comparator) throws NullPointerException {
        Object key = e.getObjectKey();
        Lock lock = this.getLockFor(key).writeLock();
        lock.lock();
        try {
            this.cache.remove(e.getObjectKey());
            Element element = this.copyElementForReadIfNeeded(this.authority.removeElement(this.copyElementForRemovalIfNeeded(e), comparator));
            return element;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(Element old, Element e, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        Object key = old.getObjectKey();
        Lock lock = this.getLockFor(key).writeLock();
        lock.lock();
        try {
            Element copy = this.copyElementForWriteIfNeeded(e);
            this.cache.remove(old.getObjectKey());
            boolean bl = this.authority.replace(this.copyElementForRemovalIfNeeded(old), copy, comparator);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element replace(Element e) throws NullPointerException {
        Object key = e.getObjectKey();
        Lock lock = this.getLockFor(key).writeLock();
        lock.lock();
        try {
            Element copy = this.copyElementForWriteIfNeeded(e);
            this.cache.remove(e.getObjectKey());
            Element element = this.copyElementForReadIfNeeded(this.authority.replace(copy));
            return element;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        Lock lock = this.getLockFor(key).readLock();
        lock.lock();
        try {
            boolean bl = this.cache.containsKey(key) || this.authority.containsKey(key);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKeyOnDisk(Object key) {
        if (key == null) {
            return false;
        }
        Lock lock = this.getLockFor(key).readLock();
        lock.lock();
        try {
            boolean bl = this.cache.containsKeyOnDisk(key) || this.authority.containsKeyOnDisk(key);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKeyOffHeap(Object key) {
        if (key == null) {
            return false;
        }
        Lock lock = this.getLockFor(key).readLock();
        lock.lock();
        try {
            boolean bl = this.cache.containsKeyOffHeap(key) || this.authority.containsKeyOffHeap(key);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKeyInMemory(Object key) {
        if (key == null) {
            return false;
        }
        Lock lock = this.getLockFor(key).readLock();
        lock.lock();
        try {
            boolean bl = this.cache.containsKeyInMemory(key) || this.authority.containsKeyInMemory(key);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<?> getKeys() {
        this.readLock();
        try {
            if (this.cache.isTierPinned() && !this.authority.isPersistent()) {
                List list = this.cache.getKeys();
                return list;
            }
            SetAsList setAsList = new SetAsList(new CacheKeySet(this.authority.getKeys(), this.cache.isTierPinned() ? this.cache.getKeys() : this.cache.getPresentPinnedKeys()));
            return setAsList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() throws CacheException {
        this.writeLock();
        try {
            this.cache.removeAll();
            this.authority.removeAll();
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void dispose() {
        this.cache.dispose();
        this.authority.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        this.readLock();
        try {
            int n = Math.max(this.cache.getSize(), this.authority.getSize());
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInMemorySize() {
        this.readLock();
        try {
            int n = this.authority.getInMemorySize() + this.cache.getInMemorySize();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOffHeapSize() {
        this.readLock();
        try {
            int n = this.authority.getOffHeapSize() + this.cache.getOffHeapSize();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOnDiskSize() {
        this.readLock();
        try {
            int n = this.authority.getOnDiskSize() + this.cache.getOnDiskSize();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTerracottaClusteredSize() {
        this.readLock();
        try {
            int n = this.authority.getTerracottaClusteredSize() + this.cache.getTerracottaClusteredSize();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public long getInMemorySizeInBytes() {
        return this.authority.getInMemorySizeInBytes() + this.cache.getInMemorySizeInBytes();
    }

    @Override
    public long getOffHeapSizeInBytes() {
        return this.authority.getOffHeapSizeInBytes() + this.cache.getOffHeapSizeInBytes();
    }

    @Override
    public long getOnDiskSizeInBytes() {
        return this.authority.getOnDiskSizeInBytes() + this.cache.getOnDiskSizeInBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expireElements() {
        this.writeLock();
        try {
            this.authority.expireElements();
            this.cache.expireElements();
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void flush() throws IOException {
        this.cache.flush();
        this.authority.flush();
    }

    @Override
    public boolean bufferFull() {
        return this.cache.bufferFull() || this.authority.bufferFull();
    }

    private void readLock() {
        for (ReadWriteLockSync lock : this.getAllLocks()) {
            lock.lock(LockType.READ);
        }
    }

    private void readUnlock() {
        for (ReadWriteLockSync lock : this.getAllLocks()) {
            lock.unlock(LockType.READ);
        }
    }

    private void writeLock() {
        for (ReadWriteLockSync lock : this.getAllLocks()) {
            lock.lock(LockType.WRITE);
        }
    }

    private void writeUnlock() {
        for (ReadWriteLockSync lock : this.getAllLocks()) {
            lock.unlock(LockType.WRITE);
        }
    }

    public ReadWriteLock getLockFor(Object key) {
        return this.masterLocks.getLockForKey(key);
    }

    protected List<ReadWriteLockSync> getAllLocks() {
        return this.masterLocks.getAllSyncs();
    }

    @Override
    public Status getStatus() {
        return this.authority.getStatus();
    }

    @Override
    public Policy getInMemoryEvictionPolicy() {
        return this.cache.getInMemoryEvictionPolicy();
    }

    @Override
    public void setInMemoryEvictionPolicy(Policy policy) {
        this.cache.setInMemoryEvictionPolicy(policy);
    }

    @Override
    public final Object getInternalContext() {
        return this.masterLocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEvictionCandidate(Element e) {
        Object key = e.getObjectKey();
        Lock lockForKey = this.masterLocks.getLockForKey(key).writeLock();
        if (lockForKey.tryLock()) {
            try {
                this.cache.removeIfNotPinned(key);
                boolean bl = true;
                return bl;
            }
            finally {
                lockForKey.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCached(Object key) {
        Lock lock = this.getLockFor(key).readLock();
        lock.lock();
        try {
            boolean bl = this.cache.containsKey(key);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean notifyEvictionFromCache(Serializable key) {
        return false;
    }

    @Override
    public boolean hasAbortedSizeOf() {
        return this.cache.hasAbortedSizeOf() || this.authority.hasAbortedSizeOf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recalculateSize(Object key) {
        Lock lock = this.getLockFor(key).writeLock();
        lock.lock();
        try {
            this.authority.recalculateSize(key);
            this.cache.recalculateSize(key);
        }
        finally {
            lock.unlock();
        }
    }

    private static final class Fault {
        private Element result;
        private boolean complete;

        private Fault() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Element get() {
            boolean interrupted = false;
            try {
                Fault fault = this;
                synchronized (fault) {
                    while (!this.complete) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            interrupted = true;
                        }
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void complete(Element e) {
            Fault fault = this;
            synchronized (fault) {
                this.result = e;
                this.complete = true;
                this.notifyAll();
            }
        }
    }
}

