/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.engine;

import java.util.Hashtable;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.conf.Database;
import org.castor.jdo.conf.DatabaseChoice;
import org.castor.jdo.conf.JdoConf;
import org.castor.jdo.engine.AbstractConnectionFactory;
import org.castor.jdo.engine.DataSourceConnectionFactory;
import org.castor.jdo.engine.DriverConnectionFactory;
import org.castor.jdo.engine.JNDIConnectionFactory;
import org.castor.jdo.util.JDOConfFactory;
import org.castor.util.Configuration;
import org.castor.util.Messages;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class DatabaseRegistry {
    private static final Log LOG = LogFactory.getLog((Class)DatabaseRegistry.class);
    private static final Hashtable FACTORIES = new Hashtable();

    public static synchronized void loadDatabase(String name, String engine, DataSource datasource, Mapping mapping, TransactionManager txManager) throws MappingException {
        DataSourceConnectionFactory factory = new DataSourceConnectionFactory(name, engine, datasource, mapping, txManager);
        if (FACTORIES.put(name, factory) != null) {
            LOG.warn((Object)Messages.format("jdo.configLoadedTwice", name));
        }
    }

    public static synchronized void loadDatabase(InputSource source, EntityResolver resolver, ClassLoader loader) throws MappingException {
        JdoConf jdoConf = null;
        jdoConf = JDOConfFactory.createJdoConf(source, resolver, loader);
        LOG.debug((Object)"Loaded jdo conf successfully");
        DatabaseRegistry.loadDatabase(jdoConf, resolver, loader, source.getSystemId());
    }

    public static synchronized void loadDatabase(JdoConf jdoConf, EntityResolver resolver, ClassLoader loader, String baseURI) throws MappingException {
        Configuration cfg = Configuration.getInstance();
        boolean init = cfg.getProperty("org.exolab.castor.jdo.DatabaseInitializeAtLoad", true);
        Database[] databases = jdoConf.getDatabase();
        for (int i = 0; i < databases.length; ++i) {
            String name;
            Mapping mapping = new Mapping(loader);
            if (resolver != null) {
                mapping.setEntityResolver(resolver);
            }
            if (baseURI != null) {
                mapping.setBaseURL(baseURI);
            }
            AbstractConnectionFactory factory = DatabaseRegistry.createFactory(jdoConf, i, mapping);
            if (init) {
                factory.initialize();
            }
            if (FACTORIES.put(name = databases[i].getName(), factory) == null) continue;
            LOG.warn((Object)Messages.format("jdo.configLoadedTwice", name));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static AbstractConnectionFactory createFactory(JdoConf jdoConf, int index, Mapping mapping) throws MappingException {
        void var3_8;
        AbstractConnectionFactory factory;
        DatabaseChoice choice = jdoConf.getDatabase(index).getDatabaseChoice();
        if (choice == null) {
            String name = jdoConf.getDatabase(index).getName();
            String msg = Messages.format("jdo.missingDataSource", name);
            LOG.error((Object)msg);
            throw new MappingException(msg);
        }
        if (choice.getDriver() != null) {
            factory = new DriverConnectionFactory(jdoConf, index, mapping);
        } else if (choice.getDataSource() != null) {
            factory = new DataSourceConnectionFactory(jdoConf, index, mapping);
        } else if (choice.getJndi() != null) {
            factory = new JNDIConnectionFactory(jdoConf, index, mapping);
        } else {
            String name = jdoConf.getDatabase(index).getName();
            String msg = Messages.format("jdo.missingDataSource", name);
            LOG.error((Object)msg);
            throw new MappingException(msg);
        }
        return var3_8;
    }

    public static boolean hasDatabaseRegistries() {
        return !FACTORIES.isEmpty();
    }

    public static boolean isDatabaseRegistred(String name) {
        return FACTORIES.containsKey(name);
    }

    public static AbstractConnectionFactory getConnectionFactory(String name) throws MappingException {
        AbstractConnectionFactory factory;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fetching ConnectionFactory: " + name));
        }
        if ((factory = (AbstractConnectionFactory)FACTORIES.get(name)) == null) {
            String msg = Messages.format("jdo.missingDataSource", name);
            LOG.error((Object)msg);
            throw new MappingException(msg);
        }
        factory.initialize();
        return factory;
    }

    public static void clear() {
        FACTORIES.clear();
    }

    private DatabaseRegistry() {
    }
}

