/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.hadoop.security.authentication.client.AuthenticationException;

public class AuthenticationToken
implements Principal {
    public static final AuthenticationToken ANONYMOUS = new AuthenticationToken();
    private static final String ATTR_SEPARATOR = "&";
    private static final String USER_NAME = "u";
    private static final String PRINCIPAL = "p";
    private static final String EXPIRES = "e";
    private static final String TYPE = "t";
    private static final Set<String> ATTRIBUTES = new HashSet<String>(Arrays.asList("u", "p", "e", "t"));
    private String userName;
    private String principal;
    private String type;
    private long expires;
    private String token;
    private static final String ILLEGAL_ARG_MSG = " is NULL, empty or contains a '&'";

    private AuthenticationToken() {
        this.userName = null;
        this.principal = null;
        this.type = null;
        this.expires = -1L;
        this.token = "ANONYMOUS";
        this.generateToken();
    }

    public AuthenticationToken(String userName, String principal, String type) {
        AuthenticationToken.checkForIllegalArgument(userName, "userName");
        AuthenticationToken.checkForIllegalArgument(principal, "principal");
        AuthenticationToken.checkForIllegalArgument(type, "type");
        this.userName = userName;
        this.principal = principal;
        this.type = type;
        this.expires = -1L;
    }

    private static void checkForIllegalArgument(String value, String name) {
        if (value == null || value.length() == 0 || value.contains(ATTR_SEPARATOR)) {
            throw new IllegalArgumentException(name + ILLEGAL_ARG_MSG);
        }
    }

    public void setExpires(long expires) {
        if (this != ANONYMOUS) {
            this.expires = expires;
            this.generateToken();
        }
    }

    private void generateToken() {
        StringBuffer sb = new StringBuffer();
        sb.append(USER_NAME).append("=").append(this.getUserName()).append(ATTR_SEPARATOR);
        sb.append(PRINCIPAL).append("=").append(this.getName()).append(ATTR_SEPARATOR);
        sb.append(TYPE).append("=").append(this.getType()).append(ATTR_SEPARATOR);
        sb.append(EXPIRES).append("=").append(this.getExpires());
        this.token = sb.toString();
    }

    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getName() {
        return this.principal;
    }

    public String getType() {
        return this.type;
    }

    public long getExpires() {
        return this.expires;
    }

    public boolean isExpired() {
        return this.getExpires() != -1L && System.currentTimeMillis() > this.getExpires();
    }

    @Override
    public String toString() {
        return this.token;
    }

    public static AuthenticationToken parse(String tokenStr) throws AuthenticationException {
        Map<String, String> map = AuthenticationToken.split(tokenStr);
        if (!((Object)map.keySet()).equals(ATTRIBUTES)) {
            throw new AuthenticationException("Invalid token string, missing attributes");
        }
        long expires = Long.parseLong(map.get(EXPIRES));
        AuthenticationToken token = new AuthenticationToken(map.get(USER_NAME), map.get(PRINCIPAL), map.get(TYPE));
        token.setExpires(expires);
        return token;
    }

    private static Map<String, String> split(String tokenStr) throws AuthenticationException {
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(tokenStr, ATTR_SEPARATOR);
        while (st.hasMoreTokens()) {
            String part = st.nextToken();
            int separator = part.indexOf(61);
            if (separator == -1) {
                throw new AuthenticationException("Invalid authentication token");
            }
            String key = part.substring(0, separator);
            String value = part.substring(separator + 1);
            map.put(key, value);
        }
        return map;
    }
}

