/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font;

import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.font.FontValidator;
import org.apache.pdfbox.preflight.font.container.FontContainer;

public abstract class SimpleFontValidator<T extends FontContainer>
extends FontValidator<T> {
    protected PDFontLike font;
    protected COSDictionary fontDictionary;

    public SimpleFontValidator(PreflightContext context, PDFontLike font, COSDictionary fontDictionary, T fContainer) {
        super(context, fontDictionary, fContainer);
        this.fontDictionary = fontDictionary;
        this.font = font;
    }

    @Override
    public void validate() throws ValidationException {
        this.checkMandatoryField();
        this.createFontDescriptorHelper();
        this.processFontDescriptorValidation();
        this.checkEncoding();
        this.checkToUnicode();
    }

    protected void checkMandatoryField() {
        String missingFields = "";
        boolean areFieldsPresent = this.fontDictionary.containsKey(COSName.TYPE);
        if (!areFieldsPresent) {
            missingFields = "type, ";
        }
        boolean subType = this.fontDictionary.containsKey(COSName.SUBTYPE);
        areFieldsPresent &= subType;
        if (!subType) {
            missingFields = missingFields + "subType, ";
        }
        boolean baseFont = this.fontDictionary.containsKey(COSName.BASE_FONT);
        areFieldsPresent &= baseFont;
        if (!baseFont) {
            missingFields = missingFields + "baseFont, ";
        }
        boolean firstChar = this.fontDictionary.containsKey(COSName.FIRST_CHAR);
        areFieldsPresent &= firstChar;
        if (!firstChar) {
            missingFields = missingFields + "firstChar, ";
        }
        boolean lastChar = this.fontDictionary.containsKey(COSName.LAST_CHAR);
        areFieldsPresent &= lastChar;
        if (!lastChar) {
            missingFields = missingFields + "lastChar, ";
        }
        boolean widths = this.fontDictionary.containsKey(COSName.WIDTHS);
        areFieldsPresent &= widths;
        if (!widths) {
            missingFields = missingFields + "widths, ";
        }
        if (!areFieldsPresent) {
            missingFields = missingFields.substring(0, missingFields.length() - 2);
            this.fontContainer.push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": some required fields are missing from the Font dictionary: " + missingFields + "."));
        }
    }

    protected abstract void createFontDescriptorHelper();

    protected void processFontDescriptorValidation() {
        this.descriptorHelper.validate();
    }
}

