/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.sis.util.AbstractInternationalString;
import org.apache.sis.util.ArgumentChecks;

public class ResourceInternationalString
extends AbstractInternationalString
implements Serializable {
    private static final long serialVersionUID = -8636012022904092254L;
    protected final String resources;
    protected final String key;

    public ResourceInternationalString(String string, String string2) {
        ArgumentChecks.ensureNonNull("resources", string);
        ArgumentChecks.ensureNonNull("key", string2);
        this.resources = string;
        this.key = string2;
    }

    protected ResourceBundle getBundle(Locale locale) throws MissingResourceException {
        return ResourceBundle.getBundle(this.resources, locale);
    }

    @Override
    public String toString(Locale locale) throws MissingResourceException {
        if (locale == null) {
            locale = Locale.ROOT;
        }
        return this.getBundle(locale).getString(this.key);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            ResourceInternationalString resourceInternationalString = (ResourceInternationalString)object;
            return this.key.equals(resourceInternationalString.key) && this.resources.equals(resourceInternationalString.resources);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode() ^ this.resources.hashCode() ^ 0x1ACC89A2;
    }
}

