/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main.lock;

import java.sql.ResultSet;
import java.sql.SQLException;

public class GenericStatements {
    private final String lockTableName;
    private final String lockIdTableName;
    private final String clusterName;

    public GenericStatements(String lockTableName, String lockIdTableName, String clusterName) {
        this.lockTableName = lockTableName;
        this.lockIdTableName = lockIdTableName;
        this.clusterName = clusterName;
    }

    public final String getNodeName() {
        return this.clusterName;
    }

    public final String getLockTableName() {
        return this.lockTableName;
    }

    private String getLockTableInitialInsertStatement() {
        return "INSERT INTO " + this.getLockTableName() + "(ID, STATE, LOCK_DELAY) VALUES (0, 0, 0)";
    }

    public String getLockUpdateIdStatement(int id, int state, int lock_delay, int curId) {
        return String.format("UPDATE %s SET ID = %d, STATE = %d, LOCK_DELAY = %d WHERE ID = 0 OR ID = %d", this.getLockTableName(), id, state, lock_delay, curId);
    }

    public String getLockUpdateIdStatementToStealLock(int id, int state, int lock_delay, int curId, int curState) {
        return String.format("UPDATE %s SET ID = %d, STATE = %d, LOCK_DELAY = %d WHERE ( ID = 0 OR ID = %d ) AND STATE = %d", this.getLockTableName(), id, state, lock_delay, curId, curState);
    }

    public String getLockResetIdStatement(int id) {
        return String.format("UPDATE %s SET ID = 0 WHERE ID = %d", this.getLockTableName(), id);
    }

    public String getLockSelectStatement() {
        return "SELECT ID, STATE, LOCK_DELAY FROM " + this.getLockTableName();
    }

    public int getIdFromLockSelectStatement(ResultSet rs) throws SQLException {
        return rs.getInt(1);
    }

    public int getStateFromLockSelectStatement(ResultSet rs) throws SQLException {
        return rs.getInt(2);
    }

    public int getLockDelayFromLockSelectStatement(ResultSet rs) throws SQLException {
        return rs.getInt(3);
    }

    private String getLockTableCreateStatement() {
        return "CREATE TABLE " + this.getLockTableName() + " ( ID INTEGER DEFAULT 0, STATE INTEGER DEFAULT 0 , LOCK_DELAY INTEGER DEFAULT 0 )";
    }

    private String getLockIdTableCreateStatement() {
        return "CREATE TABLE " + this.getLockIdTableName() + " ( ID INTEGER DEFAULT 0 )";
    }

    public String getLockIdSelectStatement() {
        return "SELECT ID FROM " + this.getLockIdTableName();
    }

    public int getIdFromLockIdSelectStatement(ResultSet rs) throws SQLException {
        return rs.getInt(1);
    }

    public String getLockIdUpdateIdStatement(int id, int curId) {
        return String.format("UPDATE %s SET ID = %d WHERE ID = %d", this.getLockIdTableName(), id, curId);
    }

    public final String getLockIdTableName() {
        return this.lockIdTableName;
    }

    public String[] getLockCreateSchemaStatements(long moment) {
        return new String[]{this.getLockTableCreateStatement(), this.getLockIdTableCreateStatement(), this.getLockTableInitialInsertStatement(), this.getLockIdTableInitialInsertStatement()};
    }

    private String getLockIdTableInitialInsertStatement() {
        return "INSERT INTO " + this.getLockIdTableName() + "(ID) VALUES (0)";
    }
}

