/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx;

import java.util.concurrent.atomic.AtomicLong;
import javax.management.StandardMBean;
import org.apache.aries.jmx.Logger;
import org.apache.aries.jmx.MBeanHandler;
import org.apache.aries.jmx.agent.JMXAgentContext;
import org.apache.aries.jmx.util.ObjectNameUtils;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractCompendiumHandler
extends ServiceTracker
implements MBeanHandler {
    protected final JMXAgentContext agentContext;
    protected StandardMBean mbean;
    protected final AtomicLong trackedId = new AtomicLong();

    protected AbstractCompendiumHandler(JMXAgentContext agentContext, Filter filter) {
        super(agentContext.getBundleContext(), filter, null);
        this.agentContext = agentContext;
    }

    protected AbstractCompendiumHandler(JMXAgentContext agentContext, String clazz) {
        super(agentContext.getBundleContext(), clazz, null);
        this.agentContext = agentContext;
    }

    public Object addingService(ServiceReference reference) {
        Logger logger = this.agentContext.getLogger();
        Object trackedService = null;
        long serviceId = (Long)reference.getProperty("service.id");
        if (this.trackedId.compareAndSet(0L, serviceId)) {
            logger.log(3, "Registering MBean with ObjectName [" + this.getName() + "] for service with " + "service.id" + " [" + serviceId + "]");
            trackedService = this.context.getService(reference);
            this.mbean = this.constructInjectMBean(trackedService);
            this.agentContext.registerMBean(this);
        } else {
            String serviceDescription = this.getServiceDescription(reference);
            logger.log(2, "Detected secondary ServiceReference for [" + serviceDescription + "] with " + "service.id" + " [" + serviceId + "] Only 1 instance will be JMX managed");
        }
        return trackedService;
    }

    public void removedService(ServiceReference reference, Object service) {
        Logger logger = this.agentContext.getLogger();
        long serviceID = (Long)reference.getProperty("service.id");
        if (this.trackedId.compareAndSet(serviceID, 0L)) {
            logger.log(3, "Unregistering MBean with ObjectName [" + this.getName() + "] for service with " + "service.id" + " [" + serviceID + "]");
            this.agentContext.unregisterMBean(this);
            this.context.ungetService(reference);
        } else {
            String serviceDescription = this.getServiceDescription(reference);
            logger.log(2, "ServiceReference for [" + serviceDescription + "] with " + "service.id" + " [" + serviceID + "] is not currently JMX managed");
        }
    }

    private String getServiceDescription(ServiceReference reference) {
        String serviceDescription = (String)reference.getProperty("service.description");
        if (serviceDescription == null) {
            Object obj = reference.getProperty("objectClass");
            if (obj instanceof String[]) {
                StringBuilder sb = new StringBuilder();
                for (String s : (String[])obj) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(s);
                }
                serviceDescription = sb.toString();
            } else {
                serviceDescription = obj.toString();
            }
        }
        return serviceDescription;
    }

    @Override
    public StandardMBean getMbean() {
        return this.mbean;
    }

    protected abstract StandardMBean constructInjectMBean(Object var1);

    protected abstract String getBaseName();

    @Override
    public String getName() {
        return ObjectNameUtils.createFullObjectName(this.context, this.getBaseName());
    }
}

