/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.remote;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.remote.RemoteReturn;
import org.apache.juneau.http.remote.RemoteUtils;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;

public class RemoteOperationReturn {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    private final Type returnType;
    private final RemoteReturn returnValue;
    private final ResponseBeanMeta meta;
    private boolean isFuture;
    private boolean isCompletableFuture;

    RemoteOperationReturn(MethodInfo m) {
        ClassInfo rt = m.getReturnType();
        AnnotationProvider ap = AP;
        List<AnnotationInfo<?>> al = CollectionUtils.rstream(ap.find(m, new AnnotationTraversal[0])).filter(RemoteUtils.REMOTE_OP_GROUP).toList();
        RemoteReturn rv = null;
        if (rt.is(Future.class)) {
            this.isFuture = true;
            rt = ClassInfo.of(((ParameterizedType)rt.innerType()).getActualTypeArguments()[0]);
        } else if (rt.is(CompletableFuture.class)) {
            this.isCompletableFuture = true;
            rt = ClassInfo.of(((ParameterizedType)rt.innerType()).getActualTypeArguments()[0]);
        }
        if (rt.is(Void.TYPE) || rt.is(Void.class)) {
            rv = RemoteReturn.NONE;
        } else {
            Value<RemoteReturn> v = Value.of(RemoteReturn.BODY);
            al.forEach(ai -> ai.getValue(RemoteReturn.class, "returns").ifPresent(x -> v.set((RemoteReturn)((Object)x))));
            rv = v.get();
        }
        if (rt.hasAnnotation(Response.class) && rt.isInterface()) {
            this.meta = ResponseBeanMeta.create(m, AnnotationWorkList.create());
            rv = RemoteReturn.BEAN;
        } else {
            this.meta = null;
        }
        this.returnType = rt.innerType();
        this.returnValue = rv;
    }

    public ResponseBeanMeta getResponseBeanMeta() {
        return this.meta;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public RemoteReturn getReturnValue() {
        return this.returnValue;
    }

    public boolean isCompletableFuture() {
        return this.isCompletableFuture;
    }

    public boolean isFuture() {
        return this.isFuture;
    }
}

