/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.junit.bct;

import java.util.function.Supplier;
import org.apache.juneau.commons.function.ResettableSupplier;
import org.apache.juneau.commons.settings.Settings;
import org.apache.juneau.commons.settings.StringSetting;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.junit.bct.BasicBeanConverter;
import org.apache.juneau.junit.bct.BeanConverter;

public class BctConfiguration {
    private static final ThreadLocal<ResettableSupplier<BeanConverter>> CONVERTER_SUPPLIER = ThreadLocal.withInitial(() -> Utils.memr(() -> BasicBeanConverter.DEFAULT));
    public static final String BCT_SORT_MAPS = "Bct.sortMaps";
    public static final String BCT_SORT_COLLECTIONS = "Bct.sortCollections";
    private static final ThreadLocal<BeanConverter> CONVERTER_OVERRIDE = new ThreadLocal();
    private static final Settings SETTINGS = Settings.create().build();

    public static void set(String name, Object value) {
        SETTINGS.setLocal(name, Utils.s(value));
    }

    public static void setGlobal(String name, Object value) {
        SETTINGS.setGlobal(name, Utils.s(value));
    }

    public static StringSetting get(String name) {
        return SETTINGS.get(name);
    }

    public static <T> T get(String name, T def) {
        return SETTINGS.get(name, def);
    }

    public static void clear() {
        SETTINGS.clearLocal();
        CONVERTER_OVERRIDE.remove();
    }

    public static void clearGlobal() {
        SETTINGS.clearGlobal();
    }

    public static void set(BeanConverter converter) {
        AssertionUtils.assertArgNotNull("converter", converter);
        CONVERTER_OVERRIDE.set(converter);
    }

    static BeanConverter getConverter() {
        return Utils.opt(CONVERTER_OVERRIDE.get()).orElseGet((Supplier<BeanConverter>)CONVERTER_SUPPLIER.get());
    }
}

