/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.function;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.juneau.commons.function.OptionalSupplier;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;

public class ResettableSupplier<T>
implements OptionalSupplier<T> {
    private final Supplier<T> supplier;
    private final AtomicReference<Optional<T>> cache = new AtomicReference();

    public ResettableSupplier(Supplier<T> supplier) {
        this.supplier = AssertionUtils.assertArgNotNull("supplier", supplier);
    }

    @Override
    public T get() {
        Optional<Object> h = this.cache.get();
        if (h == null && !this.cache.compareAndSet(null, h = Utils.opt(this.supplier.get()))) {
            h = this.cache.get();
        }
        return h.orElse(null);
    }

    public void reset() {
        this.cache.set(null);
    }

    public void set(T value) {
        this.cache.set(Utils.opt(value));
    }

    public boolean isSupplied() {
        return this.cache.get() == null;
    }

    public ResettableSupplier<T> copy() {
        Optional o = this.cache.get();
        if (o == null) {
            return new ResettableSupplier<T>(this.supplier);
        }
        return new ResettableSupplier<Object>(() -> o.get());
    }

    @Override
    public <U> ResettableSupplier<U> map(Function<? super T, ? extends U> mapper) {
        AssertionUtils.assertArgNotNull("mapper", mapper);
        return new ResettableSupplier<Object>(() -> {
            T value = this.get();
            return Utils.nn(value) ? mapper.apply((T)value) : null;
        });
    }

    @Override
    public ResettableSupplier<T> filter(Predicate<? super T> predicate) {
        AssertionUtils.assertArgNotNull("predicate", predicate);
        return new ResettableSupplier<Object>(() -> {
            T value = this.get();
            return Utils.nn(value) && predicate.test((T)value) ? value : null;
        });
    }
}

