/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.openapi3;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.openapi3.OpenApiElement;
import org.apache.juneau.dto.openapi3.ServerVariable;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;

@Bean(properties="url,description,variables,*")
@FluentSetters
public class Server
extends OpenApiElement {
    private URI url;
    private String description;
    private Map<String, ServerVariable> variables;

    public Server() {
    }

    public Server(Server copyFrom) {
        super(copyFrom);
        this.url = copyFrom.url;
        this.description = copyFrom.description;
        if (copyFrom.variables == null) {
            this.variables = null;
        } else {
            this.variables = new LinkedHashMap<String, ServerVariable>();
            for (Map.Entry<String, ServerVariable> e : copyFrom.variables.entrySet()) {
                this.variables.put(e.getKey(), e.getValue().copy());
            }
        }
    }

    public Server copy() {
        return new Server(this);
    }

    @Override
    protected Server strict() {
        super.strict();
        return this;
    }

    public URI getUrl() {
        return this.url;
    }

    public Server setUrl(URI value) {
        this.url = value;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Server setDescription(String value) {
        this.description = value;
        return this;
    }

    public Map<String, ServerVariable> getVariables() {
        return this.variables;
    }

    public Server setVariables(Map<String, ServerVariable> value) {
        this.variables = CollectionUtils.copyOf(value);
        return this;
    }

    public Server addVariable(String key, ServerVariable value) {
        this.variables = CollectionUtils.mapBuilder(this.variables).sparse().add(key, value).build();
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "url": {
                return ConverterUtils.toType(this.getUrl(), type);
            }
            case "description": {
                return ConverterUtils.toType(this.getDescription(), type);
            }
            case "variables": {
                return ConverterUtils.toType(this.getVariables(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public Server set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "url": {
                return this.setUrl(StringUtils.toURI(value));
            }
            case "description": {
                return this.setDescription(StringUtils.stringify(value));
            }
            case "variables": {
                return this.setVariables(CollectionUtils.mapBuilder(String.class, ServerVariable.class, new Type[0]).sparse().addAny(value).build());
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setBuilder(String.class, new Type[0]).addIf(this.url != null, "url").addIf(this.description != null, "description").addIf(this.variables != null, "variables").build();
        return new MultiSet<String>(s, super.keySet());
    }
}

