/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Value;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.HttpParts;
import org.apache.juneau.http.header.BasicStringHeader;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.httppart.RequestHeader;
import org.apache.juneau.rest.httppart.RequestHttpPart;
import org.apache.juneau.rest.httppart.RequestQueryParams;
import org.apache.juneau.svl.VarResolverSession;

public class RequestHeaders
extends ArrayList<RequestHeader> {
    private static final long serialVersionUID = 1L;
    private final RestRequest req;
    private boolean caseSensitive;
    private final VarResolverSession vs;
    private HttpPartParserSession parser;

    public RequestHeaders(RestRequest req, RequestQueryParams query, boolean caseSensitive) {
        this.req = req;
        this.caseSensitive = caseSensitive;
        this.vs = req.getVarResolverSession();
        Enumeration e = req.getHttpServletRequest().getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Enumeration ve = req.getHttpServletRequest().getHeaders(name);
            while (ve.hasMoreElements()) {
                this.add(new RequestHeader(req, name, (String)ve.nextElement()));
            }
        }
        Set<String> allowedHeaderParams = req.getContext().getAllowedHeaderParams();
        query.forEach((? super E p) -> {
            String name = p.getName();
            String key = this.key(name);
            if (allowedHeaderParams.contains(key) || allowedHeaderParams.contains("*")) {
                this.set(name, p.getValue());
            }
        });
    }

    private RequestHeaders(RequestHeaders copyFrom) {
        this.req = copyFrom.req;
        this.caseSensitive = copyFrom.caseSensitive;
        this.parser = copyFrom.parser;
        this.addAll(copyFrom);
        this.vs = copyFrom.vs;
    }

    private RequestHeaders(RequestHeaders copyFrom, String ... names) {
        this.req = copyFrom.req;
        this.caseSensitive = copyFrom.caseSensitive;
        this.parser = copyFrom.parser;
        this.vs = copyFrom.vs;
        for (String n : names) {
            copyFrom.stream().filter(x -> this.eq(x.getName(), n)).forEach(this::add);
        }
    }

    public RequestHeaders parser(HttpPartParserSession value) {
        this.parser = value;
        this.forEach((? super E x) -> x.parser(this.parser));
        return this;
    }

    public RequestHeaders caseSensitive(boolean value) {
        this.caseSensitive = value;
        return this;
    }

    public RequestHeaders addDefault(List<Header> pairs) {
        ArgUtils.assertArgNotNull((String)"pairs", pairs);
        for (Header p : pairs) {
            String name = p.getName();
            Stream<RequestHeader> l = this.stream(name);
            boolean hasAllBlanks = l.allMatch(x -> StringUtils.isEmpty((String)x.getValue()));
            if (!hasAllBlanks) continue;
            this.removeAll(this.getAll(name));
            this.add(new RequestHeader(this.req, name, this.vs.resolve(p.getValue())));
        }
        return this;
    }

    public RequestHeaders addDefault(Header ... pairs) {
        return this.addDefault(CollectionUtils.alist((Object[])pairs));
    }

    public RequestHeaders addDefault(String name, String value) {
        return this.addDefault(new Header[]{BasicStringHeader.of((String)name, (String)value)});
    }

    public RequestHeaders add(String name, Object value) {
        ArgUtils.assertArgNotNull((String)"name", (Object)name);
        this.add(new RequestHeader(this.req, name, StringUtils.stringify((Object)value)).parser(this.parser));
        return this;
    }

    public RequestHeaders add(Header ... headers) {
        ArgUtils.assertArgNotNull((String)"headers", (Object)headers);
        for (Header h : headers) {
            if (h == null) continue;
            this.add(h.getName(), h.getValue());
        }
        return this;
    }

    public RequestHeaders set(String name, Object value) {
        ArgUtils.assertArgNotNull((String)"name", (Object)name);
        this.set(new RequestHeader(this.req, name, StringUtils.stringify((Object)value)).parser(this.parser));
        return this;
    }

    public RequestHeaders set(Header ... headers) {
        ArgUtils.assertArgNotNull((String)"headers", (Object)headers);
        for (Header h : headers) {
            this.remove(h);
        }
        for (Header h : headers) {
            this.add(h);
        }
        return this;
    }

    public RequestHeaders remove(String name) {
        ArgUtils.assertArgNotNull((String)"name", (Object)name);
        this.removeIf(x -> this.eq(x.getName(), name));
        return this;
    }

    public RequestHeaders subset(String ... names) {
        return new RequestHeaders(this, names);
    }

    public boolean contains(String name) {
        return this.stream(name).findAny().isPresent();
    }

    public boolean containsAny(String ... names) {
        ArgUtils.assertArgNotNull((String)"names", (Object)names);
        for (String n : names) {
            if (!this.stream(n).findAny().isPresent()) continue;
            return true;
        }
        return false;
    }

    public List<RequestHeader> getAll(String name) {
        return this.stream(name).collect(Collectors.toList());
    }

    public Stream<RequestHeader> stream(String name) {
        return this.stream().filter(x -> this.eq(x.getName(), name));
    }

    public Stream<RequestHeader> getSorted() {
        Comparator<RequestHeader> x = this.caseSensitive ? Comparator.comparing(RequestHttpPart::getName) : (x1, x2) -> String.CASE_INSENSITIVE_ORDER.compare(x1.getName(), x2.getName());
        return this.stream().sorted(x);
    }

    public List<String> getNames() {
        return this.stream().map(RequestHttpPart::getName).map(x -> this.caseSensitive ? x : x.toLowerCase()).distinct().collect(Collectors.toList());
    }

    public RequestHeader getFirst(String name) {
        ArgUtils.assertArgNotNull((String)"name", (Object)name);
        return this.stream(name).findFirst().orElseGet(() -> new RequestHeader(this.req, name, null).parser(this.parser));
    }

    public RequestHeader getLast(String name) {
        ArgUtils.assertArgNotNull((String)"name", (Object)name);
        Value v = Value.empty();
        this.stream(name).forEach((? super T x) -> v.set(x));
        return (RequestHeader)v.orElseGet(() -> new RequestHeader(this.req, name, null).parser(this.parser));
    }

    public RequestHeader get(String name) {
        List<RequestHeader> l = this.getAll(name);
        if (l.isEmpty()) {
            return new RequestHeader(this.req, name, null).parser(this.parser);
        }
        if (l.size() == 1) {
            return l.get(0);
        }
        StringBuilder sb = new StringBuilder(128);
        int j = l.size();
        for (int i = 0; i < j; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(l.get(i).getValue());
        }
        return new RequestHeader(this.req, name, sb.toString()).parser(this.parser);
    }

    public <T> Optional<T> get(Class<T> type) {
        ClassMeta cm = this.req.getBeanSession().getClassMeta(type);
        String name = (String)HttpParts.getName((HttpPartType)HttpPartType.HEADER, (ClassMeta)cm).orElseThrow(() -> new BasicRuntimeException("@Header(name) not found on class {0}", new Object[]{ClassUtils.className((Object)type)}));
        return this.get(name).as(type);
    }

    public RequestHeaders copy() {
        return new RequestHeaders(this);
    }

    private String key(String name) {
        return this.caseSensitive ? name : name.toLowerCase();
    }

    private boolean eq(String s1, String s2) {
        if (this.caseSensitive) {
            return StringUtils.eq((String)s1, (String)s2);
        }
        return StringUtils.eqic((String)s1, (String)s2);
    }

    @Override
    public String toString() {
        JsonMap m = new JsonMap();
        for (String n : this.getNames()) {
            m.put(n, this.get(n).asString().orElse(null));
        }
        return m.asJson();
    }
}

