/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.BackoffManager;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.InputStreamFactory;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ConfigException;
import org.apache.juneau.Context;
import org.apache.juneau.DetailLevel;
import org.apache.juneau.Enablement;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.Visibility;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.header.MediaType;
import org.apache.juneau.httppart.HttpPartCollectionFormat;
import org.apache.juneau.httppart.HttpPartFormat;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.marshall.Marshall;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.client.RestCallException;
import org.apache.juneau.rest.client.RestCallHandler;
import org.apache.juneau.rest.client.RestClient;
import org.apache.juneau.rest.client.RestOperation;
import org.apache.juneau.rest.client.RestRequest;
import org.apache.juneau.rest.client.RestRequestCreated;
import org.apache.juneau.rest.client.RestResponse;
import org.apache.juneau.rest.logging.BasicTestRestLogger;
import org.apache.juneau.rest.mock.MockHttpClientConnectionManager;
import org.apache.juneau.rest.mock.MockPathResolver;
import org.apache.juneau.rest.mock.MockRestRequest;
import org.apache.juneau.rest.mock.MockRestResponse;
import org.apache.juneau.rest.mock.MockServletRequest;
import org.apache.juneau.rest.mock.MockServletResponse;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.swap.BeanInterceptor;
import org.apache.juneau.uon.ParamFormat;
import org.apache.juneau.utils.HashKey;
import org.apache.juneau.utils.ThrowingFunction;

public class MockRestClient
extends RestClient
implements HttpClientConnection {
    private static Map<Class<?>, RestContext> REST_CONTEXTS = new ConcurrentHashMap();
    private final RestContext restContext;
    private final Object restObject;
    private final String contextPath;
    private final String servletPath;
    private final Map<String, String> pathVars;
    private final ThreadLocal<HttpRequest> rreq = new ThreadLocal();
    private final ThreadLocal<MockRestResponse> rres = new ThreadLocal();
    private final ThreadLocal<MockServletRequest> sreq = new ThreadLocal();
    private final ThreadLocal<MockServletResponse> sres = new ThreadLocal();

    public static Builder create(Object impl) {
        return new Builder().restBean(impl);
    }

    public static Builder createLax(Object impl) {
        return new Builder().restBean(impl).ignoreErrors().noTrace();
    }

    public static MockRestClient build(Object impl) {
        return MockRestClient.create(impl).build();
    }

    public static MockRestClient buildLax(Object impl) {
        return MockRestClient.create(impl).ignoreErrors().noTrace().build();
    }

    public static MockRestClient buildJson(Object impl) {
        return MockRestClient.create(impl).json().build();
    }

    public static MockRestClient buildJsonLax(Object impl) {
        return MockRestClient.create(impl).json().ignoreErrors().noTrace().build();
    }

    public static MockRestClient buildSimpleJson(Object impl) {
        return MockRestClient.create(impl).simpleJson().build();
    }

    public static MockRestClient buildSimpleJsonLax(Object impl) {
        return MockRestClient.create(impl).simpleJson().ignoreErrors().noTrace().build();
    }

    public MockRestClient(Builder builder) {
        super((RestClient.Builder)MockRestClient.preInit(builder));
        this.restContext = builder.restContext;
        this.contextPath = builder.contextPath != null ? builder.contextPath : "";
        this.servletPath = builder.servletPath != null ? builder.servletPath : "";
        this.pathVars = builder.pathVars != null ? builder.pathVars : Collections.emptyMap();
        this.restObject = this.restContext.getResource();
        HttpClientConnectionManager ccm = this.getHttpClientConnectionManager();
        if (ccm instanceof MockHttpClientConnectionManager) {
            ((MockHttpClientConnectionManager)ccm).init(this);
        }
    }

    private static Builder preInit(Builder builder) {
        try {
            Class<?> c;
            Object restBean = builder.restBean;
            String contextPath = builder.contextPath;
            String servletPath = builder.servletPath;
            String rootUrl = builder.getRootUri();
            if (rootUrl == null) {
                rootUrl = "http://localhost";
            }
            Class<?> clazz = c = restBean instanceof Class ? (Class<?>)restBean : restBean.getClass();
            if (!REST_CONTEXTS.containsKey(c)) {
                boolean isClass = restBean instanceof Class;
                Object o = isClass ? ((Class)restBean).newInstance() : restBean;
                RestContext rc = RestContext.create(o.getClass(), null, null).defaultClasses(new Class[]{BasicTestRestLogger.class}).debugDefault(Enablement.CONDITIONAL).init(() -> o).build().postInit().postInitChildFirst();
                REST_CONTEXTS.put(c, rc);
            }
            RestContext restBeanCtx = REST_CONTEXTS.get(c);
            builder.restContext(restBeanCtx);
            if (servletPath == null) {
                servletPath = RestUtils.toValidContextPath((String)restBeanCtx.getFullPath());
            }
            rootUrl = rootUrl + StringUtils.emptyIfNull((String)contextPath) + StringUtils.emptyIfNull((String)servletPath);
            builder.servletPath = servletPath;
            builder.rootUri(rootUrl);
            return builder;
        }
        catch (Exception e) {
            throw new ConfigException((Throwable)e, "Could not initialize MockRestClient", new Object[0]);
        }
    }

    public MockRestRequest request(RestOperation op) throws RestCallException {
        return (MockRestRequest)super.request(op);
    }

    public MockRestRequest get(Object url) throws RestCallException {
        return (MockRestRequest)super.get(url);
    }

    public MockRestRequest get() throws RestCallException {
        return (MockRestRequest)super.get();
    }

    public MockRestRequest put(Object url, Object body) throws RestCallException {
        return (MockRestRequest)super.put(url, body);
    }

    public MockRestRequest put(Object url, String body, ContentType contentType) throws RestCallException {
        return (MockRestRequest)super.put(url, body, contentType);
    }

    public MockRestRequest put(Object url) throws RestCallException {
        return (MockRestRequest)super.put(url);
    }

    public MockRestRequest post(Object url, Object body) throws RestCallException {
        return (MockRestRequest)super.post(url, body);
    }

    public MockRestRequest post(Object url, String body, ContentType contentType) throws RestCallException {
        return (MockRestRequest)super.post(url, body, contentType);
    }

    public MockRestRequest post(Object url) throws RestCallException {
        return (MockRestRequest)super.post(url);
    }

    public MockRestRequest delete(Object url) throws RestCallException {
        return (MockRestRequest)super.delete(url);
    }

    public MockRestRequest options(Object url) throws RestCallException {
        return (MockRestRequest)super.options(url);
    }

    public MockRestRequest head(Object url) throws RestCallException {
        return (MockRestRequest)super.head(url);
    }

    public MockRestRequest formPost(Object url, Object body) throws RestCallException {
        return (MockRestRequest)super.formPost(url, body);
    }

    public MockRestRequest formPost(Object url) throws RestCallException {
        return (MockRestRequest)super.formPost(url);
    }

    public MockRestRequest formPostPairs(Object url, Object ... parameters) throws RestCallException {
        return (MockRestRequest)super.formPostPairs(url, parameters);
    }

    public MockRestRequest patch(Object url, Object body) throws RestCallException {
        return (MockRestRequest)super.patch(url, body);
    }

    public MockRestRequest patch(Object url, String body, ContentType contentType) throws RestCallException {
        return (MockRestRequest)super.patch(url, body, contentType);
    }

    public MockRestRequest patch(Object url) throws RestCallException {
        return (MockRestRequest)super.patch(url);
    }

    public MockRestRequest callback(String callString) throws RestCallException {
        return (MockRestRequest)super.callback(callString);
    }

    public MockRestRequest request(String method, Object url, Object body) throws RestCallException {
        return (MockRestRequest)super.request(method, url, body);
    }

    public MockRestRequest request(String method, Object url) throws RestCallException {
        return (MockRestRequest)super.request(method, url);
    }

    public MockRestRequest request(String method, Object url, boolean hasBody) throws RestCallException {
        return (MockRestRequest)super.request(method, url, hasBody);
    }

    public HttpRequest getCurrentClientRequest() {
        return this.rreq.get();
    }

    public MockRestResponse getCurrentClientResponse() {
        return this.rres.get();
    }

    public MockServletRequest getCurrentServerRequest() {
        return this.sreq.get();
    }

    public MockServletResponse getCurrentServerResponse() {
        return this.sres.get();
    }

    MockRestClient currentResponse(MockRestResponse value) {
        this.rres.set(value);
        return this;
    }

    protected MockRestRequest createRequest(URI uri, String method, boolean hasBody) throws RestCallException {
        return new MockRestRequest(this, uri, method, hasBody);
    }

    protected MockRestResponse createResponse(RestRequest req, HttpResponse httpResponse, Parser parser) throws RestCallException {
        return new MockRestResponse(this, req, httpResponse, parser);
    }

    public void close() throws IOException {
        this.rreq.remove();
        this.rres.remove();
        this.sreq.remove();
        this.sres.remove();
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isStale() {
        return false;
    }

    public void setSocketTimeout(int timeout) {
    }

    public int getSocketTimeout() {
        return Integer.MAX_VALUE;
    }

    public void shutdown() throws IOException {
    }

    public HttpConnectionMetrics getMetrics() {
        return null;
    }

    public boolean isResponseAvailable(int timeout) throws IOException {
        return true;
    }

    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        try {
            RequestLine rl = request.getRequestLine();
            String path = rl.getUri();
            String target = this.findTarget(request);
            HttpRequest req = this.findRestRequest(request);
            this.rreq.set(req);
            this.rres.remove();
            this.sreq.remove();
            this.sres.remove();
            path = target + path;
            MockPathResolver pr = new MockPathResolver(target, this.contextPath, this.servletPath, path, null);
            if (pr.getError() != null) {
                throw ThrowableUtils.runtimeException((String)pr.getError(), (Object[])new Object[0]);
            }
            MockServletRequest r = MockServletRequest.create(request.getRequestLine().getMethod(), pr.getURI(), new Object[0]).contextPath(pr.getContextPath()).servletPath(pr.getServletPath()).pathVars(this.pathVars).debug(this.isDebug());
            for (Header h : request.getAllHeaders()) {
                r.header(h.getName(), h.getValue());
            }
            this.sreq.set(r);
            this.sreq.get().applyOverrides(req);
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage(), (Throwable)e);
        }
    }

    private HttpRequest findRestRequest(HttpRequest req) {
        if (req instanceof RestRequestCreated) {
            return ((RestRequestCreated)req).getRestRequest();
        }
        if (req instanceof HttpRequestWrapper) {
            return this.findRestRequest(((HttpRequestWrapper)req).getOriginal());
        }
        return req;
    }

    private String findTarget(HttpRequest req) {
        HttpHost httpHost;
        if (req instanceof HttpRequestWrapper && (httpHost = ((HttpRequestWrapper)req).getTarget()) != null) {
            return httpHost.toURI();
        }
        return "http://localhost";
    }

    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        byte[] body = new byte[]{};
        HttpEntity entity = request.getEntity();
        if (entity != null) {
            long length = entity.getContentLength();
            if (length < 0L) {
                length = 1024L;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream((int)Math.min(length, 1024L));
            entity.writeTo((OutputStream)baos);
            baos.flush();
            body = baos.toByteArray();
        }
        this.sreq.get().content(body);
    }

    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        try {
            MockServletResponse res = MockServletResponse.create();
            this.restContext.execute(this.restObject, (HttpServletRequest)this.sreq.get(), (HttpServletResponse)res);
            if (res.getStatus() == 0) {
                throw ThrowableUtils.runtimeException((String)"Response status was 0.", (Object[])new Object[0]);
            }
            if (res.getStatus() < 200) {
                res.setStatus(1000 + res.getStatus());
            }
            this.sres.set(res);
            BasicHttpResponse response = new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, res.getStatus(), res.getMessage()));
            res.getHeaders().forEach((arg_0, arg_1) -> MockRestClient.lambda$receiveResponseHeader$1((HttpResponse)response, arg_0, arg_1));
            return response;
        }
        catch (Exception e) {
            throw new HttpException(StringUtils.emptyIfNull((String)e.getMessage()), (Throwable)e);
        }
    }

    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        InputStream is = new ByteArrayInputStream(this.sres.get().getContent());
        Header contentEncoding = response.getLastHeader("Content-Encoding");
        if (contentEncoding != null && contentEncoding.getValue().equalsIgnoreCase("gzip")) {
            is = new GZIPInputStream(is);
        }
        response.setEntity((HttpEntity)new InputStreamEntity(is));
    }

    public void flush() throws IOException {
    }

    private static /* synthetic */ void lambda$receiveResponseHeader$1(HttpResponse response, String k, String[] v) {
        for (String hv : v) {
            response.addHeader(k, hv);
        }
    }

    @FluentSetters(ignore={"debug"})
    public static class Builder
    extends RestClient.Builder {
        Object restBean;
        String contextPath;
        String servletPath;
        RestContext restContext;
        Map<String, String> pathVars;

        protected Builder() {
            this.connectionManager(new MockHttpClientConnectionManager());
        }

        public Builder copy() {
            throw new NoSuchMethodError("Not implemented.");
        }

        public Builder restBean(Object value) {
            this.restBean = value;
            return this;
        }

        public Builder restContext(RestContext value) {
            this.restContext = value;
            return this;
        }

        public Builder contextPath(String value) {
            this.contextPath = RestUtils.toValidContextPath((String)value);
            return this;
        }

        public Builder servletPath(String value) {
            this.servletPath = RestUtils.toValidContextPath((String)value);
            return this;
        }

        public Builder pathVars(Map<String, String> value) {
            this.pathVars = value;
            return this;
        }

        public Builder pathVars(String ... pairs) {
            return this.pathVars(CollectionUtils.mapBuilder(String.class, String.class, (Type[])new Type[0]).addPairs((Object[])pairs).build());
        }

        public Builder suppressLogging() {
            return this.logRequests(DetailLevel.NONE, (Level)null, (BiPredicate)null);
        }

        public Builder debug() {
            this.header("Debug", "true");
            super.debug();
            return this;
        }

        public MockRestClient build() {
            return (MockRestClient)this.build(MockRestClient.class);
        }

        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        public Builder applyAnnotations(Class<?> ... fromClasses) {
            super.applyAnnotations((Class[])fromClasses);
            return this;
        }

        public Builder applyAnnotations(Method ... fromMethods) {
            super.applyAnnotations(fromMethods);
            return this;
        }

        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache(value);
            return this;
        }

        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<? extends Context> value) {
            super.type(value);
            return this;
        }

        public Builder beanClassVisibility(Visibility value) {
            super.beanClassVisibility(value);
            return this;
        }

        public Builder beanConstructorVisibility(Visibility value) {
            super.beanConstructorVisibility(value);
            return this;
        }

        public Builder beanContext(BeanContext value) {
            super.beanContext(value);
            return this;
        }

        public Builder beanContext(BeanContext.Builder value) {
            super.beanContext(value);
            return this;
        }

        public Builder beanDictionary(Class<?> ... values) {
            super.beanDictionary((Class[])values);
            return this;
        }

        public Builder beanFieldVisibility(Visibility value) {
            super.beanFieldVisibility(value);
            return this;
        }

        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            super.beanInterceptor(on, value);
            return this;
        }

        public Builder beanMapPutReturnsOldValue() {
            super.beanMapPutReturnsOldValue();
            return this;
        }

        public Builder beanMethodVisibility(Visibility value) {
            super.beanMethodVisibility(value);
            return this;
        }

        public Builder beanProperties(Map<String, Object> values) {
            super.beanProperties(values);
            return this;
        }

        public Builder beanProperties(Class<?> beanClass, String properties) {
            super.beanProperties(beanClass, properties);
            return this;
        }

        public Builder beanProperties(String beanClassName, String properties) {
            super.beanProperties(beanClassName, properties);
            return this;
        }

        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            super.beanPropertiesExcludes(values);
            return this;
        }

        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            super.beanPropertiesExcludes(beanClass, properties);
            return this;
        }

        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            super.beanPropertiesExcludes(beanClassName, properties);
            return this;
        }

        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            super.beanPropertiesReadOnly(values);
            return this;
        }

        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesReadOnly(beanClass, properties);
            return this;
        }

        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            super.beanPropertiesReadOnly(beanClassName, properties);
            return this;
        }

        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            super.beanPropertiesWriteOnly(values);
            return this;
        }

        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesWriteOnly(beanClass, properties);
            return this;
        }

        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            super.beanPropertiesWriteOnly(beanClassName, properties);
            return this;
        }

        public Builder beansRequireDefaultConstructor() {
            super.beansRequireDefaultConstructor();
            return this;
        }

        public Builder beansRequireSerializable() {
            super.beansRequireSerializable();
            return this;
        }

        public Builder beansRequireSettersForGetters() {
            super.beansRequireSettersForGetters();
            return this;
        }

        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            super.dictionaryOn(on, (Class[])values);
            return this;
        }

        public Builder disableBeansRequireSomeProperties() {
            super.disableBeansRequireSomeProperties();
            return this;
        }

        public Builder disableIgnoreMissingSetters() {
            super.disableIgnoreMissingSetters();
            return this;
        }

        public Builder disableIgnoreTransientFields() {
            super.disableIgnoreTransientFields();
            return this;
        }

        public Builder disableIgnoreUnknownNullBeanProperties() {
            super.disableIgnoreUnknownNullBeanProperties();
            return this;
        }

        public Builder disableInterfaceProxies() {
            super.disableInterfaceProxies();
            return this;
        }

        public <T> Builder example(Class<T> pojoClass, T o) {
            super.example(pojoClass, o);
            return this;
        }

        public <T> Builder example(Class<T> pojoClass, String json) {
            super.example(pojoClass, json);
            return this;
        }

        public Builder findFluentSetters() {
            super.findFluentSetters();
            return this;
        }

        public Builder findFluentSetters(Class<?> on) {
            super.findFluentSetters(on);
            return this;
        }

        public Builder ignoreInvocationExceptionsOnGetters() {
            super.ignoreInvocationExceptionsOnGetters();
            return this;
        }

        public Builder ignoreInvocationExceptionsOnSetters() {
            super.ignoreInvocationExceptionsOnSetters();
            return this;
        }

        public Builder ignoreUnknownBeanProperties() {
            super.ignoreUnknownBeanProperties();
            return this;
        }

        public Builder ignoreUnknownEnumValues() {
            super.ignoreUnknownEnumValues();
            return this;
        }

        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            super.implClass(interfaceClass, implClass);
            return this;
        }

        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            super.implClasses(values);
            return this;
        }

        public Builder interfaceClass(Class<?> on, Class<?> value) {
            super.interfaceClass(on, value);
            return this;
        }

        public Builder interfaces(Class<?> ... value) {
            super.interfaces((Class[])value);
            return this;
        }

        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        public Builder notBeanClasses(Class<?> ... values) {
            super.notBeanClasses((Class[])values);
            return this;
        }

        public Builder notBeanPackages(String ... values) {
            super.notBeanPackages(values);
            return this;
        }

        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            super.propertyNamer(value);
            return this;
        }

        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            super.propertyNamer(on, value);
            return this;
        }

        public Builder sortProperties() {
            super.sortProperties();
            return this;
        }

        public Builder sortProperties(Class<?> ... on) {
            super.sortProperties((Class[])on);
            return this;
        }

        public Builder stopClass(Class<?> on, Class<?> value) {
            super.stopClass(on, value);
            return this;
        }

        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            super.swap(normalClass, swappedClass, swapFunction);
            return this;
        }

        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            super.swap(normalClass, swappedClass, swapFunction, unswapFunction);
            return this;
        }

        public Builder swaps(Class<?> ... values) {
            super.swaps((Class[])values);
            return this;
        }

        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        public Builder typeName(Class<?> on, String value) {
            super.typeName(on, value);
            return this;
        }

        public Builder typePropertyName(String value) {
            super.typePropertyName(value);
            return this;
        }

        public Builder typePropertyName(Class<?> on, String value) {
            super.typePropertyName(on, value);
            return this;
        }

        public Builder useEnumNames() {
            super.useEnumNames();
            return this;
        }

        public Builder useJavaBeanIntrospector() {
            super.useJavaBeanIntrospector();
            return this;
        }

        public Builder accept(String value) {
            super.accept(value);
            return this;
        }

        public Builder acceptCharset(String value) {
            super.acceptCharset(value);
            return this;
        }

        public Builder addBeanTypes() {
            super.addBeanTypes();
            return this;
        }

        public Builder addInterceptorFirst(HttpRequestInterceptor itcp) {
            super.addInterceptorFirst(itcp);
            return this;
        }

        public Builder addInterceptorFirst(HttpResponseInterceptor itcp) {
            super.addInterceptorFirst(itcp);
            return this;
        }

        public Builder addInterceptorLast(HttpRequestInterceptor itcp) {
            super.addInterceptorLast(itcp);
            return this;
        }

        public Builder addInterceptorLast(HttpResponseInterceptor itcp) {
            super.addInterceptorLast(itcp);
            return this;
        }

        public Builder addRootType() {
            super.addRootType();
            return this;
        }

        public Builder backoffManager(BackoffManager backoffManager) {
            super.backoffManager(backoffManager);
            return this;
        }

        public Builder basicAuth(String host, int port, String user, String pw) {
            super.basicAuth(host, port, user, pw);
            return this;
        }

        public Builder callHandler(Class<? extends RestCallHandler> value) {
            super.callHandler(value);
            return this;
        }

        public Builder clientVersion(String value) {
            super.clientVersion(value);
            return this;
        }

        public Builder connectionBackoffStrategy(ConnectionBackoffStrategy connectionBackoffStrategy) {
            super.connectionBackoffStrategy(connectionBackoffStrategy);
            return this;
        }

        public Builder connectionManager(HttpClientConnectionManager value) {
            super.connectionManager(value);
            return this;
        }

        public Builder connectionManagerShared(boolean shared) {
            super.connectionManagerShared(shared);
            return this;
        }

        public Builder connectionReuseStrategy(ConnectionReuseStrategy reuseStrategy) {
            super.connectionReuseStrategy(reuseStrategy);
            return this;
        }

        public Builder connectionTimeToLive(long connTimeToLive, TimeUnit connTimeToLiveTimeUnit) {
            super.connectionTimeToLive(connTimeToLive, connTimeToLiveTimeUnit);
            return this;
        }

        public Builder console(PrintStream value) {
            super.console(value);
            return this;
        }

        public Builder contentDecoderRegistry(Map<String, InputStreamFactory> contentDecoderMap) {
            super.contentDecoderRegistry(contentDecoderMap);
            return this;
        }

        public Builder contentType(String value) {
            super.contentType(value);
            return this;
        }

        public Builder debugOutputLines(int value) {
            super.debugOutputLines(value);
            return this;
        }

        public Builder defaultAuthSchemeRegistry(Lookup<AuthSchemeProvider> authSchemeRegistry) {
            super.defaultAuthSchemeRegistry(authSchemeRegistry);
            return this;
        }

        public Builder defaultConnectionConfig(ConnectionConfig config) {
            super.defaultConnectionConfig(config);
            return this;
        }

        public Builder defaultCookieSpecRegistry(Lookup<CookieSpecProvider> cookieSpecRegistry) {
            super.defaultCookieSpecRegistry(cookieSpecRegistry);
            return this;
        }

        public Builder defaultCookieStore(CookieStore cookieStore) {
            super.defaultCookieStore(cookieStore);
            return this;
        }

        public Builder defaultCredentialsProvider(CredentialsProvider credentialsProvider) {
            super.defaultCredentialsProvider(credentialsProvider);
            return this;
        }

        public Builder defaultRequestConfig(RequestConfig config) {
            super.defaultRequestConfig(config);
            return this;
        }

        public Builder defaultSocketConfig(SocketConfig config) {
            super.defaultSocketConfig(config);
            return this;
        }

        public Builder detectLeaks() {
            super.detectLeaks();
            return this;
        }

        public Builder detectRecursions() {
            super.detectRecursions();
            return this;
        }

        public Builder disableAuthCaching() {
            super.disableAuthCaching();
            return this;
        }

        public Builder disableAutomaticRetries() {
            super.disableAutomaticRetries();
            return this;
        }

        public Builder disableConnectionState() {
            super.disableConnectionState();
            return this;
        }

        public Builder disableContentCompression() {
            super.disableContentCompression();
            return this;
        }

        public Builder disableCookieManagement() {
            super.disableCookieManagement();
            return this;
        }

        public Builder disableRedirectHandling() {
            super.disableRedirectHandling();
            return this;
        }

        public Builder errorCodes(Predicate<Integer> value) {
            super.errorCodes(value);
            return this;
        }

        public Builder evictExpiredConnections() {
            super.evictExpiredConnections();
            return this;
        }

        public Builder evictIdleConnections(long maxIdleTime, TimeUnit maxIdleTimeUnit) {
            super.evictIdleConnections(maxIdleTime, maxIdleTimeUnit);
            return this;
        }

        public Builder executorService(ExecutorService executorService, boolean shutdownOnClose) {
            super.executorService(executorService, shutdownOnClose);
            return this;
        }

        public Builder formData(NameValuePair ... parts) {
            super.formData(parts);
            return this;
        }

        public Builder formData(String name, String value) {
            super.formData(name, value);
            return this;
        }

        public Builder formData(String name, Supplier<String> value) {
            super.formData(name, value);
            return this;
        }

        public Builder header(String name, String value) {
            super.header(name, value);
            return this;
        }

        public Builder header(String name, Supplier<String> value) {
            super.header(name, value);
            return this;
        }

        public Builder headers(Header ... parts) {
            super.headers(parts);
            return this;
        }

        public Builder html() {
            super.html();
            return this;
        }

        public Builder htmlDoc() {
            super.htmlDoc();
            return this;
        }

        public Builder htmlStrippedDoc() {
            super.htmlStrippedDoc();
            return this;
        }

        public Builder httpClient(CloseableHttpClient value) {
            super.httpClient(value);
            return this;
        }

        public Builder httpClientBuilder(HttpClientBuilder value) {
            super.httpClientBuilder(value);
            return this;
        }

        public Builder httpProcessor(HttpProcessor httpprocessor) {
            super.httpProcessor(httpprocessor);
            return this;
        }

        public Builder ignoreErrors() {
            super.ignoreErrors();
            return this;
        }

        public Builder ignoreRecursions() {
            super.ignoreRecursions();
            return this;
        }

        public Builder initialDepth(int value) {
            super.initialDepth(value);
            return this;
        }

        public Builder interceptors(Class<?> ... values) throws Exception {
            super.interceptors((Class[])values);
            return this;
        }

        public Builder interceptors(Object ... value) {
            super.interceptors(value);
            return this;
        }

        public Builder json() {
            super.json();
            return this;
        }

        public Builder keepAliveStrategy(ConnectionKeepAliveStrategy keepAliveStrategy) {
            super.keepAliveStrategy(keepAliveStrategy);
            return this;
        }

        public Builder keepHttpClientOpen() {
            super.keepHttpClientOpen();
            return this;
        }

        public Builder keepNullProperties() {
            super.keepNullProperties();
            return this;
        }

        public Builder logRequests(DetailLevel detail, Level level, BiPredicate<RestRequest, RestResponse> test) {
            super.logRequests(detail, level, test);
            return this;
        }

        public Builder logToConsole() {
            super.logToConsole();
            return this;
        }

        public Builder logger(Logger value) {
            super.logger(value);
            return this;
        }

        public Builder marshall(Marshall value) {
            super.marshall(value);
            return this;
        }

        public Builder marshalls(Marshall ... value) {
            super.marshalls(value);
            return this;
        }

        public Builder maxConnPerRoute(int maxConnPerRoute) {
            super.maxConnPerRoute(maxConnPerRoute);
            return this;
        }

        public Builder maxConnTotal(int maxConnTotal) {
            super.maxConnTotal(maxConnTotal);
            return this;
        }

        public Builder maxDepth(int value) {
            super.maxDepth(value);
            return this;
        }

        public Builder maxIndent(int value) {
            super.maxIndent(value);
            return this;
        }

        public Builder mediaType(String value) {
            super.mediaType(value);
            return this;
        }

        public Builder msgPack() {
            super.msgPack();
            return this;
        }

        public Builder noTrace() {
            super.noTrace();
            return this;
        }

        public Builder oapiCollectionFormat(HttpPartCollectionFormat value) {
            super.oapiCollectionFormat(value);
            return this;
        }

        public Builder oapiFormat(HttpPartFormat value) {
            super.oapiFormat(value);
            return this;
        }

        public Builder openApi() {
            super.openApi();
            return this;
        }

        public Builder paramFormat(ParamFormat value) {
            super.paramFormat(value);
            return this;
        }

        public Builder paramFormatPlain() {
            super.paramFormatPlain();
            return this;
        }

        public Builder parser(Class<? extends Parser> value) {
            super.parser(value);
            return this;
        }

        public Builder parser(Parser value) {
            super.parser(value);
            return this;
        }

        public Builder parsers(Class<? extends Parser> ... value) {
            super.parsers((Class[])value);
            return this;
        }

        public Builder parsers(Parser ... value) {
            super.parsers(value);
            return this;
        }

        public Builder partParser(Class<? extends HttpPartParser> value) {
            super.partParser(value);
            return this;
        }

        public Builder partParser(HttpPartParser value) {
            super.partParser(value);
            return this;
        }

        public Builder partSerializer(Class<? extends HttpPartSerializer> value) {
            super.partSerializer(value);
            return this;
        }

        public Builder partSerializer(HttpPartSerializer value) {
            super.partSerializer(value);
            return this;
        }

        public Builder pathData(NameValuePair ... parts) {
            super.pathData(parts);
            return this;
        }

        public Builder pathData(String name, String value) {
            super.pathData(name, value);
            return this;
        }

        public Builder pathData(String name, Supplier<String> value) {
            super.pathData(name, value);
            return this;
        }

        public Builder plainText() {
            super.plainText();
            return this;
        }

        public Builder pooled() {
            super.pooled();
            return this;
        }

        public Builder proxy(HttpHost proxy) {
            super.proxy(proxy);
            return this;
        }

        public Builder proxyAuthenticationStrategy(AuthenticationStrategy proxyAuthStrategy) {
            super.proxyAuthenticationStrategy(proxyAuthStrategy);
            return this;
        }

        public Builder publicSuffixMatcher(PublicSuffixMatcher publicSuffixMatcher) {
            super.publicSuffixMatcher(publicSuffixMatcher);
            return this;
        }

        public Builder queryData(NameValuePair ... parts) {
            super.queryData(parts);
            return this;
        }

        public Builder queryData(String name, String value) {
            super.queryData(name, value);
            return this;
        }

        public Builder queryData(String name, Supplier<String> value) {
            super.queryData(name, value);
            return this;
        }

        public Builder quoteChar(char value) {
            super.quoteChar(value);
            return this;
        }

        public Builder redirectStrategy(RedirectStrategy redirectStrategy) {
            super.redirectStrategy(redirectStrategy);
            return this;
        }

        public Builder requestExecutor(HttpRequestExecutor requestExec) {
            super.requestExecutor(requestExec);
            return this;
        }

        public Builder retryHandler(HttpRequestRetryHandler retryHandler) {
            super.retryHandler(retryHandler);
            return this;
        }

        public Builder rootUri(Object value) {
            super.rootUri(value);
            return this;
        }

        public Builder routePlanner(HttpRoutePlanner routePlanner) {
            super.routePlanner(routePlanner);
            return this;
        }

        public Builder schemePortResolver(SchemePortResolver schemePortResolver) {
            super.schemePortResolver(schemePortResolver);
            return this;
        }

        public Builder serializer(Class<? extends Serializer> value) {
            super.serializer(value);
            return this;
        }

        public Builder serializer(Serializer value) {
            super.serializer(value);
            return this;
        }

        public Builder serializers(Class<? extends Serializer> ... value) {
            super.serializers((Class[])value);
            return this;
        }

        public Builder serializers(Serializer ... value) {
            super.serializers(value);
            return this;
        }

        public Builder serviceUnavailableRetryStrategy(ServiceUnavailableRetryStrategy serviceUnavailStrategy) {
            super.serviceUnavailableRetryStrategy(serviceUnavailStrategy);
            return this;
        }

        public Builder simpleJson() {
            super.simpleJson();
            return this;
        }

        public Builder skipEmptyFormData() {
            super.skipEmptyFormData();
            return this;
        }

        public Builder skipEmptyFormData(boolean value) {
            super.skipEmptyFormData(value);
            return this;
        }

        public Builder skipEmptyHeaderData() {
            super.skipEmptyHeaderData();
            return this;
        }

        public Builder skipEmptyHeaderData(boolean value) {
            super.skipEmptyHeaderData(value);
            return this;
        }

        public Builder skipEmptyQueryData() {
            super.skipEmptyQueryData();
            return this;
        }

        public Builder skipEmptyQueryData(boolean value) {
            super.skipEmptyQueryData(value);
            return this;
        }

        public Builder sortCollections() {
            super.sortCollections();
            return this;
        }

        public Builder sortMaps() {
            super.sortMaps();
            return this;
        }

        public Builder sq() {
            super.sq();
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            super.sslContext(sslContext);
            return this;
        }

        public Builder sslHostnameVerifier(HostnameVerifier hostnameVerifier) {
            super.sslHostnameVerifier(hostnameVerifier);
            return this;
        }

        public Builder sslSocketFactory(LayeredConnectionSocketFactory sslSocketFactory) {
            super.sslSocketFactory(sslSocketFactory);
            return this;
        }

        public Builder strict() {
            super.strict();
            return this;
        }

        public Builder targetAuthenticationStrategy(AuthenticationStrategy targetAuthStrategy) {
            super.targetAuthenticationStrategy(targetAuthStrategy);
            return this;
        }

        public Builder trimEmptyCollections() {
            super.trimEmptyCollections();
            return this;
        }

        public Builder trimEmptyMaps() {
            super.trimEmptyMaps();
            return this;
        }

        public Builder trimStringsOnRead() {
            super.trimStringsOnRead();
            return this;
        }

        public Builder trimStringsOnWrite() {
            super.trimStringsOnWrite();
            return this;
        }

        public Builder uon() {
            super.uon();
            return this;
        }

        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }

        public Builder uriRelativity(UriRelativity value) {
            super.uriRelativity(value);
            return this;
        }

        public Builder uriResolution(UriResolution value) {
            super.uriResolution(value);
            return this;
        }

        public Builder urlEnc() {
            super.urlEnc();
            return this;
        }

        public Builder useSystemProperties() {
            super.useSystemProperties();
            return this;
        }

        public Builder useWhitespace() {
            super.useWhitespace();
            return this;
        }

        public Builder userTokenHandler(UserTokenHandler userTokenHandler) {
            super.userTokenHandler(userTokenHandler);
            return this;
        }

        public Builder ws() {
            super.ws();
            return this;
        }

        public Builder xml() {
            super.xml();
            return this;
        }
    }
}

