/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.logging;

import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.apache.juneau.Enablement;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.logging.BasicRestLogger;
import org.apache.juneau.rest.logging.RestLogger;
import org.apache.juneau.rest.logging.RestLoggerRule;
import org.apache.juneau.rest.logging.RestLoggingDetail;

public class BasicTestRestLogger
extends BasicRestLogger {
    public BasicTestRestLogger(RestContext context) {
        super(BasicTestRestLogger.builder().logger(context.getLogger()).thrownStore(context.getThrownStore()));
    }

    private static RestLogger.Builder builder() {
        BeanStore bs = BeanStore.INSTANCE;
        return RestLogger.create(bs).normalRules((RestLoggerRule)RestLoggerRule.create(bs).statusFilter(x -> x >= 400).level(Level.SEVERE).requestDetail(RestLoggingDetail.HEADER).responseDetail(RestLoggingDetail.HEADER).enabled(Enablement.CONDITIONAL).enabledPredicate(x -> !BasicTestRestLogger.isNoTrace(x)).logStackTrace().build(), (RestLoggerRule)RestLoggerRule.create(bs).statusFilter(x -> x >= 400).level(Level.WARNING).requestDetail(RestLoggingDetail.STATUS_LINE).responseDetail(RestLoggingDetail.STATUS_LINE).enabled(Enablement.CONDITIONAL).enabledPredicate(x -> !BasicTestRestLogger.isNoTrace(x)).logStackTrace().build()).debugRules((RestLoggerRule)RestLoggerRule.create(bs).level(Level.SEVERE).requestDetail(RestLoggingDetail.ENTITY).responseDetail(RestLoggingDetail.ENTITY).logStackTrace().build());
    }

    private static boolean isNoTrace(HttpServletRequest req) {
        Object o = req.getAttribute("NoTrace");
        if (o != null) {
            return "true".equalsIgnoreCase(o.toString());
        }
        String s = req.getHeader("No-Trace");
        if (s != null) {
            return "true".equalsIgnoreCase(s);
        }
        return StringUtils.emptyIfNull((String)req.getQueryString()).contains("noTrace=true");
    }
}

