/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.Context;
import org.apache.juneau.Enablement;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.Value;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.config.Config;
import org.apache.juneau.config.vars.ConfigVar;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.DefaultClassList;
import org.apache.juneau.cp.DefaultSettingsMap;
import org.apache.juneau.cp.FileFinder;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.cp.MethodList;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderSet;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.html.HtmlWidgetVar;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.StatusCode;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.header.MediaType;
import org.apache.juneau.http.header.Thrown;
import org.apache.juneau.http.response.BadRequest;
import org.apache.juneau.http.response.BasicHttpException;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.http.response.MethodNotAllowed;
import org.apache.juneau.http.response.NotFound;
import org.apache.juneau.http.response.NotImplemented;
import org.apache.juneau.http.response.PreconditionFailed;
import org.apache.juneau.http.response.Unauthorized;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.ParserSet;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.ExecutableInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.HttpRuntimeException;
import org.apache.juneau.rest.OverrideableHttpServletRequest;
import org.apache.juneau.rest.RestChild;
import org.apache.juneau.rest.RestChildMatch;
import org.apache.juneau.rest.RestChildren;
import org.apache.juneau.rest.RestOpContext;
import org.apache.juneau.rest.RestOpInvoker;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestOperations;
import org.apache.juneau.rest.RestSession;
import org.apache.juneau.rest.annotation.HookEvent;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestHook;
import org.apache.juneau.rest.annotation.RestOpAnnotation;
import org.apache.juneau.rest.arg.AttributeArg;
import org.apache.juneau.rest.arg.ContentArg;
import org.apache.juneau.rest.arg.DefaultArg;
import org.apache.juneau.rest.arg.FormDataArg;
import org.apache.juneau.rest.arg.HasFormDataArg;
import org.apache.juneau.rest.arg.HasQueryArg;
import org.apache.juneau.rest.arg.HeaderArg;
import org.apache.juneau.rest.arg.HttpServletRequestArgs;
import org.apache.juneau.rest.arg.HttpServletResponseArgs;
import org.apache.juneau.rest.arg.HttpSessionArgs;
import org.apache.juneau.rest.arg.InputStreamParserArg;
import org.apache.juneau.rest.arg.MethodArg;
import org.apache.juneau.rest.arg.ParserArg;
import org.apache.juneau.rest.arg.PathArg;
import org.apache.juneau.rest.arg.QueryArg;
import org.apache.juneau.rest.arg.ReaderParserArg;
import org.apache.juneau.rest.arg.RequestBeanArg;
import org.apache.juneau.rest.arg.ResponseBeanArg;
import org.apache.juneau.rest.arg.ResponseCodeArg;
import org.apache.juneau.rest.arg.ResponseHeaderArg;
import org.apache.juneau.rest.arg.RestContextArgs;
import org.apache.juneau.rest.arg.RestOpArg;
import org.apache.juneau.rest.arg.RestOpArgList;
import org.apache.juneau.rest.arg.RestOpContextArgs;
import org.apache.juneau.rest.arg.RestOpSessionArgs;
import org.apache.juneau.rest.arg.RestRequestArgs;
import org.apache.juneau.rest.arg.RestResponseArgs;
import org.apache.juneau.rest.arg.RestSessionArgs;
import org.apache.juneau.rest.debug.DebugEnablement;
import org.apache.juneau.rest.httppart.NamedAttribute;
import org.apache.juneau.rest.httppart.NamedAttributeList;
import org.apache.juneau.rest.logging.RestLogger;
import org.apache.juneau.rest.logging.RestLoggerRule;
import org.apache.juneau.rest.logging.RestLoggingDetail;
import org.apache.juneau.rest.processor.HttpEntityProcessor;
import org.apache.juneau.rest.processor.HttpResourceProcessor;
import org.apache.juneau.rest.processor.HttpResponseProcessor;
import org.apache.juneau.rest.processor.InputStreamProcessor;
import org.apache.juneau.rest.processor.PlainTextPojoProcessor;
import org.apache.juneau.rest.processor.ReaderProcessor;
import org.apache.juneau.rest.processor.ResponseBeanProcessor;
import org.apache.juneau.rest.processor.ResponseProcessor;
import org.apache.juneau.rest.processor.ResponseProcessorList;
import org.apache.juneau.rest.processor.SerializedPojoProcessor;
import org.apache.juneau.rest.processor.ThrowableProcessor;
import org.apache.juneau.rest.rrpc.RrpcRestOpContext;
import org.apache.juneau.rest.staticfile.BasicStaticFiles;
import org.apache.juneau.rest.staticfile.StaticFiles;
import org.apache.juneau.rest.stats.MethodExecStats;
import org.apache.juneau.rest.stats.MethodExecStore;
import org.apache.juneau.rest.stats.MethodInvoker;
import org.apache.juneau.rest.stats.RestContextStats;
import org.apache.juneau.rest.stats.ThrownStore;
import org.apache.juneau.rest.swagger.SwaggerProvider;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.util.UrlPath;
import org.apache.juneau.rest.util.UrlPathMatch;
import org.apache.juneau.rest.util.UrlPathMatcher;
import org.apache.juneau.rest.vars.FileVar;
import org.apache.juneau.rest.vars.LocalizationVar;
import org.apache.juneau.rest.vars.RequestAttributeVar;
import org.apache.juneau.rest.vars.RequestFormDataVar;
import org.apache.juneau.rest.vars.RequestHeaderVar;
import org.apache.juneau.rest.vars.RequestPathVar;
import org.apache.juneau.rest.vars.RequestQueryVar;
import org.apache.juneau.rest.vars.RequestSwaggerVar;
import org.apache.juneau.rest.vars.RequestVar;
import org.apache.juneau.rest.vars.SerializedRequestAttrVar;
import org.apache.juneau.rest.vars.ServletInitParamVar;
import org.apache.juneau.rest.vars.SwaggerVar;
import org.apache.juneau.rest.vars.UrlEncodeVar;
import org.apache.juneau.rest.vars.UrlVar;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.serializer.SerializerSet;
import org.apache.juneau.svl.VarList;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.utils.HashKey;

public class RestContext
extends Context {
    private static final Map<Class<?>, RestContext> REGISTRY = new ConcurrentHashMap();
    private final Supplier<?> resource;
    private final Class<?> resourceClass;
    final Builder builder;
    private final boolean allowContentParam;
    private final boolean renderResponseStackTraces;
    private final String clientVersionHeader;
    private final String uriAuthority;
    private final String uriContext;
    private final String path;
    private final String fullPath;
    private final UrlPathMatcher pathMatcher;
    private final Set<String> allowedMethodParams;
    private final Set<String> allowedHeaderParams;
    private final Set<String> allowedMethodHeaders;
    private final Class<? extends RestOpArg>[] restOpArgs;
    private final BeanContext beanContext;
    private final EncoderSet encoders;
    private final SerializerSet serializers;
    private final ParserSet parsers;
    private final HttpPartSerializer partSerializer;
    private final HttpPartParser partParser;
    private final JsonSchemaGenerator jsonSchemaGenerator;
    private final List<MediaType> consumes;
    private final List<MediaType> produces;
    private final HeaderList defaultRequestHeaders;
    private final HeaderList defaultResponseHeaders;
    private final NamedAttributeList defaultRequestAttributes;
    private final ResponseProcessor[] responseProcessors;
    private final Messages messages;
    private final Config config;
    private final VarResolver varResolver;
    private final RestOperations restOperations;
    private final RestChildren restChildren;
    private final Logger logger;
    private final SwaggerProvider swaggerProvider;
    private final BasicHttpException initException;
    private final RestContext parentContext;
    private final BeanStore beanStore;
    private final UriResolution uriResolution;
    private final UriRelativity uriRelativity;
    private final MethodExecStore methodExecStore;
    private final ThrownStore thrownStore;
    private final ConcurrentHashMap<Locale, Swagger> swaggerCache = new ConcurrentHashMap();
    private final Instant startTime;
    private final Map<Class<?>, ResponseBeanMeta> responseBeanMetas = new ConcurrentHashMap();
    final Charset defaultCharset;
    final long maxInput;
    final DefaultClassList defaultClasses;
    final DefaultSettingsMap defaultSettings;
    final BeanStore rootBeanStore;
    private final MethodInvoker[] postInitMethods;
    private final MethodInvoker[] postInitChildFirstMethods;
    private final MethodInvoker[] startCallMethods;
    private final MethodInvoker[] endCallMethods;
    private final MethodInvoker[] destroyMethods;
    private final MethodList preCallMethods;
    private final MethodList postCallMethods;
    private final FileFinder fileFinder;
    private final StaticFiles staticFiles;
    private final RestLogger callLogger;
    private final DebugEnablement debugEnablement;
    private final ThreadLocal<RestSession> localSession = new ThreadLocal();
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public static final Map<Class<?>, RestContext> getGlobalRegistry() {
        return CollectionUtils.unmodifiable(REGISTRY);
    }

    public static Builder create(Class<?> resourceClass, RestContext parentContext, ServletConfig servletConfig) throws ServletException {
        Value v = Value.of(Builder.class);
        ClassInfo.of(resourceClass).forEachAnnotation(Rest.class, x -> ClassUtils.isNotVoid(x.builder()), x -> v.set(x.builder()));
        if (v.get() == Builder.class) {
            return new Builder(resourceClass, parentContext, servletConfig);
        }
        return (Builder)((Object)BeanStore.of((BeanStore)(parentContext == null ? null : parentContext.getRootBeanStore())).addBean(Class.class, resourceClass).addBean(RestContext.class, (Object)parentContext).addBean(ServletConfig.class, (Object)servletConfig).createBean(Builder.class).type((Class)v.get()).run());
    }

    public RestContext(Builder builder) throws Exception {
        super((Context.Builder)builder);
        this.startTime = Instant.now();
        REGISTRY.put(builder.resourceClass, this);
        BasicHttpException _initException = null;
        try {
            this.builder = builder;
            this.resourceClass = builder.resourceClass;
            this.resource = builder.resource;
            this.parentContext = builder.parentContext;
            this.rootBeanStore = builder.rootBeanStore();
            this.defaultClasses = builder.defaultClasses();
            this.defaultSettings = builder.defaultSettings();
            BeanStore bs = this.beanStore = builder.beanStore();
            this.beanStore.addBean(BeanStore.class, (Object)this.beanStore).addBean(RestContext.class, (Object)this).addBean(Object.class, this.resource.get()).addBean(Builder.class, (Object)builder).addBean(AnnotationWorkList.class, (Object)builder.getApplied());
            this.path = builder.path != null ? builder.path : "";
            this.fullPath = (this.parentContext == null ? "" : this.parentContext.fullPath + '/') + this.path;
            String p = this.path;
            if (!p.endsWith("/*")) {
                p = p + "/*";
            }
            this.pathMatcher = UrlPathMatcher.of(p);
            this.allowContentParam = !builder.disableContentParam;
            this.allowedHeaderParams = this.newCaseInsensitiveSet(Optional.ofNullable(builder.allowedHeaderParams).map(x -> "NONE".equals(x) ? "" : x).orElse(""));
            this.allowedMethodParams = this.newCaseInsensitiveSet(Optional.ofNullable(builder.allowedMethodParams).map(x -> "NONE".equals(x) ? "" : x).orElse(""));
            this.allowedMethodHeaders = this.newCaseInsensitiveSet(Optional.ofNullable(builder.allowedMethodHeaders).map(x -> "NONE".equals(x) ? "" : x).orElse(""));
            this.clientVersionHeader = builder.clientVersionHeader;
            this.defaultCharset = builder.defaultCharset;
            this.maxInput = builder.maxInput;
            this.renderResponseStackTraces = builder.renderResponseStackTraces;
            this.uriContext = builder.uriContext;
            this.uriAuthority = builder.uriAuthority;
            this.uriResolution = builder.uriResolution;
            this.uriRelativity = builder.uriRelativity;
            this.beanContext = (BeanContext)bs.add(BeanContext.class, (Object)builder.beanContext().build());
            this.encoders = (EncoderSet)bs.add(EncoderSet.class, builder.encoders().build());
            this.serializers = (SerializerSet)bs.add(SerializerSet.class, builder.serializers().build());
            this.parsers = (ParserSet)bs.add(ParserSet.class, builder.parsers().build());
            this.logger = (Logger)bs.add(Logger.class, (Object)builder.logger());
            this.thrownStore = (ThrownStore)bs.add(ThrownStore.class, builder.thrownStore().build());
            this.methodExecStore = (MethodExecStore)bs.add(MethodExecStore.class, builder.methodExecStore().thrownStoreOnce(this.thrownStore).build());
            this.messages = (Messages)bs.add(Messages.class, builder.messages().build());
            this.varResolver = (VarResolver)bs.add(VarResolver.class, builder.varResolver().bean(Messages.class, (Object)this.messages).build());
            this.config = (Config)bs.add(Config.class, (Object)builder.config().resolving(this.varResolver.createSession()));
            this.responseProcessors = (ResponseProcessor[])bs.add(ResponseProcessor[].class, (Object)((ResponseProcessorList)builder.responseProcessors().build()).toArray());
            this.callLogger = (RestLogger)bs.add(RestLogger.class, builder.callLogger().loggerOnce(this.logger).thrownStoreOnce(this.thrownStore).build());
            this.partSerializer = (HttpPartSerializer)bs.add(HttpPartSerializer.class, builder.partSerializer().create());
            this.partParser = (HttpPartParser)bs.add(HttpPartParser.class, builder.partParser().create());
            this.jsonSchemaGenerator = (JsonSchemaGenerator)bs.add(JsonSchemaGenerator.class, (Object)builder.jsonSchemaGenerator().build());
            this.fileFinder = (FileFinder)bs.add(FileFinder.class, builder.fileFinder().build());
            this.staticFiles = (StaticFiles)bs.add(StaticFiles.class, builder.staticFiles().build());
            this.defaultRequestHeaders = (HeaderList)bs.add(HeaderList.class, builder.defaultRequestHeaders().build(), "RestContext.defaultRequestHeaders");
            this.defaultResponseHeaders = (HeaderList)bs.add(HeaderList.class, builder.defaultResponseHeaders().build(), "RestContext.defaultResponseHeaders");
            this.defaultRequestAttributes = (NamedAttributeList)bs.add(NamedAttributeList.class, builder.defaultRequestAttributes().build(), "RestContext.defaultRequestAttributes");
            this.restOpArgs = ((RestOpArgList)builder.restOpArgs().build()).asArray();
            this.debugEnablement = builder.debugEnablement().build();
            this.startCallMethods = (MethodInvoker[])builder.startCallMethods().stream().map(this::toMethodInvoker).toArray(MethodInvoker[]::new);
            this.endCallMethods = (MethodInvoker[])builder.endCallMethods().stream().map(this::toMethodInvoker).toArray(MethodInvoker[]::new);
            this.postInitMethods = (MethodInvoker[])builder.postInitMethods().stream().map(this::toMethodInvoker).toArray(MethodInvoker[]::new);
            this.postInitChildFirstMethods = (MethodInvoker[])builder.postInitChildFirstMethods().stream().map(this::toMethodInvoker).toArray(MethodInvoker[]::new);
            this.destroyMethods = (MethodInvoker[])builder.destroyMethods().stream().map(this::toMethodInvoker).toArray(MethodInvoker[]::new);
            this.preCallMethods = builder.preCallMethods();
            this.postCallMethods = builder.postCallMethods();
            this.restOperations = (RestOperations)builder.restOperations(this).build();
            this.restChildren = (RestChildren)builder.restChildren(this).build();
            this.swaggerProvider = builder.swaggerProvider().build();
            List<RestOpContext> opContexts = this.restOperations.getOpContexts();
            this.produces = builder.produces().orElseGet(() -> {
                Set s = opContexts.isEmpty() ? Collections.emptySet() : CollectionUtils.setFrom((Collection)((RestOpContext)opContexts.get(0)).getSerializers().getSupportedMediaTypes());
                opContexts.forEach(x -> s.retainAll(x.getSerializers().getSupportedMediaTypes()));
                return CollectionUtils.unmodifiable((List)CollectionUtils.listFrom((Collection)s));
            });
            this.consumes = builder.consumes().orElseGet(() -> {
                Set s = opContexts.isEmpty() ? Collections.emptySet() : CollectionUtils.setFrom((Collection)((RestOpContext)opContexts.get(0)).getParsers().getSupportedMediaTypes());
                opContexts.forEach(x -> s.retainAll(x.getParsers().getSupportedMediaTypes()));
                return CollectionUtils.unmodifiable((List)CollectionUtils.listFrom((Collection)s));
            });
        }
        catch (BasicHttpException e) {
            _initException = e;
            throw e;
        }
        catch (Exception e) {
            _initException = new InternalServerError((Throwable)e);
            throw e;
        }
        finally {
            this.initException = _initException;
        }
    }

    private MethodInvoker toMethodInvoker(Method m) {
        return new MethodInvoker(m, this.getMethodExecStats(m));
    }

    private Set<String> newCaseInsensitiveSet(String value) {
        TreeSet<String> s = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean contains(Object v) {
                return v == null ? false : super.contains(v);
            }
        };
        StringUtils.split((String)value, x -> s.add((String)x));
        return CollectionUtils.unmodifiable((Set)s);
    }

    public RestSession.Builder createSession() {
        return RestSession.create(this);
    }

    public BeanStore getBeanStore() {
        return this.beanStore;
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public EncoderSet getEncoders() {
        return this.encoders;
    }

    public SerializerSet getSerializers() {
        return this.serializers;
    }

    public ParserSet getParsers() {
        return this.parsers;
    }

    protected MethodExecStats getMethodExecStats(Method m) {
        return this.methodExecStore.getStats(m);
    }

    public VarResolver getVarResolver() {
        return this.varResolver;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getPath() {
        return this.path;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public RestLogger getCallLogger() {
        return this.callLogger;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public SwaggerProvider getSwaggerProvider() {
        return this.swaggerProvider;
    }

    public Object getResource() {
        return this.resource.get();
    }

    public String getServletInitParameter(String name) {
        return this.builder.getInitParameter(name);
    }

    public RestChildren getRestChildren() {
        return this.restChildren;
    }

    public boolean isRenderResponseStackTraces() {
        return this.renderResponseStackTraces;
    }

    public boolean isAllowContentParam() {
        return this.allowContentParam;
    }

    public Set<String> getAllowedHeaderParams() {
        return this.allowedHeaderParams;
    }

    public Set<String> getAllowedMethodHeaders() {
        return this.allowedMethodHeaders;
    }

    public Set<String> getAllowedMethodParams() {
        return this.allowedMethodParams;
    }

    public String getClientVersionHeader() {
        return this.clientVersionHeader;
    }

    public FileFinder getFileFinder() {
        return this.fileFinder;
    }

    public StaticFiles getStaticFiles() {
        return this.staticFiles;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ThrownStore getThrownStore() {
        return this.thrownStore;
    }

    public HttpPartParser getPartParser() {
        return this.partParser;
    }

    public HttpPartSerializer getPartSerializer() {
        return this.partSerializer;
    }

    public JsonSchemaGenerator getJsonSchemaGenerator() {
        return this.jsonSchemaGenerator;
    }

    public List<MediaType> getProduces() {
        return this.produces;
    }

    public List<MediaType> getConsumes() {
        return this.consumes;
    }

    public HeaderList getDefaultRequestHeaders() {
        return this.defaultRequestHeaders;
    }

    public NamedAttributeList getDefaultRequestAttributes() {
        return this.defaultRequestAttributes;
    }

    public HeaderList getDefaultResponseHeaders() {
        return this.defaultResponseHeaders;
    }

    public String getUriAuthority() {
        if (this.uriAuthority != null) {
            return this.uriAuthority;
        }
        if (this.parentContext != null) {
            return this.parentContext.getUriAuthority();
        }
        return null;
    }

    public String getUriContext() {
        if (this.uriContext != null) {
            return this.uriContext;
        }
        if (this.parentContext != null) {
            return this.parentContext.getUriContext();
        }
        return null;
    }

    public UriRelativity getUriRelativity() {
        return this.uriRelativity;
    }

    public UriResolution getUriResolution() {
        return this.uriResolution;
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public MethodExecStore getMethodExecStore() {
        return this.methodExecStore;
    }

    public RestContextStats getStats() {
        return new RestContextStats(this.startTime, this.getMethodExecStore().getStatsByTotalTime());
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public ServletConfig getBuilder() {
        return this.builder;
    }

    public UrlPathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public BeanStore getRootBeanStore() {
        return this.rootBeanStore;
    }

    public Optional<Swagger> getSwagger(Locale locale) {
        Swagger s = this.swaggerCache.get(locale);
        if (s == null) {
            try {
                s = this.swaggerProvider.getSwagger(this, locale);
                if (s != null) {
                    this.swaggerCache.put(locale, s);
                }
            }
            catch (Exception e) {
                throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
            }
        }
        return CollectionUtils.optional((Object)s);
    }

    protected RestOpArg[] findRestOperationArgs(Method m, BeanStore beanStore) {
        MethodInfo mi = MethodInfo.of((Method)m);
        List pt = mi.getParamTypes();
        RestOpArg[] ra = new RestOpArg[pt.size()];
        beanStore = BeanStore.of((BeanStore)beanStore, (Object)this.getResource());
        for (int i = 0; i < pt.size(); ++i) {
            ParamInfo pi = mi.getParam(i);
            beanStore.addBean(ParamInfo.class, (Object)pi);
            for (Class<? extends RestOpArg> c : this.restOpArgs) {
                try {
                    ra[i] = (RestOpArg)beanStore.createBean(RestOpArg.class).type(c).run();
                    if (ra[i] == null) continue;
                    break;
                }
                catch (ExecutableException e) {
                    throw new InternalServerError(e.unwrap(), "Could not resolve parameter {0} on method {1}.", new Object[]{i, mi.getFullName()});
                }
            }
            if (ra[i] != null) continue;
            throw new InternalServerError("Could not resolve parameter {0} on method {1}.", new Object[]{i, mi.getFullName()});
        }
        return ra;
    }

    protected MethodList getPreCallMethods() {
        return this.preCallMethods;
    }

    protected MethodList getPostCallMethods() {
        return this.postCallMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object resource, HttpServletRequest r1, HttpServletResponse r2) throws ServletException, IOException {
        if (this.localSession.get() != null) {
            System.err.println("WARNING:  Thread-local call object was not cleaned up from previous request.  " + (Object)((Object)this) + ", thread=[" + Thread.currentThread().getId() + "]");
        }
        RestSession.Builder sb = this.createSession().resource(resource).req(r1).res(r2).logger(this.getCallLogger());
        try {
            Optional<RestChildMatch> childMatch;
            if (this.initException != null) {
                throw this.initException;
            }
            if (this.pathMatcher.hasVars() && this.parentContext == null) {
                String sp = sb.req().getServletPath();
                String pi = sb.getPathInfoUndecoded();
                UrlPath upi2 = UrlPath.of(pi == null ? sp : sp + pi);
                UrlPathMatch uppm = this.pathMatcher.match(upi2);
                if (uppm != null && !uppm.hasEmptyVars()) {
                    sb.pathVars(uppm.getVars());
                    sb.req((HttpServletRequest)new OverrideableHttpServletRequest(sb.req()).pathInfo(StringUtils.nullIfEmpty((String)StringUtils.urlDecode((String)uppm.getSuffix()))).servletPath(uppm.getPrefix()));
                } else {
                    RestSession call = sb.build();
                    call.debug(this.isDebug(call)).status(404).finish();
                    return;
                }
            }
            if ((childMatch = this.restChildren.findMatch(sb)).isPresent()) {
                UrlPathMatch uppm = childMatch.get().getPathMatch();
                RestContext rc = childMatch.get().getChildContext();
                if (!uppm.hasEmptyVars()) {
                    sb.pathVars(uppm.getVars());
                    OverrideableHttpServletRequest childRequest = new OverrideableHttpServletRequest(sb.req()).pathInfo(StringUtils.nullIfEmpty((String)StringUtils.urlDecode((String)uppm.getSuffix()))).servletPath(sb.req().getServletPath() + uppm.getPrefix());
                    rc.execute(rc.getResource(), (HttpServletRequest)childRequest, sb.res());
                } else {
                    RestSession call = sb.build();
                    call.debug(this.isDebug(call)).status(404).finish();
                }
                return;
            }
        }
        catch (Throwable e) {
            this.handleError(sb.build(), this.convertThrowable(e, InternalServerError.class));
        }
        RestSession s = sb.build();
        try {
            this.localSession.set(s);
            s.debug(this.isDebug(s));
            this.startCall(s);
            s.run();
        }
        catch (Throwable e) {
            this.handleError(s, this.convertThrowable(e, InternalServerError.class));
        }
        finally {
            try {
                s.finish();
                this.finishCall(s);
            }
            finally {
                this.localSession.remove();
            }
        }
    }

    private boolean isDebug(RestSession call) {
        return this.debugEnablement.isDebug(this, call.getRequest());
    }

    public DebugEnablement getDebugEnablement() {
        return this.debugEnablement;
    }

    protected void processResponse(RestOpSession opSession) throws IOException, BasicHttpException, NotImplemented {
        int loops = 5;
        for (int i = 0; i < this.responseProcessors.length; ++i) {
            int j = this.responseProcessors[i].process(opSession);
            if (j == 1) {
                return;
            }
            if (j != 2) continue;
            if (loops-- < 0) {
                throw new InternalServerError("Too many processing loops.", new Object[0]);
            }
            i = -1;
        }
        Object output = opSession.getResponse().getContent().orElse(null);
        throw new NotImplemented("No response processors found to process output of type ''{0}''", new Object[]{ClassUtils.className(output)});
    }

    public Throwable convertThrowable(Throwable t, Class<?> defaultThrowable) {
        ClassInfo ci = ClassInfo.of((Object)t);
        if (ci.is(InvocationTargetException.class)) {
            t = ((InvocationTargetException)t).getTargetException();
            ci = ClassInfo.of((Object)t);
        }
        if (ci.is(HttpRuntimeException.class)) {
            t = ((HttpRuntimeException)((Object)t)).getInner();
            ci = ClassInfo.of((Object)t);
        }
        if (ci.is(ExecutableException.class)) {
            t = ((ExecutableException)t).getTargetException();
            ci = ClassInfo.of((Object)t);
        }
        if (ci.hasAnnotation(Response.class)) {
            return t;
        }
        if (ci.isChildOf(ParseException.class) || ci.is(InvalidDataConversionException.class)) {
            return new BadRequest(t);
        }
        String n = ClassUtils.className((Object)t);
        if (n.contains("AccessDenied") || n.contains("Unauthorized")) {
            return new Unauthorized(t);
        }
        if (n.contains("Empty") || n.contains("NotFound")) {
            return new NotFound(t);
        }
        if (defaultThrowable == null) {
            return new InternalServerError(t);
        }
        ClassInfo eci = ClassInfo.of(defaultThrowable);
        try {
            ConstructorInfo cci = eci.getPublicConstructor(x -> x.hasParamTypes(new Class[]{Throwable.class, String.class, Object[].class}));
            if (cci != null) {
                return HttpRuntimeException.toHttpException((Throwable)cci.invoke(new Object[]{t, t.getMessage(), new Object[0]}), InternalServerError.class);
            }
            cci = eci.getPublicConstructor(x -> x.hasParamTypes(new Class[]{Throwable.class}));
            if (cci != null) {
                return HttpRuntimeException.toHttpException((Throwable)cci.invoke(new Object[]{t}), InternalServerError.class);
            }
            System.err.println("WARNING:  Class '" + eci + "' does not have a public constructor that takes in valid arguments.");
            return new InternalServerError(t);
        }
        catch (ExecutableException e) {
            return new InternalServerError(e.getCause());
        }
    }

    protected void handleNotFound(RestSession session) throws Exception {
        String onPath;
        String pathInfo = session.getPathInfo();
        String methodUC = session.getMethod();
        int rc = session.getStatus();
        String string = onPath = pathInfo == null ? " on no pathInfo" : String.format(" on path '%s'", pathInfo);
        if (rc == 404) {
            throw new NotFound("Method ''{0}'' not found on resource with matching pattern{1}.", new Object[]{methodUC, onPath});
        }
        if (rc == 412) {
            throw new PreconditionFailed("Method ''{0}'' not found on resource{1} with matching matcher.", new Object[]{methodUC, onPath});
        }
        if (rc == 405) {
            throw new MethodNotAllowed("Method ''{0}'' not found on resource{1}.", new Object[]{methodUC, onPath});
        }
        throw new ServletException("Invalid method response: " + rc, session.getException());
    }

    protected synchronized void handleError(RestSession session, Throwable e) throws IOException {
        session.exception(e);
        if (session.isDebug()) {
            e.printStackTrace();
        }
        int code = 500;
        ClassInfo ci = ClassInfo.of((Object)e);
        StatusCode r = (StatusCode)ci.getAnnotation(StatusCode.class);
        if (r != null && r.value().length > 0) {
            code = r.value()[0];
        }
        BasicHttpException e2 = e instanceof BasicHttpException ? (BasicHttpException)e : BasicHttpException.create(BasicHttpException.class).causedBy(e).statusCode(code).build();
        HttpServletRequest req = session.getRequest();
        HttpServletResponse res = session.getResponse();
        Throwable t = null;
        if (e instanceof HttpRuntimeException) {
            t = ((HttpRuntimeException)((Object)e)).getInner();
        }
        if (t == null) {
            t = e2.getRootCause();
        }
        if (t != null) {
            Thrown t2 = HttpHeaders.thrown((Throwable[])new Throwable[]{t});
            res.setHeader(t2.getName(), t2.getValue());
        }
        try {
            res.setContentType("text/plain");
            res.setHeader("Content-Encoding", "identity");
            int statusCode = e2.getStatusLine().getStatusCode();
            res.setStatus(statusCode);
            PrintWriter w = null;
            try {
                w = res.getWriter();
            }
            catch (IllegalStateException x) {
                w = new PrintWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), IOUtils.UTF8));
            }
            try (PrintWriter w2 = w;){
                String httpMessage = RestUtils.getHttpResponseText(statusCode);
                if (httpMessage != null) {
                    w2.append("HTTP ").append(String.valueOf(statusCode)).append(": ").append(httpMessage).append("\n\n");
                }
                if (this.isRenderResponseStackTraces()) {
                    e.printStackTrace(w2);
                } else {
                    w2.append(e2.getFullStackMessage(true));
                }
            }
        }
        catch (Exception e1) {
            req.setAttribute("Exception", (Object)e1);
        }
    }

    protected void startCall(RestSession session) throws BasicHttpException {
        for (MethodInvoker x : this.startCallMethods) {
            try {
                x.invoke(session.getBeanStore(), session.getContext().getResource());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw (InternalServerError)InternalServerError.create().message("Error occurred invoking start-call method ''{0}''.", new Object[]{x.getFullName()}).causedBy((Throwable)e).build();
            }
            catch (InvocationTargetException e) {
                throw HttpRuntimeException.toHttpException(e.getTargetException(), InternalServerError.class);
            }
        }
    }

    protected void preCall(RestOpSession session) throws Throwable {
        for (RestOpInvoker m : session.getContext().getPreCallMethods()) {
            m.invoke(session);
        }
    }

    protected void postCall(RestOpSession session) throws Throwable {
        for (RestOpInvoker m : session.getContext().getPostCallMethods()) {
            m.invoke(session);
        }
    }

    protected void finishCall(RestSession session) {
        for (MethodInvoker x : this.endCallMethods) {
            try {
                x.invoke(session.getBeanStore(), session.getResource());
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, this.unwrap(e), () -> StringUtils.format((String)"Error occurred invoking finish-call method ''{0}''.", (Object[])new Object[]{x.getFullName()}));
            }
        }
    }

    public synchronized RestContext postInit() throws ServletException {
        if (this.initialized.get()) {
            return this;
        }
        Object resource = this.getResource();
        MethodInfo mi = ClassInfo.of((Object)this.getResource()).getPublicMethod(x -> x.hasName("setContext") && x.hasParamTypes(new Class[]{RestContext.class}));
        if (mi != null) {
            try {
                mi.accessible().invoke(resource, new Object[]{this});
            }
            catch (ExecutableException e) {
                throw new ServletException(e.unwrap());
            }
        }
        for (MethodInvoker x2 : this.postInitMethods) {
            try {
                x2.invoke(this.beanStore, this.getResource());
            }
            catch (Exception e) {
                throw new ServletException(this.unwrap(e));
            }
        }
        this.restChildren.postInit();
        return this;
    }

    public RestContext postInitChildFirst() throws ServletException {
        if (this.initialized.get()) {
            return this;
        }
        this.restChildren.postInitChildFirst();
        for (MethodInvoker x : this.postInitChildFirstMethods) {
            try {
                x.invoke(this.beanStore, this.getResource());
            }
            catch (Exception e) {
                throw new ServletException(this.unwrap(e));
            }
        }
        this.initialized.set(true);
        return this;
    }

    public void destroy() {
        for (MethodInvoker x : this.destroyMethods) {
            try {
                x.invoke(this.beanStore, this.getResource());
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, this.unwrap(e), () -> StringUtils.format((String)"Error occurred invoking servlet-destroy method ''{0}''.", (Object[])new Object[]{x.getFullName()}));
            }
        }
        this.restChildren.destroy();
    }

    public RestSession getLocalSession() {
        RestSession rc = this.localSession.get();
        if (rc == null) {
            throw new InternalServerError("No active request on current thread.", new Object[0]);
        }
        return rc;
    }

    public ResponseBeanMeta getResponseBeanMeta(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ResponseBeanMeta rbm = this.responseBeanMetas.get(c);
        if (rbm == null) {
            rbm = ResponseBeanMeta.create(c, (AnnotationWorkList)this.getAnnotations());
            if (rbm == null) {
                rbm = ResponseBeanMeta.NULL;
            }
            this.responseBeanMetas.put(c, rbm);
        }
        if (rbm == ResponseBeanMeta.NULL) {
            return null;
        }
        return rbm;
    }

    public AnnotationWorkList getAnnotations() {
        return this.builder.getApplied();
    }

    private Throwable unwrap(Throwable t) {
        if (t instanceof InvocationTargetException) {
            return ((InvocationTargetException)t).getTargetException();
        }
        return t;
    }

    static ServletException servletException(String msg, Object ... args) {
        return new ServletException(StringUtils.format((String)msg, (Object[])args));
    }

    static ServletException servletException(Throwable t, String msg, Object ... args) {
        return new ServletException(StringUtils.format((String)msg, (Object[])args), t);
    }

    protected JsonMap properties() {
        return JsonMap.filteredMap().append("allowContentParam", (Object)this.allowContentParam).append("allowedMethodHeader", this.allowedMethodHeaders).append("allowedMethodParams", this.allowedMethodParams).append("allowedHeaderParams", this.allowedHeaderParams).append("beanStore", (Object)this.beanStore).append("clientVersionHeader", (Object)this.clientVersionHeader).append("consumes", this.consumes).append("defaultRequestHeaders", (Object)this.defaultRequestHeaders).append("defaultResponseHeaders", (Object)this.defaultResponseHeaders).append("fileFinder", (Object)this.fileFinder).append("restOpArgs", this.restOpArgs).append("partParser", (Object)this.partParser).append("partSerializer", (Object)this.partSerializer).append("produces", this.produces).append("renderResponseStackTraces", (Object)this.renderResponseStackTraces).append("responseProcessors", (Object)this.responseProcessors).append("staticFiles", (Object)this.staticFiles).append("swaggerProvider", (Object)this.swaggerProvider).append("uriAuthority", (Object)this.uriAuthority).append("uriContext", (Object)this.uriContext).append("uriRelativity", (Object)this.uriRelativity).append("uriResolution", (Object)this.uriResolution);
    }

    @FluentSetters(ignore={"set"})
    public static class Builder
    extends Context.Builder
    implements ServletConfig {
        private boolean initialized;
        Supplier<?> resource;
        ServletContext servletContext;
        final ServletConfig inner;
        final Class<?> resourceClass;
        final RestContext parentContext;
        private DefaultClassList defaultClasses;
        private DefaultSettingsMap defaultSettings;
        private BeanStore rootBeanStore;
        private BeanStore beanStore;
        private Config config;
        private VarResolver.Builder varResolver;
        private Logger logger;
        private ThrownStore.Builder thrownStore;
        private MethodExecStore.Builder methodExecStore;
        private Messages.Builder messages;
        private ResponseProcessorList.Builder responseProcessors;
        private RestLogger.Builder callLogger;
        private HttpPartSerializer.Creator partSerializer;
        private HttpPartParser.Creator partParser;
        private JsonSchemaGenerator.Builder jsonSchemaGenerator;
        private FileFinder.Builder fileFinder;
        private StaticFiles.Builder staticFiles;
        private HeaderList.Builder defaultRequestHeaders;
        private HeaderList.Builder defaultResponseHeaders;
        private NamedAttributeList.Builder defaultRequestAttributes;
        private RestOpArgList.Builder restOpArgs;
        private DebugEnablement.Builder debugEnablement;
        private MethodList startCallMethods;
        private MethodList endCallMethods;
        private MethodList postInitMethods;
        private MethodList postInitChildFirstMethods;
        private MethodList destroyMethods;
        private MethodList preCallMethods;
        private MethodList postCallMethods;
        private RestOperations.Builder restOperations;
        private RestChildren.Builder restChildren;
        private SwaggerProvider.Builder swaggerProvider;
        private BeanContext.Builder beanContext;
        private EncoderSet.Builder encoders;
        private SerializerSet.Builder serializers;
        private ParserSet.Builder parsers;
        String allowedHeaderParams = (String)this.env("RestContext.allowedHeaderParams", "Accept,Content-Type");
        String allowedMethodHeaders = (String)this.env("RestContext.allowedMethodHeaders", "");
        String allowedMethodParams = (String)this.env("RestContext.allowedMethodParams", "HEAD,OPTIONS");
        String clientVersionHeader = (String)this.env("RestContext.clientVersionHeader", "Client-Version");
        String debugOn = (String)this.env("RestContext.debugOn", null);
        String path = null;
        String uriAuthority = (String)this.env("RestContext.uriAuthority", null);
        String uriContext = (String)this.env("RestContext.uriContext", null);
        UriRelativity uriRelativity = (UriRelativity)this.env("RestContext.uriRelativity", UriRelativity.RESOURCE);
        UriResolution uriResolution = (UriResolution)this.env("RestContext.uriResolution", UriResolution.ROOT_RELATIVE);
        Charset defaultCharset = (Charset)this.env("RestContext.defaultCharset", IOUtils.UTF8);
        long maxInput = StringUtils.parseLongWithSuffix((String)((String)this.env("RestContext.maxInput", "100M")));
        List<MediaType> consumes;
        List<MediaType> produces;
        boolean disableContentParam = (Boolean)this.env("RestContext.disableContentParam", false);
        boolean renderResponseStackTraces = (Boolean)this.env("RestContext.renderResponseStackTraces", false);
        Class<? extends RestChildren> childrenClass = RestChildren.class;
        Class<? extends RestOpContext> opContextClass = RestOpContext.class;
        Class<? extends RestOperations> operationsClass = RestOperations.class;
        List<Object> children = CollectionUtils.list((Object[])new Object[0]);

        protected Builder(Class<?> resourceClass, RestContext parentContext, ServletConfig servletConfig) {
            this.resourceClass = resourceClass;
            this.inner = servletConfig;
            this.parentContext = parentContext;
            if (parentContext != null) {
                this.defaultClasses = parentContext.defaultClasses.copy();
                this.defaultSettings = parentContext.defaultSettings.copy();
                this.rootBeanStore = parentContext.rootBeanStore;
            } else {
                this.defaultClasses = DefaultClassList.create();
                this.defaultSettings = DefaultSettingsMap.create();
            }
        }

        public Builder copy() {
            throw new NoSuchMethodError("Not implemented.");
        }

        public RestContext build() {
            try {
                return (RestContext)((Object)this.beanStore().createBean(RestContext.class).type(this.getType().orElse(RestContext.class)).builder(Builder.class, (Object)this).run());
            }
            catch (Exception e) {
                throw new InternalServerError((Throwable)e, "Could not instantiate RestContext.", new Object[0]);
            }
        }

        public Builder init(Supplier<?> resource) throws ServletException {
            if (this.initialized) {
                return this;
            }
            this.initialized = true;
            this.resource = resource;
            Supplier<?> r = this.resource;
            Class<?> rc = this.resourceClass;
            this.beanStore = this.createBeanStore(rc, r).build().addBean(Builder.class, (Object)this).addBean(ServletConfig.class, this.inner != null ? this.inner : this).addBean(ServletContext.class, (Object)(this.inner != null ? this.inner : this).getServletContext());
            if (this.rootBeanStore == null) {
                this.rootBeanStore = this.beanStore;
                this.beanStore = BeanStore.of((BeanStore)this.rootBeanStore, r.get());
            }
            BeanStore bs = this.beanStore;
            this.varResolver = this.createVarResolver(bs, rc);
            this.beanStore.add(VarResolver.class, this.varResolver.build());
            this.config = (Config)this.beanStore.add(Config.class, (Object)this.createConfig(bs, rc));
            this.beanStore.add(VarResolver.class, this.varResolver.bean(Config.class, (Object)this.config).build());
            ClassInfo rci = ClassInfo.of(this.resourceClass);
            VarResolverSession vrs = ((VarResolver)this.varResolver().build()).createSession();
            AnnotationWorkList work = AnnotationWorkList.of((VarResolverSession)vrs, (AnnotationList)rci.getAnnotationList(Context.CONTEXT_APPLY_FILTER));
            this.apply(work);
            this.beanContext().apply(work);
            this.partSerializer().apply(work);
            this.partParser().apply(work);
            this.jsonSchemaGenerator().apply(work);
            this.runInitHooks(bs, this.resource());
            return this;
        }

        private void runInitHooks(BeanStore beanStore, Supplier<?> resource) throws ServletException {
            Object r = resource.get();
            LinkedHashMap map = CollectionUtils.map();
            ClassInfo.ofProxy(r).forEachAllMethodParentFirst(y -> y.hasAnnotation(RestHook.class) && ((RestHook)y.getAnnotation(RestHook.class)).value() == HookEvent.INIT && !y.hasArg(RestOpContext.Builder.class), y -> {
                String sig = y.getSignature();
                if (!map.containsKey(sig)) {
                    map.put(sig, y.accessible());
                }
            });
            for (MethodInfo m : map.values()) {
                if (!beanStore.hasAllParams((ExecutableInfo)m)) {
                    throw RestContext.servletException("Could not call @RestHook(INIT) method {0}.{1}.  Could not find prerequisites: {2}.", m.getDeclaringClass().getSimpleName(), m.getSignature(), beanStore.getMissingParams((ExecutableInfo)m));
                }
                try {
                    m.invoke(r, beanStore.getParams((ExecutableInfo)m));
                }
                catch (Exception e) {
                    throw RestContext.servletException(e, "Exception thrown from @RestHook(INIT) method {0}.{1}.", m.getDeclaringClass().getSimpleName(), m.getSignature());
                }
            }
        }

        public Supplier<?> resource() {
            if (this.resource == null) {
                throw ThrowableUtils.runtimeException((String)"Resource not available.  init(Object) has not been called.", (Object[])new Object[0]);
            }
            return this.resource;
        }

        public <T> Optional<T> resourceAs(Class<T> type) {
            Object r = this.resource().get();
            return CollectionUtils.optional(type.isInstance(r) ? type.cast(r) : null);
        }

        public DefaultClassList defaultClasses() {
            return this.defaultClasses;
        }

        public Builder defaultClasses(Class<?> ... values) {
            this.defaultClasses().add((Class[])values);
            return this;
        }

        public DefaultSettingsMap defaultSettings() {
            return this.defaultSettings;
        }

        public Builder defaultSetting(String key, Object value) {
            this.defaultSettings().set(key, value);
            return this;
        }

        public BeanStore beanStore() {
            return this.beanStore;
        }

        public Builder beanStore(Consumer<BeanStore> operation) {
            operation.accept(this.beanStore());
            return this;
        }

        public BeanStore rootBeanStore() {
            return this.rootBeanStore;
        }

        protected BeanStore.Builder createBeanStore(Class<?> resourceClass, Supplier<?> resource) {
            Value v = Value.of((Object)BeanStore.create().parent(this.rootBeanStore()).outer(resource.get()));
            ClassInfo.of(resourceClass).forEachAnnotation(Rest.class, x -> ClassUtils.isNotVoid(x.beanStore()), x -> ((BeanStore.Builder)v.get()).type(x.beanStore()));
            ((BeanStore.Builder)v.get()).build().createMethodFinder(BeanStore.Builder.class).find("createBeanStore", new Class[0]).run(x -> v.set(x));
            ((BeanStore.Builder)v.get()).build().createMethodFinder(BeanStore.class).find("createBeanStore", new Class[0]).run(x -> ((BeanStore.Builder)v.get()).impl(x));
            return (BeanStore.Builder)v.get();
        }

        public VarResolver.Builder varResolver() {
            return this.varResolver;
        }

        public Builder varResolver(Consumer<VarResolver.Builder> operation) {
            operation.accept(this.varResolver());
            return this;
        }

        protected VarResolver.Builder createVarResolver(BeanStore beanStore, Class<?> resourceClass) {
            Value v = Value.of((Object)VarResolver.create().defaultVars().vars(this.createVars(beanStore, resourceClass)).vars(new Class[]{FileVar.class}).bean(FileFinder.class, FileFinder.create((BeanStore)beanStore).cp(resourceClass, null, true).build()));
            this.rootBeanStore.getBean(VarResolver.class).ifPresent(x -> ((VarResolver.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(VarResolver.Builder.class).find("createVarResolver", new Class[0]).run(x -> v.set(x));
            beanStore.createMethodFinder(VarResolver.class).addBean(VarResolver.Builder.class, v.get()).find("createVarResolver", new Class[0]).run(x -> ((VarResolver.Builder)v.get()).impl(x));
            return (VarResolver.Builder)v.get();
        }

        protected VarList createVars(BeanStore beanStore, Class<?> resourceClass) {
            Value v = Value.of((Object)VarList.of((Class[])new Class[]{ConfigVar.class, FileVar.class, LocalizationVar.class, RequestAttributeVar.class, RequestFormDataVar.class, RequestHeaderVar.class, RequestPathVar.class, RequestQueryVar.class, RequestVar.class, RequestSwaggerVar.class, SerializedRequestAttrVar.class, ServletInitParamVar.class, SwaggerVar.class, UrlVar.class, UrlEncodeVar.class, HtmlWidgetVar.class}).addDefault());
            beanStore.getBean(VarList.class).map(x -> x.copy()).ifPresent(x -> v.set(x));
            beanStore.createMethodFinder(VarList.class).addBean(VarList.class, v.get()).find("createVars", new Class[0]).run(x -> v.set(x));
            return (VarList)v.get();
        }

        public Config config() {
            return this.config;
        }

        public Builder config(Consumer<Config> operation) {
            operation.accept(this.config());
            return this;
        }

        @FluentSetter
        public Builder config(Config config) {
            this.config = config;
            return this;
        }

        protected Config createConfig(BeanStore beanStore, Class<?> resourceClass) {
            Value v = Value.empty();
            VarResolver vr = (VarResolver)beanStore.getBean(VarResolver.class).orElseThrow(() -> ThrowableUtils.runtimeException((String)"VarResolver not found.", (Object[])new Object[0]));
            Value cfv = Value.empty();
            ClassInfo.of(resourceClass).forEachAnnotation(Rest.class, x -> StringUtils.isNotEmpty((String)x.config()), x -> cfv.set((Object)vr.resolve(x.config())));
            String cf = (String)cfv.orElse((Object)"");
            if (v.isEmpty() && "SYSTEM_DEFAULT".equals(cf)) {
                v.set((Object)Config.getSystemDefault());
            }
            if (v.isEmpty()) {
                Config.Builder cb = Config.create().varResolver(vr);
                if (!cf.isEmpty()) {
                    cb.name(cf);
                }
                v.set((Object)cb.build());
            }
            beanStore.getBean(Config.class).ifPresent(x -> v.set(x));
            beanStore.createMethodFinder(Config.class).addBean(Config.class, v.get()).find("createConfig", new Class[0]).run(x -> v.set(x));
            return (Config)v.get();
        }

        public Logger logger() {
            if (this.logger == null) {
                this.logger = this.createLogger(this.beanStore(), this.resourceClass);
            }
            return this.logger;
        }

        public Builder logger(Consumer<Logger> operation) {
            operation.accept(this.logger());
            return this;
        }

        public Builder logger(Logger value) {
            this.logger = value;
            return this;
        }

        protected Logger createLogger(BeanStore beanStore, Class<?> resourceClass) {
            Value v = Value.of((Object)Logger.getLogger(resourceClass.getClass().getName()));
            beanStore.getBean(Logger.class).ifPresent(x -> v.set(x));
            beanStore.createMethodFinder(Logger.class).addBean(Logger.class, v.get()).find("createLogger", new Class[0]).run(x -> v.set(x));
            return (Logger)v.get();
        }

        public ThrownStore.Builder thrownStore() {
            if (this.thrownStore == null) {
                this.thrownStore = this.createThrownStore(this.beanStore(), this.resource(), this.parentContext);
            }
            return this.thrownStore;
        }

        public Builder thrownStore(Consumer<ThrownStore.Builder> operation) {
            operation.accept(this.thrownStore());
            return this;
        }

        protected ThrownStore.Builder createThrownStore(BeanStore beanStore, Supplier<?> resource, RestContext parent) {
            Value v = Value.of((Object)((Object)ThrownStore.create(beanStore).impl(parent == null ? null : parent.getThrownStore())));
            this.defaultClasses().get(ThrownStore.class).ifPresent(x -> ((ThrownStore.Builder)((Object)((Object)v.get()))).type((Class)x));
            this.rootBeanStore.getBean(ThrownStore.class).ifPresent(x -> ((ThrownStore.Builder)((Object)((Object)v.get()))).impl(x));
            beanStore.createMethodFinder(ThrownStore.Builder.class).addBean(ThrownStore.Builder.class, v.get()).find("createThrownStore", new Class[0]).run(x -> v.set((Object)x));
            beanStore.createMethodFinder(ThrownStore.class).addBean(ThrownStore.Builder.class, v.get()).find("createThrownStore", new Class[0]).run(x -> ((ThrownStore.Builder)((Object)((Object)v.get()))).impl(x));
            return (ThrownStore.Builder)((Object)v.get());
        }

        public EncoderSet.Builder encoders() {
            if (this.encoders == null) {
                this.encoders = this.createEncoders(this.beanStore(), this.resource());
            }
            return this.encoders;
        }

        public Builder encoders(Consumer<EncoderSet.Builder> operation) {
            operation.accept(this.encoders());
            return this;
        }

        protected EncoderSet.Builder createEncoders(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)EncoderSet.create((BeanStore)beanStore).add(new Encoder[]{IdentityEncoder.INSTANCE}));
            this.defaultClasses().get(EncoderSet.class).ifPresent(x -> ((EncoderSet.Builder)v.get()).type(x));
            this.rootBeanStore.getBean(EncoderSet.class).ifPresent(x -> ((EncoderSet.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(EncoderSet.Builder.class).addBean(EncoderSet.Builder.class, v.get()).find("createEncoders", new Class[0]).run(x -> v.set(x));
            beanStore.createMethodFinder(EncoderSet.class).addBean(EncoderSet.Builder.class, v.get()).find("createEncoders", new Class[0]).run(x -> ((EncoderSet.Builder)v.get()).impl(x));
            return (EncoderSet.Builder)v.get();
        }

        public SerializerSet.Builder serializers() {
            if (this.serializers == null) {
                this.serializers = this.createSerializers(this.beanStore(), this.resource());
            }
            return this.serializers;
        }

        public Builder serializers(Consumer<SerializerSet.Builder> operation) {
            operation.accept(this.serializers());
            return this;
        }

        protected SerializerSet.Builder createSerializers(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)SerializerSet.create((BeanStore)beanStore));
            this.defaultClasses().get(SerializerSet.class).ifPresent(x -> ((SerializerSet.Builder)v.get()).type(x));
            this.rootBeanStore.getBean(SerializerSet.class).ifPresent(x -> ((SerializerSet.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(SerializerSet.Builder.class).addBean(SerializerSet.Builder.class, v.get()).find("createSerializers", new Class[0]).run(x -> v.set(x));
            beanStore.createMethodFinder(SerializerSet.class).addBean(SerializerSet.Builder.class, v.get()).find("createSerializers", new Class[0]).run(x -> ((SerializerSet.Builder)v.get()).impl(x));
            return (SerializerSet.Builder)v.get();
        }

        public ParserSet.Builder parsers() {
            if (this.parsers == null) {
                this.parsers = this.createParsers(this.beanStore(), this.resource());
            }
            return this.parsers;
        }

        public Builder parsers(Consumer<ParserSet.Builder> operation) {
            operation.accept(this.parsers());
            return this;
        }

        protected ParserSet.Builder createParsers(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)ParserSet.create((BeanStore)beanStore));
            this.defaultClasses().get(ParserSet.class).ifPresent(x -> ((ParserSet.Builder)v.get()).type(x));
            this.rootBeanStore.getBean(ParserSet.class).ifPresent(x -> ((ParserSet.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(ParserSet.Builder.class).addBean(ParserSet.Builder.class, v.get()).find("createParsers", new Class[0]).run(x -> v.set(x));
            beanStore.createMethodFinder(ParserSet.class).addBean(ParserSet.Builder.class, v.get()).find("createParsers", new Class[0]).run(x -> ((ParserSet.Builder)v.get()).impl(x));
            return (ParserSet.Builder)v.get();
        }

        public MethodExecStore.Builder methodExecStore() {
            if (this.methodExecStore == null) {
                this.methodExecStore = this.createMethodExecStore(this.beanStore(), this.resource());
            }
            return this.methodExecStore;
        }

        public Builder methodExecStore(Consumer<MethodExecStore.Builder> operation) {
            operation.accept(this.methodExecStore());
            return this;
        }

        protected MethodExecStore.Builder createMethodExecStore(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)((Object)MethodExecStore.create(beanStore)));
            this.defaultClasses().get(MethodExecStore.class).ifPresent(x -> ((MethodExecStore.Builder)((Object)((Object)v.get()))).type((Class)x));
            this.rootBeanStore.getBean(MethodExecStore.class).ifPresent(x -> ((MethodExecStore.Builder)((Object)((Object)v.get()))).impl(x));
            beanStore.createMethodFinder(MethodExecStore.Builder.class).addBean(MethodExecStore.Builder.class, v.get()).find("createMethodExecStore", new Class[0]).run(x -> v.set((Object)x));
            beanStore.createMethodFinder(MethodExecStore.class).addBean(MethodExecStore.Builder.class, v.get()).find("createMethodExecStore", new Class[0]).run(x -> ((MethodExecStore.Builder)((Object)((Object)v.get()))).impl(x));
            return (MethodExecStore.Builder)((Object)v.get());
        }

        public Messages.Builder messages() {
            if (this.messages == null) {
                this.messages = this.createMessages(this.beanStore(), this.resource());
            }
            return this.messages;
        }

        public Builder messages(Consumer<Messages.Builder> operation) {
            operation.accept(this.messages());
            return this;
        }

        protected Messages.Builder createMessages(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)Messages.create(this.resourceClass));
            this.rootBeanStore.getBean(Messages.class).ifPresent(x -> ((Messages.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(Messages.Builder.class).find("createMessages", new Class[0]).run(x -> v.set(x));
            beanStore.createMethodFinder(Messages.class).addBean(Messages.Builder.class, v.get()).find("createMessages", new Class[0]).run(x -> ((Messages.Builder)v.get()).impl(x));
            return (Messages.Builder)v.get();
        }

        public ResponseProcessorList.Builder responseProcessors() {
            if (this.responseProcessors == null) {
                this.responseProcessors = this.createResponseProcessors(this.beanStore(), this.resource());
            }
            return this.responseProcessors;
        }

        public Builder responseProcessors(Consumer<ResponseProcessorList.Builder> operation) {
            operation.accept(this.responseProcessors());
            return this;
        }

        protected ResponseProcessorList.Builder createResponseProcessors(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)((Object)ResponseProcessorList.create(beanStore).add(ReaderProcessor.class, InputStreamProcessor.class, ThrowableProcessor.class, HttpResponseProcessor.class, HttpResourceProcessor.class, HttpEntityProcessor.class, ResponseBeanProcessor.class, PlainTextPojoProcessor.class, SerializedPojoProcessor.class)));
            this.rootBeanStore.getBean(ResponseProcessorList.class).ifPresent(x -> ((ResponseProcessorList.Builder)((Object)((Object)v.get()))).impl(x));
            beanStore.createMethodFinder(ResponseProcessorList.Builder.class).addBean(ResponseProcessorList.Builder.class, v.get()).find("createResponseProcessors", new Class[0]).run(x -> v.set((Object)x));
            beanStore.createMethodFinder(ResponseProcessorList.class).addBean(ResponseProcessorList.Builder.class, v.get()).find("createResponseProcessors", new Class[0]).run(x -> ((ResponseProcessorList.Builder)((Object)((Object)v.get()))).impl(x));
            return (ResponseProcessorList.Builder)((Object)v.get());
        }

        public RestLogger.Builder callLogger() {
            if (this.callLogger == null) {
                this.callLogger = this.createCallLogger(this.beanStore(), this.resource());
            }
            return this.callLogger;
        }

        public Builder callLogger(Consumer<RestLogger.Builder> operation) {
            operation.accept(this.callLogger());
            return this;
        }

        protected RestLogger.Builder createCallLogger(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)((Object)RestLogger.create(beanStore).normalRules((RestLoggerRule)RestLoggerRule.create(beanStore).statusFilter(a -> a >= 500).level(Level.SEVERE).requestDetail(RestLoggingDetail.HEADER).responseDetail(RestLoggingDetail.HEADER).build(), (RestLoggerRule)RestLoggerRule.create(beanStore).statusFilter(a -> a >= 400).level(Level.WARNING).requestDetail(RestLoggingDetail.STATUS_LINE).responseDetail(RestLoggingDetail.STATUS_LINE).build()).debugRules((RestLoggerRule)RestLoggerRule.create(beanStore).level(Level.SEVERE).requestDetail(RestLoggingDetail.ENTITY).responseDetail(RestLoggingDetail.ENTITY).build())));
            this.rootBeanStore.getBean(RestLogger.class).ifPresent(x -> ((RestLogger.Builder)((Object)((Object)v.get()))).impl(x));
            this.resourceAs(RestLogger.class).ifPresent(x -> ((RestLogger.Builder)((Object)((Object)v.get()))).impl(x));
            this.defaultClasses().get(RestLogger.class).ifPresent(x -> ((RestLogger.Builder)((Object)((Object)v.get()))).type((Class)x));
            beanStore.createMethodFinder(RestLogger.Builder.class).addBean(RestLogger.Builder.class, v.get()).find("createCallLogger", new Class[0]).run(x -> v.set((Object)x));
            beanStore.createMethodFinder(RestLogger.class).addBean(RestLogger.Builder.class, v.get()).find("createCallLogger", new Class[0]).run(x -> ((RestLogger.Builder)((Object)((Object)v.get()))).impl(x));
            return (RestLogger.Builder)((Object)v.get());
        }

        public BeanContext.Builder beanContext() {
            if (this.beanContext == null) {
                this.beanContext = this.createBeanContext(this.beanStore(), this.resource());
            }
            return this.beanContext;
        }

        public Builder beanContext(Consumer<BeanContext.Builder> operation) {
            operation.accept(this.beanContext());
            return this;
        }

        protected BeanContext.Builder createBeanContext(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)BeanContext.create());
            beanStore.getBean(BeanContext.Builder.class).map(x -> x.copy()).ifPresent(x -> v.set(x));
            this.rootBeanStore.getBean(BeanContext.class).ifPresent(x -> ((BeanContext.Builder)v.get()).impl((Context)x));
            beanStore.createMethodFinder(BeanContext.Builder.class).addBean(BeanContext.Builder.class, v.get()).find("createBeanContext", new Class[0]).run(x -> v.set(x));
            beanStore.createMethodFinder(BeanContext.class).addBean(BeanContext.Builder.class, v.get()).find("createBeanContext", new Class[0]).run(x -> ((BeanContext.Builder)v.get()).impl((Context)x));
            return (BeanContext.Builder)v.get();
        }

        public HttpPartSerializer.Creator partSerializer() {
            if (this.partSerializer == null) {
                this.partSerializer = this.createPartSerializer(this.beanStore(), this.resource());
            }
            return this.partSerializer;
        }

        public Builder partSerializer(Consumer<HttpPartSerializer.Creator> operation) {
            operation.accept(this.partSerializer());
            return this;
        }

        protected HttpPartSerializer.Creator createPartSerializer(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)HttpPartSerializer.creator().type(OpenApiSerializer.class));
            beanStore.getBean(HttpPartSerializer.Creator.class).map(x -> x.copy()).ifPresent(x -> v.set(x));
            this.rootBeanStore.getBean(HttpPartSerializer.class).ifPresent(x -> ((HttpPartSerializer.Creator)v.get()).impl(x));
            this.resourceAs(HttpPartSerializer.class).ifPresent(x -> ((HttpPartSerializer.Creator)v.get()).impl(x));
            this.defaultClasses().get(HttpPartSerializer.class).ifPresent(x -> ((HttpPartSerializer.Creator)v.get()).type(x));
            beanStore.createMethodFinder(HttpPartSerializer.Creator.class).addBean(HttpPartSerializer.Creator.class, v.get()).find("createPartSerializer", new Class[0]).run(x -> v.set(x));
            beanStore.createMethodFinder(HttpPartSerializer.class).addBean(HttpPartSerializer.Creator.class, v.get()).find("createPartSerializer", new Class[0]).run(x -> ((HttpPartSerializer.Creator)v.get()).impl(x));
            return (HttpPartSerializer.Creator)v.get();
        }

        public HttpPartParser.Creator partParser() {
            if (this.partParser == null) {
                this.partParser = this.createPartParser(this.beanStore(), this.resource());
            }
            return this.partParser;
        }

        public Builder partParser(Consumer<HttpPartParser.Creator> operation) {
            operation.accept(this.partParser());
            return this;
        }

        protected HttpPartParser.Creator createPartParser(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)HttpPartParser.creator().type(OpenApiParser.class));
            beanStore.getBean(HttpPartParser.Creator.class).map(x -> x.copy()).ifPresent(x -> v.set(x));
            this.rootBeanStore.getBean(HttpPartParser.class).ifPresent(x -> ((HttpPartParser.Creator)v.get()).impl(x));
            this.resourceAs(HttpPartParser.class).ifPresent(x -> ((HttpPartParser.Creator)v.get()).impl(x));
            this.defaultClasses().get(HttpPartParser.class).ifPresent(x -> ((HttpPartParser.Creator)v.get()).type(x));
            beanStore.createMethodFinder(HttpPartParser.Creator.class).addBean(HttpPartParser.Creator.class, v.get()).find("createPartParser", new Class[0]).run(x -> v.set(x));
            beanStore.createMethodFinder(HttpPartParser.class).addBean(HttpPartParser.Creator.class, v.get()).find("createPartParser", new Class[0]).run(x -> ((HttpPartParser.Creator)v.get()).impl(x));
            return (HttpPartParser.Creator)v.get();
        }

        public JsonSchemaGenerator.Builder jsonSchemaGenerator() {
            if (this.jsonSchemaGenerator == null) {
                this.jsonSchemaGenerator = this.createJsonSchemaGenerator(this.beanStore(), this.resource());
            }
            return this.jsonSchemaGenerator;
        }

        public Builder jsonSchemaGenerator(Consumer<JsonSchemaGenerator.Builder> operation) {
            operation.accept(this.jsonSchemaGenerator());
            return this;
        }

        protected JsonSchemaGenerator.Builder createJsonSchemaGenerator(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)JsonSchemaGenerator.create());
            beanStore.getBean(JsonSchemaGenerator.Builder.class).map(x -> x.copy()).ifPresent(x -> v.set(x));
            this.rootBeanStore.getBean(JsonSchemaGenerator.class).ifPresent(x -> ((JsonSchemaGenerator.Builder)v.get()).impl((Context)x));
            beanStore.createMethodFinder(JsonSchemaGenerator.Builder.class).addBean(JsonSchemaGenerator.Builder.class, v.get()).find("createJsonSchemaGenerator", new Class[0]).run(x -> v.set(x));
            beanStore.createMethodFinder(JsonSchemaGenerator.class).addBean(JsonSchemaGenerator.Builder.class, v.get()).find("createJsonSchemaGenerator", new Class[0]).run(x -> ((JsonSchemaGenerator.Builder)v.get()).impl((Context)x));
            return (JsonSchemaGenerator.Builder)v.get();
        }

        public FileFinder.Builder fileFinder() {
            if (this.fileFinder == null) {
                this.fileFinder = this.createFileFinder(this.beanStore(), this.resource());
            }
            return this.fileFinder;
        }

        public Builder fileFinder(Consumer<FileFinder.Builder> operation) {
            operation.accept(this.fileFinder());
            return this;
        }

        protected FileFinder.Builder createFileFinder(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)FileFinder.create((BeanStore)beanStore).dir("static").dir("htdocs").cp(this.resourceClass, "htdocs", true).cp(this.resourceClass, "/htdocs", true).caching(1000000L).exclude(new String[]{"(?i).*\\.(class|properties)"}));
            this.rootBeanStore.getBean(FileFinder.class).ifPresent(x -> ((FileFinder.Builder)v.get()).impl(x));
            this.resourceAs(FileFinder.class).ifPresent(x -> ((FileFinder.Builder)v.get()).impl(x));
            this.defaultClasses().get(FileFinder.class).ifPresent(x -> ((FileFinder.Builder)v.get()).type(x));
            beanStore.createMethodFinder(FileFinder.Builder.class).addBean(FileFinder.Builder.class, v.get()).find("createFileFinder", new Class[0]).run(x -> v.set(x));
            beanStore.createMethodFinder(FileFinder.class).addBean(FileFinder.Builder.class, v.get()).find("createFileFinder", new Class[0]).run(x -> ((FileFinder.Builder)v.get()).impl(x));
            return (FileFinder.Builder)v.get();
        }

        public StaticFiles.Builder staticFiles() {
            if (this.staticFiles == null) {
                this.staticFiles = this.createStaticFiles(this.beanStore(), this.resource());
            }
            return this.staticFiles;
        }

        public Builder staticFiles(Consumer<StaticFiles.Builder> operation) {
            operation.accept(this.staticFiles());
            return this;
        }

        protected StaticFiles.Builder createStaticFiles(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)((Object)StaticFiles.create(beanStore).type((Class)BasicStaticFiles.class).dir("static").dir("htdocs").cp(this.resourceClass, "htdocs", true).cp(this.resourceClass, "/htdocs", true).caching(1000000L).exclude("(?i).*\\.(class|properties)").headers(new Header[]{HttpHeaders.cacheControl((String)"max-age=86400, public")})));
            this.rootBeanStore.getBean(StaticFiles.class).ifPresent(x -> ((StaticFiles.Builder)((Object)((Object)v.get()))).impl(x));
            this.resourceAs(StaticFiles.class).ifPresent(x -> ((StaticFiles.Builder)((Object)((Object)v.get()))).impl(x));
            this.defaultClasses().get(StaticFiles.class).ifPresent(x -> ((StaticFiles.Builder)((Object)((Object)v.get()))).type((Class)x));
            beanStore.createMethodFinder(StaticFiles.Builder.class).addBean(StaticFiles.Builder.class, v.get()).find("createStaticFiles", new Class[0]).run(x -> v.set((Object)x));
            beanStore.createMethodFinder(StaticFiles.class).addBean(StaticFiles.Builder.class, v.get()).find("createStaticFiles", new Class[0]).run(x -> ((StaticFiles.Builder)((Object)((Object)v.get()))).impl(x));
            return (StaticFiles.Builder)((Object)v.get());
        }

        public HeaderList.Builder defaultRequestHeaders() {
            if (this.defaultRequestHeaders == null) {
                this.defaultRequestHeaders = this.createDefaultRequestHeaders(this.beanStore(), this.resource());
            }
            return this.defaultRequestHeaders;
        }

        public Builder defaultRequestHeaders(Consumer<HeaderList.Builder> operation) {
            operation.accept(this.defaultRequestHeaders());
            return this;
        }

        @FluentSetter
        public Builder defaultRequestHeaders(Header ... values) {
            this.defaultRequestHeaders().setDefault(values);
            return this;
        }

        @FluentSetter
        public Builder defaultAccept(String value) {
            if (StringUtils.isNotEmpty((String)value)) {
                this.defaultRequestHeaders(new Header[]{HttpHeaders.accept((String)value)});
            }
            return this;
        }

        @FluentSetter
        public Builder defaultContentType(String value) {
            if (StringUtils.isNotEmpty((String)value)) {
                this.defaultRequestHeaders(new Header[]{HttpHeaders.contentType((String)value)});
            }
            return this;
        }

        protected HeaderList.Builder createDefaultRequestHeaders(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)HeaderList.create());
            this.rootBeanStore.getBean(HeaderList.class, "RestContext.defaultRequestHeaders").ifPresent(x -> ((HeaderList.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(HeaderList.Builder.class).addBean(HeaderList.Builder.class, v.get()).find("createDefaultRequestHeaders", new Class[0]).run(x -> v.set(x));
            beanStore.createMethodFinder(HeaderList.class).addBean(HeaderList.Builder.class, v.get()).find("createDefaultRequestHeaders", new Class[0]).run(x -> ((HeaderList.Builder)v.get()).impl(x));
            return (HeaderList.Builder)v.get();
        }

        public HeaderList.Builder defaultResponseHeaders() {
            if (this.defaultResponseHeaders == null) {
                this.defaultResponseHeaders = this.createDefaultResponseHeaders(this.beanStore(), this.resource());
            }
            return this.defaultResponseHeaders;
        }

        public Builder defaultResponseHeaders(Consumer<HeaderList.Builder> operation) {
            operation.accept(this.defaultResponseHeaders());
            return this;
        }

        @FluentSetter
        public Builder defaultResponseHeaders(Header ... values) {
            this.defaultResponseHeaders().setDefault(values);
            return this;
        }

        protected HeaderList.Builder createDefaultResponseHeaders(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)HeaderList.create());
            this.rootBeanStore.getBean(HeaderList.class, "RestContext.defaultResponseHeaders").ifPresent(x -> ((HeaderList.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(HeaderList.Builder.class).addBean(HeaderList.Builder.class, v.get()).find("createDefaultResponseHeaders", new Class[0]).run(x -> v.set(x));
            beanStore.createMethodFinder(HeaderList.class).addBean(HeaderList.Builder.class, v.get()).find("createDefaultResponseHeaders", new Class[0]).run(x -> ((HeaderList.Builder)v.get()).impl(x));
            return (HeaderList.Builder)v.get();
        }

        public NamedAttributeList.Builder defaultRequestAttributes() {
            if (this.defaultRequestAttributes == null) {
                this.defaultRequestAttributes = this.createDefaultRequestAttributes(this.beanStore(), this.resource());
            }
            return this.defaultRequestAttributes;
        }

        public Builder defaultRequestAttributes(Consumer<NamedAttributeList.Builder> operation) {
            operation.accept(this.defaultRequestAttributes());
            return this;
        }

        @FluentSetter
        public Builder defaultRequestAttributes(NamedAttribute ... values) {
            this.defaultRequestAttributes().add(values);
            return this;
        }

        protected NamedAttributeList.Builder createDefaultRequestAttributes(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)((Object)NamedAttributeList.create()));
            this.rootBeanStore.getBean(NamedAttributeList.class, "RestContext.defaultRequestAttributes").ifPresent(x -> ((NamedAttributeList.Builder)((Object)((Object)v.get()))).impl(x));
            beanStore.createMethodFinder(NamedAttributeList.Builder.class).addBean(NamedAttributeList.Builder.class, v.get()).find("createDefaultRequestAttributes", new Class[0]).run(x -> v.set((Object)x));
            beanStore.createMethodFinder(NamedAttributeList.class).addBean(NamedAttributeList.Builder.class, v.get()).find("createDefaultRequestAttributes", new Class[0]).run(x -> ((NamedAttributeList.Builder)((Object)((Object)v.get()))).impl(x));
            return (NamedAttributeList.Builder)((Object)v.get());
        }

        public RestOpArgList.Builder restOpArgs() {
            if (this.restOpArgs == null) {
                this.restOpArgs = this.createRestOpArgs(this.beanStore(), this.resource());
            }
            return this.restOpArgs;
        }

        public Builder restOpArgs(Consumer<RestOpArgList.Builder> operation) {
            operation.accept(this.restOpArgs());
            return this;
        }

        @FluentSetter
        public Builder restOpArgs(Class<?> ... values) {
            this.restOpArgs().add(Assertions.assertClassArrayArgIsType((String)"values", RestOpArg.class, (Class[])values));
            return this;
        }

        protected RestOpArgList.Builder createRestOpArgs(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)((Object)RestOpArgList.create(beanStore).add(AttributeArg.class, ContentArg.class, FormDataArg.class, HasFormDataArg.class, HasQueryArg.class, HeaderArg.class, HttpServletRequestArgs.class, HttpServletResponseArgs.class, HttpSessionArgs.class, InputStreamParserArg.class, MethodArg.class, ParserArg.class, PathArg.class, QueryArg.class, ReaderParserArg.class, RequestBeanArg.class, ResponseBeanArg.class, ResponseHeaderArg.class, ResponseCodeArg.class, RestContextArgs.class, RestSessionArgs.class, RestOpContextArgs.class, RestOpSessionArgs.class, RestRequestArgs.class, RestResponseArgs.class, DefaultArg.class)));
            this.rootBeanStore.getBean(RestOpArgList.class).ifPresent(x -> ((RestOpArgList.Builder)((Object)((Object)v.get()))).impl(x));
            beanStore.createMethodFinder(RestOpArgList.Builder.class).addBean(RestOpArgList.Builder.class, v.get()).find("createRestOpArgs", new Class[0]).run(x -> v.set((Object)x));
            beanStore.createMethodFinder(RestOpArgList.class).addBean(RestOpArgList.Builder.class, v.get()).find("createRestOpArgs", new Class[0]).run(x -> ((RestOpArgList.Builder)((Object)((Object)v.get()))).impl(x));
            return (RestOpArgList.Builder)((Object)v.get());
        }

        public DebugEnablement.Builder debugEnablement() {
            if (this.debugEnablement == null) {
                this.debugEnablement = this.createDebugEnablement(this.beanStore(), this.resource());
            }
            return this.debugEnablement;
        }

        public Builder debugEnablement(Consumer<DebugEnablement.Builder> operation) {
            operation.accept(this.debugEnablement());
            return this;
        }

        @FluentSetter
        public Builder debugDefault(Enablement value) {
            this.defaultSettings().set("RestContext.debugDefault", (Object)value);
            return this;
        }

        public Builder debug(Enablement value) {
            this.debugEnablement().enable(value, this.resourceClass);
            return this;
        }

        @FluentSetter
        public Builder debugOn(String value) {
            for (Map.Entry e : StringUtils.splitMap((String)(value != null ? value : ""), (boolean)true).entrySet()) {
                String k = (String)e.getKey();
                String v = (String)e.getValue();
                if (v.isEmpty()) {
                    v = "ALWAYS";
                }
                if (k.isEmpty()) continue;
                this.debugEnablement().enable(Enablement.fromString((String)v), k);
            }
            return this;
        }

        protected DebugEnablement.Builder createDebugEnablement(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)DebugEnablement.create(beanStore));
            Enablement debugDefault = this.defaultSettings.get(Enablement.class, "RestContext.debugDefault").orElse(this.isDebug() ? Enablement.ALWAYS : Enablement.NEVER);
            ((DebugEnablement.Builder)v.get()).defaultEnable(debugDefault);
            Consumer<MethodInfo> consumer = x -> {
                Value debug = Value.empty();
                x.getAnnotationList(RestOpAnnotation.REST_OP_GROUP).forEachValue(String.class, "debug", StringUtils.NOT_EMPTY, y -> debug.set(y));
                if (debug.isPresent()) {
                    ((DebugEnablement.Builder)v.get()).enable(Enablement.fromString((String)((String)debug.get())), x.getFullName());
                }
            };
            ClassInfo.ofProxy(resource.get()).forEachPublicMethod(x -> true, consumer);
            this.rootBeanStore.getBean(DebugEnablement.class).ifPresent(x -> ((DebugEnablement.Builder)v.get()).impl((DebugEnablement)x));
            this.resourceAs(DebugEnablement.class).ifPresent(x -> ((DebugEnablement.Builder)v.get()).impl((DebugEnablement)x));
            this.defaultClasses().get(DebugEnablement.class).ifPresent(x -> ((DebugEnablement.Builder)v.get()).type((Class<? extends DebugEnablement>)x));
            beanStore.createMethodFinder(DebugEnablement.Builder.class).addBean(DebugEnablement.Builder.class, v.get()).find("createDebugEnablement", new Class[0]).run(x -> v.set(x));
            beanStore.createMethodFinder(DebugEnablement.class).addBean(DebugEnablement.Builder.class, v.get()).find("createDebugEnablement", new Class[0]).run(x -> ((DebugEnablement.Builder)v.get()).impl((DebugEnablement)x));
            return (DebugEnablement.Builder)v.get();
        }

        public MethodList startCallMethods() {
            if (this.startCallMethods == null) {
                this.startCallMethods = this.createStartCallMethods(this.beanStore(), this.resource());
            }
            return this.startCallMethods;
        }

        public Builder startCallMethods(Consumer<MethodList> operation) {
            operation.accept(this.startCallMethods());
            return this;
        }

        protected MethodList createStartCallMethods(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)Builder.getHookMethods(resource, HookEvent.START_CALL));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, v.get()).find("createStartCallMethods", new Class[0]).run(x -> v.set(x));
            return (MethodList)v.get();
        }

        public MethodList endCallMethods() {
            if (this.endCallMethods == null) {
                this.endCallMethods = this.createEndCallMethods(this.beanStore(), this.resource());
            }
            return this.endCallMethods;
        }

        public Builder endCallMethods(Consumer<MethodList> operation) {
            operation.accept(this.endCallMethods());
            return this;
        }

        protected MethodList createEndCallMethods(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)Builder.getHookMethods(resource, HookEvent.END_CALL));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, v.get()).find("createEndCallMethods", new Class[0]).run(x -> v.set(x));
            return (MethodList)v.get();
        }

        public MethodList postInitMethods() {
            if (this.postInitMethods == null) {
                this.postInitMethods = this.createPostInitMethods(this.beanStore(), this.resource());
            }
            return this.postInitMethods;
        }

        public Builder postInitMethods(Consumer<MethodList> operation) {
            operation.accept(this.postInitMethods());
            return this;
        }

        protected MethodList createPostInitMethods(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)Builder.getHookMethods(resource, HookEvent.POST_INIT));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, v.get()).find("createPostInitMethods", new Class[0]).run(x -> v.set(x));
            return (MethodList)v.get();
        }

        public MethodList postInitChildFirstMethods() {
            if (this.postInitChildFirstMethods == null) {
                this.postInitChildFirstMethods = this.createPostInitChildFirstMethods(this.beanStore(), this.resource());
            }
            return this.postInitChildFirstMethods;
        }

        public Builder postInitChildFirstMethods(Consumer<MethodList> operation) {
            operation.accept(this.postInitChildFirstMethods());
            return this;
        }

        protected MethodList createPostInitChildFirstMethods(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)Builder.getHookMethods(resource, HookEvent.POST_INIT_CHILD_FIRST));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, v.get()).find("createPostInitChildFirstMethods", new Class[0]).run(x -> v.set(x));
            return (MethodList)v.get();
        }

        public MethodList destroyMethods() {
            if (this.destroyMethods == null) {
                this.destroyMethods = this.createDestroyMethods(this.beanStore(), this.resource());
            }
            return this.destroyMethods;
        }

        public Builder destroyMethods(Consumer<MethodList> operation) {
            operation.accept(this.destroyMethods());
            return this;
        }

        protected MethodList createDestroyMethods(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)Builder.getHookMethods(resource, HookEvent.DESTROY));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, v.get()).find("createDestroyMethods", new Class[0]).run(x -> v.set(x));
            return (MethodList)v.get();
        }

        public MethodList preCallMethods() {
            if (this.preCallMethods == null) {
                this.preCallMethods = this.createPreCallMethods(this.beanStore(), this.resource());
            }
            return this.preCallMethods;
        }

        public Builder preCallMethods(Consumer<MethodList> operation) {
            operation.accept(this.preCallMethods());
            return this;
        }

        protected MethodList createPreCallMethods(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)Builder.getHookMethods(resource, HookEvent.PRE_CALL));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, v.get()).find("createPreCallMethods", new Class[0]).run(x -> v.set(x));
            return (MethodList)v.get();
        }

        public MethodList postCallMethods() {
            if (this.postCallMethods == null) {
                this.postCallMethods = this.createPostCallMethods(this.beanStore(), this.resource());
            }
            return this.postCallMethods;
        }

        public Builder postCallMethods(Consumer<MethodList> operation) {
            operation.accept(this.postCallMethods());
            return this;
        }

        protected MethodList createPostCallMethods(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)Builder.getHookMethods(resource, HookEvent.POST_CALL));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, v.get()).find("createPostCallMethods", new Class[0]).run(x -> v.set(x));
            return (MethodList)v.get();
        }

        public RestOperations.Builder restOperations(RestContext restContext) throws ServletException {
            if (this.restOperations == null) {
                this.restOperations = this.createRestOperations(this.beanStore(), this.resource(), restContext);
            }
            return this.restOperations;
        }

        protected RestOperations.Builder createRestOperations(BeanStore beanStore, Supplier<?> resource, RestContext restContext) throws ServletException {
            Value v = Value.of((Object)((Object)RestOperations.create(beanStore)));
            ClassInfo rci = ClassInfo.of(resource.get());
            LinkedHashMap initMap = CollectionUtils.map();
            ClassInfo.ofProxy(resource.get()).forEachAllMethodParentFirst(y -> y.hasAnnotation(RestHook.class) && ((RestHook)y.getAnnotation(RestHook.class)).value() == HookEvent.INIT && y.hasArg(RestOpContext.Builder.class), y -> {
                String sig = y.getSignature();
                if (!initMap.containsKey(sig)) {
                    initMap.put(sig, y.accessible());
                }
            });
            for (MethodInfo mi : rci.getPublicMethods()) {
                AnnotationList al = mi.getAnnotationList(RestOpAnnotation.REST_OP_GROUP);
                if (al.size() == 0) {
                    Predicate<MethodInfo> isRestAnnotatedInterface = x -> x.getDeclaringClass().isInterface() && x.getDeclaringClass().getAnnotation(Rest.class) != null;
                    mi.forEachMatching(isRestAnnotatedInterface, x -> al.add((Object)AnnotationInfo.of((MethodInfo)x, (Annotation)RestOpAnnotation.DEFAULT)));
                }
                if (al.size() <= 0) continue;
                try {
                    if (mi.isNotPublic()) {
                        throw RestContext.servletException("@RestOp method {0}.{1} must be defined as public.", rci.inner().getName(), mi.getSimpleName());
                    }
                    Context.Builder rocb = RestOpContext.create(mi.inner(), restContext).beanStore(beanStore).type(this.opContextClass);
                    beanStore = BeanStore.of((BeanStore)beanStore, resource.get()).addBean(RestOpContext.Builder.class, (Object)rocb);
                    for (MethodInfo m : initMap.values()) {
                        if (!beanStore.hasAllParams((ExecutableInfo)m)) {
                            throw RestContext.servletException("Could not call @RestHook(INIT) method {0}.{1}.  Could not find prerequisites: {2}.", m.getDeclaringClass().getSimpleName(), m.getSignature(), beanStore.getMissingParams((ExecutableInfo)m));
                        }
                        try {
                            m.invoke(resource.get(), beanStore.getParams((ExecutableInfo)m));
                        }
                        catch (Exception e) {
                            throw RestContext.servletException(e, "Exception thrown from @RestHook(INIT) method {0}.{1}.", m.getDeclaringClass().getSimpleName(), m.getSignature());
                        }
                    }
                    RestOpContext roc = rocb.build();
                    String httpMethod = roc.getHttpMethod();
                    if ("RRPC".equals(httpMethod)) {
                        RestOpContext roc2 = RestOpContext.create(mi.inner(), restContext).dotAll().beanStore(restContext.getRootBeanStore()).type(RrpcRestOpContext.class).build();
                        ((RestOperations.Builder)((Object)v.get())).add("GET", roc2).add("POST", roc2);
                        continue;
                    }
                    ((RestOperations.Builder)((Object)v.get())).add(roc);
                }
                catch (Throwable e) {
                    throw RestContext.servletException(e, "Problem occurred trying to initialize methods on class {0}", rci.inner().getName());
                }
            }
            beanStore.createMethodFinder(RestOperations.Builder.class).addBean(RestOperations.Builder.class, v.get()).find("createRestOperations", new Class[0]).run(x -> v.set((Object)x));
            beanStore.createMethodFinder(RestOperations.class).addBean(RestOperations.Builder.class, v.get()).find("createRestOperations", new Class[0]).run(x -> ((RestOperations.Builder)((Object)((Object)v.get()))).impl(x));
            return (RestOperations.Builder)((Object)v.get());
        }

        public RestChildren.Builder restChildren(RestContext restContext) throws Exception {
            if (this.restChildren == null) {
                this.restChildren = this.createRestChildren(this.beanStore(), this.resource(), restContext);
            }
            return this.restChildren;
        }

        protected RestChildren.Builder createRestChildren(BeanStore beanStore, Supplier<?> resource, RestContext restContext) throws Exception {
            Value v = Value.of((Object)RestChildren.create(beanStore).type((Class)this.childrenClass));
            for (Object o : this.children) {
                Supplier<Object> so;
                String path = null;
                if (o instanceof RestChild) {
                    RestChild rc = (RestChild)o;
                    path = rc.path;
                    Object o2 = rc.resource;
                    Supplier<Object> supplier = () -> o2;
                }
                Builder cb = null;
                if (o instanceof Class) {
                    Class oc = (Class)o;
                    if (oc == this.resourceClass) continue;
                    cb = RestContext.create(oc, restContext, this.inner);
                    if (beanStore.getBean(oc).isPresent()) {
                        so = () -> beanStore.getBean(oc).get();
                    } else {
                        Object o2 = beanStore.createBean(oc).builder(Builder.class, (Object)cb).run();
                        so = () -> o2;
                    }
                } else {
                    cb = RestContext.create(o.getClass(), restContext, this.inner);
                    so = () -> o;
                }
                if (path != null) {
                    cb.path(path);
                }
                RestContext cc = cb.init(so).build();
                MethodInfo mi = ClassInfo.of((Object)so.get()).getMethod(x -> x.hasName("setContext") && x.hasParamTypes(new Class[]{RestContext.class}));
                if (mi != null) {
                    mi.accessible().invoke(so.get(), new Object[]{cc});
                }
                ((RestChildren.Builder)((Object)v.get())).add(cc);
            }
            beanStore.createMethodFinder(RestChildren.Builder.class).addBean(RestChildren.Builder.class, v.get()).find("createRestChildren", new Class[0]).run(x -> v.set((Object)x));
            beanStore.createMethodFinder(RestChildren.class).addBean(RestChildren.Builder.class, v.get()).find("createRestChildren", new Class[0]).run(x -> ((RestChildren.Builder)((Object)((Object)v.get()))).impl(x));
            return (RestChildren.Builder)((Object)v.get());
        }

        public SwaggerProvider.Builder swaggerProvider() {
            if (this.swaggerProvider == null) {
                this.swaggerProvider = this.createSwaggerProvider(this.beanStore(), this.resource());
            }
            return this.swaggerProvider;
        }

        public Builder swaggerProvider(Consumer<SwaggerProvider.Builder> operation) {
            operation.accept(this.swaggerProvider());
            return this;
        }

        protected SwaggerProvider.Builder createSwaggerProvider(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)SwaggerProvider.create(beanStore).varResolver(() -> (VarResolver)beanStore.getBean(VarResolver.class).orElseThrow(() -> ThrowableUtils.runtimeException((String)"VarResolver bean not found.", (Object[])new Object[0]))).fileFinder(() -> (FileFinder)beanStore.getBean(FileFinder.class).orElseThrow(() -> ThrowableUtils.runtimeException((String)"FileFinder bean not found.", (Object[])new Object[0]))).messages(() -> (Messages)beanStore.getBean(Messages.class).orElseThrow(() -> ThrowableUtils.runtimeException((String)"Messages bean not found.", (Object[])new Object[0]))).jsonSchemaGenerator(() -> (JsonSchemaGenerator)beanStore.getBean(JsonSchemaGenerator.class).orElseThrow(() -> ThrowableUtils.runtimeException((String)"JsonSchemaGenerator bean not found.", (Object[])new Object[0]))));
            this.rootBeanStore.getBean(SwaggerProvider.class).ifPresent(x -> ((SwaggerProvider.Builder)v.get()).impl((SwaggerProvider)x));
            this.resourceAs(SwaggerProvider.class).ifPresent(x -> ((SwaggerProvider.Builder)v.get()).impl((SwaggerProvider)x));
            beanStore.createMethodFinder(SwaggerProvider.Builder.class).addBean(SwaggerProvider.Builder.class, v.get()).find("createSwaggerProvider", new Class[0]).run(x -> v.set(x));
            beanStore.createMethodFinder(SwaggerProvider.class).addBean(SwaggerProvider.Builder.class, v.get()).find("createSwaggerProvider", new Class[0]).run(x -> ((SwaggerProvider.Builder)v.get()).impl((SwaggerProvider)x));
            return (SwaggerProvider.Builder)v.get();
        }

        @FluentSetter
        public Builder allowedHeaderParams(String value) {
            this.allowedHeaderParams = value;
            return this;
        }

        @FluentSetter
        public Builder allowedMethodHeaders(String value) {
            this.allowedMethodHeaders = value;
            return this;
        }

        @FluentSetter
        public Builder allowedMethodParams(String value) {
            this.allowedMethodParams = value;
            return this;
        }

        @FluentSetter
        public Builder clientVersionHeader(String value) {
            this.clientVersionHeader = value;
            return this;
        }

        @FluentSetter
        public Builder defaultCharset(Charset value) {
            this.defaultCharset = value;
            return this;
        }

        @FluentSetter
        public Builder disableContentParam() {
            return this.disableContentParam(true);
        }

        @FluentSetter
        public Builder disableContentParam(boolean value) {
            this.disableContentParam = value;
            return this;
        }

        @FluentSetter
        public Builder maxInput(String value) {
            this.maxInput = StringUtils.parseLongWithSuffix((String)value);
            return this;
        }

        @FluentSetter
        public Builder renderResponseStackTraces(boolean value) {
            this.renderResponseStackTraces = value;
            return this;
        }

        @FluentSetter
        public Builder renderResponseStackTraces() {
            this.renderResponseStackTraces = true;
            return this;
        }

        @FluentSetter
        public Builder uriAuthority(String value) {
            this.uriAuthority = value;
            return this;
        }

        @FluentSetter
        public Builder uriContext(String value) {
            this.uriContext = value;
            return this;
        }

        @FluentSetter
        public Builder uriRelativity(UriRelativity value) {
            this.uriRelativity = value;
            return this;
        }

        @FluentSetter
        public Builder uriResolution(UriResolution value) {
            this.uriResolution = value;
            return this;
        }

        public SerializerSet.Builder getSerializers() {
            return this.serializers;
        }

        public ParserSet.Builder getParsers() {
            return this.parsers;
        }

        public EncoderSet.Builder getEncoders() {
            return this.encoders;
        }

        @FluentSetter
        public Builder children(Object ... values) {
            CollectionUtils.addAll(this.children, (Object[])values);
            return this;
        }

        @FluentSetter
        public Builder child(String path, Object child) {
            this.children.add(new RestChild(path, child));
            return this;
        }

        @FluentSetter
        public Builder parserListener(Class<? extends ParserListener> value) {
            if (ClassUtils.isNotVoid(value)) {
                this.parsers.forEach(x -> x.listener(value));
            }
            return this;
        }

        @FluentSetter
        public Builder path(String value) {
            if (!StringUtils.isEmpty((String)(value = StringUtils.trimLeadingSlashes((String)value)))) {
                this.path = value;
            }
            return this;
        }

        @FluentSetter
        public Builder restChildrenClass(Class<? extends RestChildren> value) {
            this.childrenClass = value;
            return this;
        }

        @FluentSetter
        public Builder restOpContextClass(Class<? extends RestOpContext> value) {
            this.opContextClass = value;
            return this;
        }

        @FluentSetter
        public Builder restOperationsClass(Class<? extends RestOperations> value) {
            this.operationsClass = value;
            return this;
        }

        @FluentSetter
        public Builder serializerListener(Class<? extends SerializerListener> value) {
            if (ClassUtils.isNotVoid(value)) {
                this.serializers.forEach(x -> x.listener(value));
            }
            return this;
        }

        @FluentSetter
        public Builder produces(MediaType ... values) {
            this.produces = CollectionUtils.addAll(this.produces, (Object[])values);
            return this;
        }

        public Optional<List<MediaType>> produces() {
            return CollectionUtils.optional(this.produces);
        }

        @FluentSetter
        public Builder consumes(MediaType ... values) {
            this.consumes = CollectionUtils.addAll(this.consumes, (Object[])values);
            return this;
        }

        public Optional<List<MediaType>> consumes() {
            return CollectionUtils.optional(this.consumes);
        }

        @FluentSetter
        public Builder swaggerProvider(Class<? extends SwaggerProvider> value) {
            this.swaggerProvider().type(value);
            return this;
        }

        @FluentSetter
        public Builder swaggerProvider(SwaggerProvider value) {
            this.swaggerProvider().impl(value);
            return this;
        }

        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        public Builder applyAnnotations(Class<?> ... fromClasses) {
            super.applyAnnotations((Class[])fromClasses);
            return this;
        }

        public Builder applyAnnotations(Method ... fromMethods) {
            super.applyAnnotations(fromMethods);
            return this;
        }

        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache(value);
            return this;
        }

        public Builder debug() {
            super.debug();
            return this;
        }

        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<? extends Context> value) {
            super.type(value);
            return this;
        }

        private static MethodList getHookMethods(Supplier<?> resource, HookEvent event) {
            LinkedHashMap x = CollectionUtils.map();
            Object r = resource.get();
            ClassInfo.ofProxy(r).forEachAllMethodParentFirst(y -> y.hasAnnotation(RestHook.class), y -> y.forEachAnnotation(RestHook.class, z -> z.value() == event, z -> x.put(y.getSignature(), y.accessible().inner())));
            MethodList x2 = MethodList.of(x.values());
            return x2;
        }

        public String getInitParameter(String name) {
            return this.inner == null ? null : this.inner.getInitParameter(name);
        }

        public Enumeration<String> getInitParameterNames() {
            return this.inner == null ? new Vector().elements() : this.inner.getInitParameterNames();
        }

        public ServletContext getServletContext() {
            return this.inner != null ? this.inner.getServletContext() : (this.parentContext != null ? this.parentContext.getBuilder().getServletContext() : null);
        }

        public String getServletName() {
            return this.inner == null ? null : this.inner.getServletName();
        }

        public static final class Void
        extends Builder {
            private Void(Class<?> resourceClass, RestContext parentContext, ServletConfig servletConfig) {
                super(resourceClass, parentContext, servletConfig);
            }
        }
    }

    public static final class Void
    extends RestContext {
        private Void(Builder builder) throws Exception {
            super(builder);
        }
    }
}

