/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.response;

import org.apache.http.HttpResponse;
import org.apache.juneau.http.BasicStatusLine;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.Schema;
import org.apache.juneau.http.annotation.StatusCode;
import org.apache.juneau.http.response.BasicHttpException;
import org.apache.juneau.http.response.HttpExceptionBuilder;

@Response
@StatusCode(value={400})
@Schema(description={"Bad Request"})
public class BadRequest
extends BasicHttpException {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_CODE = 400;
    public static final String REASON_PHRASE = "Bad Request";
    private static final BasicStatusLine STATUS_LINE = BasicStatusLine.create().statusCode(400).reasonPhrase("Bad Request").build();
    public static final BadRequest INSTANCE = (BadRequest)((HttpExceptionBuilder)BadRequest.create().unmodifiable()).build();

    public static HttpExceptionBuilder<BadRequest> create() {
        return new HttpExceptionBuilder<Class<BadRequest>>(BadRequest.class).statusLine(STATUS_LINE);
    }

    public BadRequest(HttpExceptionBuilder<?> builder) {
        super(builder);
    }

    public BadRequest(Throwable cause, String msg, Object ... args) {
        this((HttpExceptionBuilder<?>)((HttpExceptionBuilder)BadRequest.create().causedBy(cause)).message(msg, args));
    }

    public BadRequest() {
        this(BadRequest.create());
    }

    public BadRequest(String msg, Object ... args) {
        this((HttpExceptionBuilder<?>)BadRequest.create().message(msg, args));
    }

    public BadRequest(Throwable cause) {
        this((HttpExceptionBuilder<?>)BadRequest.create().causedBy(cause));
    }

    public BadRequest(HttpResponse response) {
        this(BadRequest.create().copyFrom(response));
        this.assertStatusCode(response);
    }

    public HttpExceptionBuilder<BadRequest> copy() {
        return new HttpExceptionBuilder<BadRequest>(this);
    }
}

