/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.annotation;

import org.apache.juneau.annotation.AnnotationBuilder;
import org.apache.juneau.annotation.AnnotationImpl;
import org.apache.juneau.http.annotation.ExternalDocs;
import org.apache.juneau.http.annotation.ExternalDocsAnnotation;
import org.apache.juneau.http.annotation.Tag;
import org.apache.juneau.internal.ArrayUtils;

public class TagAnnotation {
    public static final Tag DEFAULT = TagAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    private static class Impl
    extends AnnotationImpl
    implements Tag {
        private final ExternalDocs externalDocs;
        private final String name;
        private final String[] description;

        Impl(Builder b) {
            super(b);
            this.description = ArrayUtils.copyOf(b.description);
            this.externalDocs = b.externalDocs;
            this.name = b.name;
            this.postConstruct();
        }

        @Override
        public String[] description() {
            return this.description;
        }

        @Override
        public ExternalDocs externalDocs() {
            return this.externalDocs;
        }

        @Override
        public String name() {
            return this.name;
        }
    }

    public static class Builder
    extends AnnotationBuilder {
        ExternalDocs externalDocs = ExternalDocsAnnotation.DEFAULT;
        String name = "";
        String[] description = new String[0];

        protected Builder() {
            super(Tag.class);
        }

        public Tag build() {
            return new Impl(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder externalDocs(ExternalDocs value) {
            this.externalDocs = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }
    }
}

