/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.Value;
import org.apache.juneau.annotation.TargetedAnnotationTImpl;
import org.apache.juneau.annotation.TargetedAnnotationTMFBuilder;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Schema;
import org.apache.juneau.http.annotation.SchemaAnnotation;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.svl.VarResolverSession;

public class FormDataAnnotation {
    public static final FormData DEFAULT = FormDataAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return FormDataAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return FormDataAnnotation.create().on(on);
    }

    public static boolean empty(FormData a) {
        return a == null || DEFAULT.equals(a);
    }

    public static Value<String> findName(ParamInfo pi) {
        Value<String> n = Value.empty();
        pi.forEachAnnotation(FormData.class, x -> StringUtils.isNotEmpty(x.value()), x -> n.set(x.value()));
        pi.forEachAnnotation(FormData.class, x -> StringUtils.isNotEmpty(x.name()), x -> n.set(x.name()));
        return n;
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public FormData[] value();
    }

    public static class Applier
    extends AnnotationApplier<FormData, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(FormData.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<FormData> ai, BeanContext.Builder b) {
            FormData a = ai.inner();
            if (ArrayUtils.isEmptyArray(a.on(), a.onClass())) {
                return;
            }
            b.annotations(a);
        }
    }

    private static class Impl
    extends TargetedAnnotationTImpl
    implements FormData {
        private final Class<? extends HttpPartParser> parser;
        private final Class<? extends HttpPartSerializer> serializer;
        private final String name;
        private final String value;
        private final Schema schema;

        Impl(Builder b) {
            super(b);
            this.name = b.name;
            this.parser = b.parser;
            this.schema = b.schema;
            this.serializer = b.serializer;
            this.value = b.value;
            this.postConstruct();
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Class<? extends HttpPartParser> parser() {
            return this.parser;
        }

        @Override
        public Schema schema() {
            return this.schema;
        }

        @Override
        public Class<? extends HttpPartSerializer> serializer() {
            return this.serializer;
        }

        @Override
        public String value() {
            return this.value;
        }
    }

    public static class Builder
    extends TargetedAnnotationTMFBuilder {
        Class<? extends HttpPartParser> parser = HttpPartParser.Void.class;
        Class<? extends HttpPartSerializer> serializer = HttpPartSerializer.Void.class;
        Schema schema = SchemaAnnotation.DEFAULT;
        String name = "";
        String value = "";

        protected Builder() {
            super(FormData.class);
        }

        public FormData build() {
            return new Impl(this);
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder parser(Class<? extends HttpPartParser> value) {
            this.parser = value;
            return this;
        }

        public Builder schema(Schema value) {
            this.schema = value;
            return this;
        }

        public Builder serializer(Class<? extends HttpPartSerializer> value) {
            this.serializer = value;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        @Override
        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }
    }
}

