/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.TargetedAnnotationTImpl;
import org.apache.juneau.annotation.TargetedAnnotationTMFCBuilder;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class BeanIgnoreAnnotation {
    public static final BeanIgnore DEFAULT = BeanIgnoreAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return BeanIgnoreAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return BeanIgnoreAnnotation.create().on(on);
    }

    public static BeanIgnore copy(BeanIgnore a, VarResolverSession r) {
        return ((Builder)BeanIgnoreAnnotation.create().on(r.resolve(a.on())).onClass((Class[])a.onClass())).build();
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public BeanIgnore[] value();
    }

    public static class Applier
    extends AnnotationApplier<BeanIgnore, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(BeanIgnore.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<BeanIgnore> ai, BeanContext.Builder b) {
            BeanIgnore a = ai.inner();
            if (ArrayUtils.isEmptyArray(a.on(), a.onClass())) {
                return;
            }
            b.annotations(BeanIgnoreAnnotation.copy(a, this.vr()));
        }
    }

    private static class Impl
    extends TargetedAnnotationTImpl
    implements BeanIgnore {
        Impl(Builder b) {
            super(b);
            this.postConstruct();
        }
    }

    public static class Builder
    extends TargetedAnnotationTMFCBuilder {
        protected Builder() {
            super(BeanIgnore.class);
        }

        public BeanIgnore build() {
            return new Impl(this);
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        @Override
        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Constructor<?> ... value) {
            super.on(value);
            return this;
        }
    }
}

