/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.jaxrs;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.http.header.StringRanges;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserMatch;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ParserSet;
import org.apache.juneau.rest.jaxrs.JuneauProvider;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerMatch;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.SerializerSet;

public class BaseProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private SerializerSet serializers;
    private ParserSet parsers;

    protected BaseProvider() {
        try {
            JuneauProvider jp = this.getClass().getAnnotation(JuneauProvider.class);
            this.serializers = (SerializerSet)SerializerSet.create().add((Class[])jp.serializers()).forEach(x -> x.swaps((Class[])jp.swaps())).build();
            this.parsers = (ParserSet)ParserSet.create().add((Class[])jp.parsers()).forEach(x -> x.swaps((Class[])jp.swaps())).build();
        }
        catch (Exception e) {
            throw ThrowableUtils.runtimeException((Throwable)e);
        }
    }

    public long getSize(Object o, Class<?> type, Type gType, Annotation[] a, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type gType, Annotation[] a, MediaType mediaType) {
        return this.serializers.getSerializerMatch(mediaType.toString()) != null;
    }

    public void writeTo(Object o, Class<?> type, Type gType, Annotation[] a, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        try {
            SerializerMatch sm = this.serializers.getSerializerMatch(mediaType.toString());
            if (sm == null) {
                throw new WebApplicationException(406);
            }
            Serializer s = sm.getSerializer();
            JsonMap m = JsonMap.create();
            m.append("mediaType", (Object)mediaType.toString());
            Locale locale = BaseProvider.getLocale(headers);
            TimeZone timeZone = BaseProvider.getTimeZone(headers);
            SerializerSession session = s.createSession().properties((Map)m).locale(locale).timeZone(timeZone).mediaType(sm.getMediaType()).build();
            Closeable c = s.isWriterSerializer() ? new OutputStreamWriter(os, IOUtils.UTF8) : os;
            session.serialize(o, (Object)c);
        }
        catch (SerializeException e) {
            throw ThrowableUtils.ioException((Throwable)e);
        }
    }

    public boolean isReadable(Class<?> type, Type gType, Annotation[] a, MediaType mediaType) {
        return this.parsers.getParserMatch(mediaType.toString()) != null;
    }

    public Object readFrom(Class<Object> type, Type gType, Annotation[] a, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream in) throws IOException, WebApplicationException {
        try {
            ParserMatch pm = this.parsers.getParserMatch(mediaType.toString());
            if (pm == null) {
                throw new WebApplicationException(415);
            }
            Parser p = pm.getParser();
            JsonMap m = JsonMap.create();
            m.put("mediaType", (Object)mediaType.toString());
            Locale locale = BaseProvider.getLocale(headers);
            TimeZone timeZone = BaseProvider.getTimeZone(headers);
            ParserSession session = p.createSession().properties((Map)m).locale(locale).timeZone(timeZone).mediaType(pm.getMediaType()).build();
            Closeable in2 = session.isReaderParser() ? new InputStreamReader(in, IOUtils.UTF8) : in;
            return session.parse((Object)in2, p.getBeanContext().getClassMeta(gType, new Type[0]));
        }
        catch (ParseException e) {
            throw ThrowableUtils.ioException((Throwable)e);
        }
    }

    private static Locale getLocale(MultivaluedMap headers) {
        StringRanges mr;
        String h;
        if (headers.containsKey((Object)"Accept-Language") && headers.get((Object)"Accept-Language") != null && (h = String.valueOf(headers.get((Object)"Accept-Language"))) != null && !(mr = StringRanges.of((String)h)).toList().isEmpty()) {
            return BaseProvider.toLocale(mr.getRange(0).getName());
        }
        return null;
    }

    private static Locale toLocale(String lang) {
        String country = "";
        int i = lang.indexOf(45);
        if (i > -1) {
            country = lang.substring(i + 1).trim();
            lang = lang.substring(0, i).trim();
        }
        return new Locale(lang, country);
    }

    private static TimeZone getTimeZone(MultivaluedMap headers) {
        if (headers.containsKey((Object)"Time-Zone") && headers.get((Object)"Time-Zone") != null) {
            String h = String.valueOf(headers.get((Object)"Time-Zone"));
            return TimeZone.getTimeZone(h);
        }
        return null;
    }
}

