/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflect;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.AnnotationProvider;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.Value;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConsumerUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ExecutableInfo;
import org.apache.juneau.reflect.ParamInfo;

@FluentSetters
public final class MethodInfo
extends ExecutableInfo
implements Comparable<MethodInfo> {
    private final Method m;
    private volatile ClassInfo returnType;
    private volatile MethodInfo[] matching;

    public static MethodInfo of(ClassInfo declaringClass, Method m) {
        if (m == null) {
            return null;
        }
        return declaringClass.getMethodInfo(m);
    }

    public static MethodInfo of(Class<?> declaringClass, Method m) {
        if (m == null) {
            return null;
        }
        return ClassInfo.of(declaringClass).getMethodInfo(m);
    }

    public static MethodInfo of(Method m) {
        if (m == null) {
            return null;
        }
        return ClassInfo.of(m.getDeclaringClass()).getMethodInfo(m);
    }

    protected MethodInfo(ClassInfo declaringClass, Method m) {
        super(declaringClass, m);
        this.m = m;
    }

    public Method inner() {
        return this.m;
    }

    public boolean canAccept(Object ... args) {
        Class<?>[] pt = this.m.getParameterTypes();
        if (pt.length != args.length) {
            return false;
        }
        for (int i = 0; i < pt.length; ++i) {
            if (pt[i].isInstance(args[i])) continue;
            return false;
        }
        return true;
    }

    public int canAcceptFuzzy(Object ... args) {
        int matches = 0;
        block0: for (ClassInfo pi : this._getParameterTypes()) {
            for (Object a : args) {
                if (!pi.canAcceptArg(a)) continue;
                ++matches;
                continue block0;
            }
            return -1;
        }
        return matches;
    }

    public MethodInfo forEachMatching(Predicate<MethodInfo> filter, Consumer<MethodInfo> action) {
        for (MethodInfo m : this._getMatching()) {
            ConsumerUtils.consume(filter, action, m);
        }
        return this;
    }

    public MethodInfo forEachMatchingParentFirst(Predicate<MethodInfo> filter, Consumer<MethodInfo> action) {
        MethodInfo[] m = this._getMatching();
        for (int i = m.length - 1; i >= 0; --i) {
            ConsumerUtils.consume(filter, action, m[i]);
        }
        return this;
    }

    private static List<MethodInfo> findMatching(List<MethodInfo> l, MethodInfo m, ClassInfo c) {
        for (MethodInfo m2 : c._getDeclaredMethods()) {
            if (!m.hasName(m2.getName()) || !Arrays.equals(m._getParameterTypes(), m2._getParameterTypes())) continue;
            l.add(m2);
        }
        ClassInfo pc = c.getSuperclass();
        if (pc != null) {
            MethodInfo.findMatching(l, m, pc);
        }
        for (ClassInfo ic : c._getDeclaredInterfaces()) {
            MethodInfo.findMatching(l, m, ic);
        }
        return l;
    }

    private MethodInfo findMatchingOnClass(ClassInfo c) {
        for (MethodInfo m2 : c._getDeclaredMethods()) {
            if (!this.hasName(m2.getName()) || !Arrays.equals(this._getParameterTypes(), m2._getParameterTypes())) continue;
            return m2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MethodInfo[] _getMatching() {
        if (this.matching == null) {
            MethodInfo methodInfo = this;
            synchronized (methodInfo) {
                List<MethodInfo> l = MethodInfo.findMatching(CollectionUtils.list(new MethodInfo[0]), this, this.getDeclaringClass());
                this.matching = l.toArray(new MethodInfo[l.size()]);
            }
        }
        return this.matching;
    }

    public final <A extends Annotation> A getAnnotation(Class<A> type) {
        return this.getAnnotation(AnnotationProvider.DEFAULT, type);
    }

    public final <A extends Annotation> A getAnnotation(AnnotationProvider annotationProvider, Class<A> type) {
        if (type == null) {
            return null;
        }
        Value t = Value.empty();
        for (MethodInfo m2 : this._getMatching()) {
            annotationProvider.forEachAnnotation(type, m2.inner(), (A x) -> true, (A x) -> t.set(x));
            if (!t.isPresent()) continue;
            return (A)((Annotation)t.get());
        }
        return null;
    }

    public final <A extends Annotation> boolean hasAnnotation(Class<A> type) {
        return this.hasAnnotation(AnnotationProvider.DEFAULT, type);
    }

    public final <A extends Annotation> boolean hasAnnotation(AnnotationProvider annotationProvider, Class<A> type) {
        for (MethodInfo m2 : this._getMatching()) {
            if (annotationProvider.firstAnnotation(type, m2.inner(), x -> true) == null) continue;
            return true;
        }
        return false;
    }

    public final <A extends Annotation> boolean hasNoAnnotation(AnnotationProvider annotationProvider, Class<A> type) {
        return !this.hasAnnotation(annotationProvider, type);
    }

    public final <A extends Annotation> boolean hasNoAnnotation(Class<A> type) {
        return this.getAnnotation(type) == null;
    }

    @SafeVarargs
    public final boolean hasAnyAnnotations(Class<? extends Annotation> ... types) {
        for (Class<? extends Annotation> a : types) {
            if (!this.hasAnnotation(a)) continue;
            return true;
        }
        return false;
    }

    public <A extends Annotation> MethodInfo forEachAnnotation(Class<A> type, Predicate<A> filter, Consumer<A> action) {
        return this.forEachAnnotation(AnnotationProvider.DEFAULT, type, filter, action);
    }

    public <A extends Annotation> MethodInfo forEachAnnotation(AnnotationProvider annotationProvider, Class<A> type, Predicate<A> filter, Consumer<A> action) {
        this.declaringClass.forEachAnnotation(annotationProvider, type, filter, action);
        MethodInfo[] m = this._getMatching();
        for (int i = m.length - 1; i >= 0; --i) {
            for (Annotation a2 : m[i]._getDeclaredAnnotations()) {
                ConsumerUtils.consume(type, filter, action, a2);
            }
        }
        this.getReturnType().unwrap(Value.class, Optional.class).forEachAnnotation(annotationProvider, type, filter, action);
        return this;
    }

    @SafeVarargs
    public final Annotation getAnyAnnotation(Class<? extends Annotation> ... types) {
        for (Class<? extends Annotation> cc : types) {
            Annotation a = this.getAnnotation(cc);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    public AnnotationList getAnnotationList() {
        return this.getAnnotationList(x -> true);
    }

    public AnnotationList getAnnotationList(Predicate<AnnotationInfo<?>> filter) {
        AnnotationList al = new AnnotationList();
        this.forEachAnnotationInfo(filter, x -> al.add(x));
        return al;
    }

    public AnnotationList getAnnotationListMethodOnly(Predicate<AnnotationInfo<?>> filter) {
        AnnotationList al = new AnnotationList();
        this.forEachAnnotationInfoMethodOnly(filter, x -> al.add(x));
        return al;
    }

    public MethodInfo forEachAnnotationInfo(Predicate<AnnotationInfo<?>> filter, Consumer<AnnotationInfo<?>> action) {
        ClassInfo c = this.declaringClass;
        this.forEachDeclaredAnnotationInfo(c.getPackage(), filter, action);
        ClassInfo[] interfaces = c._getInterfaces();
        for (int i = interfaces.length - 1; i >= 0; --i) {
            this.forEachDeclaredAnnotationInfo(interfaces[i], filter, action);
            this.forEachDeclaredMethodAnnotationInfo(interfaces[i], filter, action);
        }
        ClassInfo[] parents = c._getParents();
        for (int i = parents.length - 1; i >= 0; --i) {
            this.forEachDeclaredAnnotationInfo(parents[i], filter, action);
            this.forEachDeclaredMethodAnnotationInfo(parents[i], filter, action);
        }
        return this;
    }

    private void forEachAnnotationInfoMethodOnly(Predicate<AnnotationInfo<?>> filter, Consumer<AnnotationInfo<?>> action) {
        ClassInfo c = this.declaringClass;
        ClassInfo[] interfaces = c._getInterfaces();
        for (int i = interfaces.length - 1; i >= 0; --i) {
            this.forEachDeclaredMethodAnnotationInfo(interfaces[i], filter, action);
        }
        ClassInfo[] parents = c._getParents();
        for (int i = parents.length - 1; i >= 0; --i) {
            this.forEachDeclaredMethodAnnotationInfo(parents[i], filter, action);
        }
    }

    private void forEachDeclaredAnnotationInfo(Package p, Predicate<AnnotationInfo<?>> filter, Consumer<AnnotationInfo<?>> action) {
        if (p != null) {
            for (Annotation a : p.getDeclaredAnnotations()) {
                AnnotationInfo.of(p, a).accept(filter, action);
            }
        }
    }

    private void forEachDeclaredAnnotationInfo(ClassInfo ci, Predicate<AnnotationInfo<?>> filter, Consumer<AnnotationInfo<?>> action) {
        if (ci != null) {
            for (Annotation a : ci._getDeclaredAnnotations()) {
                AnnotationInfo.of(ci, a).accept(filter, action);
            }
        }
    }

    private void forEachDeclaredMethodAnnotationInfo(ClassInfo ci, Predicate<AnnotationInfo<?>> filter, Consumer<AnnotationInfo<?>> action) {
        MethodInfo m = this.findMatchingOnClass(ci);
        if (m != null) {
            for (Annotation a : m._getDeclaredAnnotations()) {
                AnnotationInfo.of(m, a).accept(filter, action);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassInfo getReturnType() {
        if (this.returnType == null) {
            MethodInfo methodInfo = this;
            synchronized (methodInfo) {
                this.returnType = ClassInfo.of(this.m.getReturnType(), this.m.getGenericReturnType());
            }
        }
        return this.returnType;
    }

    public boolean hasReturnType(Class<?> c) {
        return this.m.getReturnType() == c;
    }

    public boolean hasReturnType(ClassInfo ci) {
        return this.hasReturnType(ci.inner());
    }

    public boolean hasReturnTypeParent(Class<?> c) {
        return ClassInfo.of(c).isParentOf(this.m.getReturnType());
    }

    public boolean hasReturnTypeParent(ClassInfo ci) {
        return this.hasReturnTypeParent(ci.inner());
    }

    public boolean matches(Predicate<MethodInfo> test) {
        return ConsumerUtils.test(test, this);
    }

    public MethodInfo accept(Predicate<MethodInfo> test, Consumer<MethodInfo> action) {
        if (this.matches(test)) {
            action.accept(this);
        }
        return this;
    }

    public <T> T invoke(Object obj, Object ... args) throws ExecutableException {
        try {
            return (T)this.m.invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            throw new ExecutableException(e);
        }
        catch (InvocationTargetException e) {
            throw new ExecutableException(e.getTargetException());
        }
    }

    public Object invokeFuzzy(Object pojo, Object ... args) throws ExecutableException {
        try {
            return this.m.invoke(pojo, ClassUtils.getMatchingArgs(this.m.getParameterTypes(), args));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ExecutableException(e);
        }
    }

    public String getSignature() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.m.getName());
        Class<?>[] pt = this._getRawParamTypes();
        if (pt.length > 0) {
            sb.append('(');
            List<ParamInfo> mpi = this.getParams();
            for (int i = 0; i < pt.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                mpi.get(i).getParameterType().appendFullName(sb);
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public String getPropertyName() {
        String n = this.m.getName();
        if ((n.startsWith("get") || n.startsWith("set")) && n.length() > 3) {
            return Introspector.decapitalize(n.substring(3));
        }
        if (n.startsWith("is") && n.length() > 2) {
            return Introspector.decapitalize(n.substring(2));
        }
        return n;
    }

    public boolean argsOnlyOfType(Class<?> ... args) {
        for (Class<?> c1 : this._getRawParamTypes()) {
            boolean foundMatch = false;
            for (Class<?> c2 : args) {
                if (c1 != c2) continue;
                foundMatch = true;
            }
            if (foundMatch) continue;
            return false;
        }
        return true;
    }

    public boolean hasAllArgs(Class<?> ... requiredParams) {
        List<Class<?>> rawParamTypes = this.getRawParamTypes();
        for (Class<?> c : requiredParams) {
            if (rawParamTypes.contains(c)) continue;
            return false;
        }
        return true;
    }

    public boolean hasArg(Class<?> requiredParam) {
        return this.hasAllArgs(requiredParam);
    }

    public boolean isBridge() {
        return this.m.isBridge();
    }

    public String getName() {
        return this.m.getName();
    }

    @Override
    public int compareTo(MethodInfo o) {
        int i = this.getSimpleName().compareTo(o.getSimpleName());
        if (i == 0 && (i = this._getRawParamTypes().length - o._getRawParamTypes().length) == 0) {
            for (int j = 0; j < this._getRawParamTypes().length && i == 0; ++j) {
                i = this._getRawParamTypes()[j].getName().compareTo(o._getRawParamTypes()[j].getName());
            }
        }
        return i;
    }

    @Override
    public MethodInfo accessible() {
        super.accessible();
        return this;
    }
}

