/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.http.NameValuePair;
import org.apache.http.util.CharArrayBuffer;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.ListOperation;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.http.part.BasicPart;
import org.apache.juneau.http.part.BasicPartIterator;
import org.apache.juneau.http.part.PartBeanMeta;
import org.apache.juneau.http.part.PartIterator;
import org.apache.juneau.internal.ArrayBuilder;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConsumerUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.svl.VarResolver;

public class PartList {
    private static final NameValuePair[] EMPTY_ARRAY = new NameValuePair[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Predicate<NameValuePair> NOT_NULL = x -> x != null;
    public static final PartList EMPTY = new PartList();
    final NameValuePair[] entries;
    final boolean caseInsensitive;

    public static Builder create() {
        return new Builder();
    }

    public static PartList of(List<NameValuePair> parts) {
        return parts == null || parts.isEmpty() ? EMPTY : new PartList(parts);
    }

    public static PartList of(NameValuePair ... parts) {
        return parts == null || parts.length == 0 ? EMPTY : new PartList(parts);
    }

    public static PartList ofPairs(Object ... pairs) {
        if (pairs == null || pairs.length == 0) {
            return EMPTY;
        }
        if (pairs.length % 2 != 0) {
            throw ThrowableUtils.runtimeException("Odd number of parameters passed into PartList.ofPairs()", new Object[0]);
        }
        ArrayBuilder<NameValuePair> b = ArrayBuilder.of(NameValuePair.class).filter(NOT_NULL).size(pairs.length / 2);
        for (int i = 0; i < pairs.length; i += 2) {
            b.add(BasicPart.of(StringUtils.stringify(pairs[i]), pairs[i + 1]));
        }
        return new PartList(b.orElse((NameValuePair[])EMPTY_ARRAY));
    }

    public PartList(Builder builder) {
        if (builder.defaultEntries == null) {
            this.entries = builder.entries.toArray(new NameValuePair[builder.entries.size()]);
        } else {
            ArrayBuilder<NameValuePair> l = ArrayBuilder.of(NameValuePair.class).filter(NOT_NULL).size(builder.entries.size() + builder.defaultEntries.size());
            int j = builder.entries.size();
            for (int i = 0; i < j; ++i) {
                l.add(builder.entries.get(i));
            }
            int j1 = builder.defaultEntries.size();
            for (int i1 = 0; i1 < j1; ++i1) {
                NameValuePair x = builder.defaultEntries.get(i1);
                boolean exists = false;
                int j2 = builder.entries.size();
                for (int i2 = 0; i2 < j2 && !exists; ++i2) {
                    exists = this.eq(builder.entries.get(i2).getName(), x.getName());
                }
                if (exists) continue;
                l.add(x);
            }
            this.entries = l.orElse((NameValuePair[])EMPTY_ARRAY);
        }
        this.caseInsensitive = builder.caseInsensitive;
    }

    protected PartList(List<NameValuePair> parts) {
        ArrayBuilder<NameValuePair> l = ArrayBuilder.of(NameValuePair.class).filter(NOT_NULL).size(parts.size());
        int j = parts.size();
        for (int i = 0; i < j; ++i) {
            l.add(parts.get(i));
        }
        this.entries = l.orElse((NameValuePair[])EMPTY_ARRAY);
        this.caseInsensitive = false;
    }

    protected PartList(NameValuePair ... parts) {
        ArrayBuilder<NameValuePair> l = ArrayBuilder.of(NameValuePair.class).filter(NOT_NULL).size(parts.length);
        for (int i = 0; i < parts.length; ++i) {
            l.add(parts[i]);
        }
        this.entries = l.orElse((NameValuePair[])EMPTY_ARRAY);
        this.caseInsensitive = false;
    }

    protected PartList() {
        this.entries = EMPTY_ARRAY;
        this.caseInsensitive = false;
    }

    public Builder copy() {
        return new Builder(this);
    }

    public Optional<NameValuePair> get(String name) {
        NameValuePair first = null;
        ArrayList<NameValuePair> rest = null;
        for (int i = 0; i < this.entries.length; ++i) {
            NameValuePair x = this.entries[i];
            if (!this.eq(x.getName(), name)) continue;
            if (first == null) {
                first = x;
                continue;
            }
            if (rest == null) {
                rest = CollectionUtils.list(new NameValuePair[0]);
            }
            rest.add(x);
        }
        if (first == null) {
            return CollectionUtils.empty();
        }
        if (rest == null) {
            return CollectionUtils.optional(first);
        }
        CharArrayBuffer sb = new CharArrayBuffer(128);
        sb.append(first.getValue());
        for (int i = 0; i < rest.size(); ++i) {
            sb.append(',');
            sb.append(((NameValuePair)rest.get(i)).getValue());
        }
        return CollectionUtils.optional(new BasicPart(name, sb.toString()));
    }

    public <T> Optional<T> get(String name, Class<T> type) {
        NameValuePair first = null;
        ArrayList<NameValuePair> rest = null;
        for (int i = 0; i < this.entries.length; ++i) {
            NameValuePair x = this.entries[i];
            if (!this.eq(x.getName(), name)) continue;
            if (first == null) {
                first = x;
                continue;
            }
            if (rest == null) {
                rest = CollectionUtils.list(new NameValuePair[0]);
            }
            rest.add(x);
        }
        if (first == null) {
            return CollectionUtils.empty();
        }
        if (rest == null) {
            return CollectionUtils.optional(PartBeanMeta.of(type).construct(name, first.getValue()));
        }
        CharArrayBuffer sb = new CharArrayBuffer(128);
        sb.append(first.getValue());
        for (int i = 0; i < rest.size(); ++i) {
            sb.append(',');
            sb.append(((NameValuePair)rest.get(i)).getValue());
        }
        return CollectionUtils.optional(PartBeanMeta.of(type).construct(name, sb.toString()));
    }

    public <T> Optional<T> get(Class<T> type) {
        Assertions.assertArgNotNull("type", type);
        String name = PartBeanMeta.of(type).getSchema().getName();
        Assertions.assertArg(name != null, "Part name could not be found on bean type ''{0}''", type.getName());
        return this.get(name, type);
    }

    public NameValuePair[] getAll() {
        return this.entries.length == 0 ? EMPTY_ARRAY : Arrays.copyOf(this.entries, this.entries.length);
    }

    public NameValuePair[] getAll(String name) {
        ArrayBuilder<NameValuePair> b = ArrayBuilder.of(NameValuePair.class).filter(NOT_NULL);
        for (int i = 0; i < this.entries.length; ++i) {
            if (!this.eq(this.entries[i].getName(), name)) continue;
            b.add(this.entries[i]);
        }
        return b.orElse((NameValuePair[])EMPTY_ARRAY);
    }

    public int size() {
        return this.entries.length;
    }

    public Optional<NameValuePair> getFirst(String name) {
        for (int i = 0; i < this.entries.length; ++i) {
            NameValuePair x = this.entries[i];
            if (!this.eq(x.getName(), name)) continue;
            return CollectionUtils.optional(x);
        }
        return CollectionUtils.empty();
    }

    public Optional<NameValuePair> getLast(String name) {
        for (int i = this.entries.length - 1; i >= 0; --i) {
            NameValuePair x = this.entries[i];
            if (!this.eq(x.getName(), name)) continue;
            return CollectionUtils.optional(x);
        }
        return CollectionUtils.empty();
    }

    public PartList forEachValue(Predicate<NameValuePair> filter, Consumer<String> action) {
        return this.forEach(filter, (NameValuePair x) -> action.accept(x.getValue()));
    }

    public PartList forEachValue(String name, Consumer<String> action) {
        return this.forEach(name, (NameValuePair x) -> action.accept(x.getValue()));
    }

    public String[] getValues(String name) {
        ArrayBuilder<String> b = ArrayBuilder.of(String.class).size(1);
        this.forEach(name, (NameValuePair x) -> b.add(x.getValue()));
        return b.orElse((String[])EMPTY_STRING_ARRAY);
    }

    public boolean contains(String name) {
        for (int i = 0; i < this.entries.length; ++i) {
            NameValuePair x = this.entries[i];
            if (!this.eq(x.getName(), name)) continue;
            return true;
        }
        return false;
    }

    public PartIterator iterator() {
        return new BasicPartIterator(this.entries, null, this.caseInsensitive);
    }

    public PartIterator iterator(String name) {
        return new BasicPartIterator(this.entries, name, this.caseInsensitive);
    }

    public PartList forEach(Consumer<NameValuePair> action) {
        return this.forEach((NameValuePair x) -> true, action);
    }

    public PartList forEach(String name, Consumer<NameValuePair> action) {
        return this.forEach((NameValuePair x) -> this.eq(name, x.getName()), action);
    }

    public PartList forEach(Predicate<NameValuePair> filter, Consumer<NameValuePair> action) {
        for (int i = 0; i < this.entries.length; ++i) {
            ConsumerUtils.consume(filter, action, this.entries[i]);
        }
        return this;
    }

    public Stream<NameValuePair> stream() {
        return Arrays.stream(this.entries);
    }

    public Stream<NameValuePair> stream(String name) {
        return Arrays.stream(this.entries).filter(x -> this.eq(name, x.getName()));
    }

    public List<NameValuePair> toNameValuePairs() {
        return CollectionUtils.ulist(this.entries);
    }

    public PartList forEachNameValuePair(Consumer<NameValuePair> action) {
        for (NameValuePair p : this.entries) {
            action.accept(p);
        }
        return this;
    }

    private boolean eq(String s1, String s2) {
        return StringUtils.eq(this.caseInsensitive, s1, s2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.entries.length; ++i) {
            NameValuePair p = this.entries[i];
            String v = p.getValue();
            if (v == null) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(StringUtils.urlEncode(p.getName())).append('=').append(StringUtils.urlEncode(p.getValue()));
        }
        return sb.toString();
    }

    @FluentSetters
    public static class Builder
    extends BeanBuilder<PartList> {
        final List<NameValuePair> entries;
        List<NameValuePair> defaultEntries;
        private VarResolver varResolver;
        boolean caseInsensitive = false;

        protected Builder() {
            super(PartList.class);
            this.entries = CollectionUtils.list(new NameValuePair[0]);
        }

        protected Builder(PartList copyFrom) {
            super(copyFrom.getClass());
            this.entries = CollectionUtils.list(copyFrom.entries);
            this.caseInsensitive = copyFrom.caseInsensitive;
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.entries = CollectionUtils.copyOf(copyFrom.entries);
            this.defaultEntries = CollectionUtils.copyOf(copyFrom.defaultEntries);
            this.varResolver = copyFrom.varResolver;
            this.caseInsensitive = copyFrom.caseInsensitive;
        }

        @Override
        protected PartList buildDefault() {
            return this.entries.isEmpty() && this.defaultEntries == null ? EMPTY : new PartList(this);
        }

        public Builder copy() {
            return new Builder(this);
        }

        public Builder resolving() {
            return this.resolving(VarResolver.DEFAULT);
        }

        public Builder resolving(VarResolver varResolver) {
            this.varResolver = varResolver;
            return this;
        }

        public Builder caseInsensitive() {
            this.caseInsensitive = true;
            return this;
        }

        @FluentSetter
        public Builder clear() {
            this.entries.clear();
            return this;
        }

        @FluentSetter
        public Builder append(PartList value) {
            if (value != null) {
                for (NameValuePair x : value.entries) {
                    this.append(x);
                }
            }
            return this;
        }

        @FluentSetter
        public Builder append(NameValuePair value) {
            if (value != null) {
                this.entries.add(value);
            }
            return this;
        }

        public Builder append(String name, Object value) {
            return this.append(this.createPart(name, value));
        }

        public Builder append(String name, Supplier<?> value) {
            return this.append(this.createPart(name, value));
        }

        @FluentSetter
        public Builder append(NameValuePair ... values) {
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    this.append(values[i]);
                }
            }
            return this;
        }

        @FluentSetter
        public Builder append(List<? extends NameValuePair> values) {
            if (values != null) {
                int j = values.size();
                for (int i = 0; i < j; ++i) {
                    this.append(values.get(i));
                }
            }
            return this;
        }

        @FluentSetter
        public Builder prepend(PartList value) {
            if (value != null) {
                CollectionUtils.prependAll(this.entries, value.entries);
            }
            return this;
        }

        @FluentSetter
        public Builder prepend(NameValuePair value) {
            if (value != null) {
                this.entries.add(0, value);
            }
            return this;
        }

        public Builder prepend(String name, Object value) {
            return this.prepend(this.createPart(name, value));
        }

        public Builder prepend(String name, Supplier<?> value) {
            return this.prepend(this.createPart(name, value));
        }

        @FluentSetter
        public Builder prepend(NameValuePair ... values) {
            if (values != null) {
                this.prepend(CollectionUtils.alist(values));
            }
            return this;
        }

        @FluentSetter
        public Builder prepend(List<? extends NameValuePair> values) {
            if (values != null) {
                this.entries.addAll(0, values);
            }
            return this;
        }

        @FluentSetter
        public Builder remove(PartList value) {
            if (value != null) {
                for (int i = 0; i < value.entries.length; ++i) {
                    this.remove(value.entries[i]);
                }
            }
            return this;
        }

        @FluentSetter
        public Builder remove(NameValuePair value) {
            if (value != null) {
                this.entries.remove(value);
            }
            return this;
        }

        @FluentSetter
        public Builder remove(NameValuePair ... values) {
            for (int i = 0; i < values.length; ++i) {
                this.remove(values[i]);
            }
            return this;
        }

        @FluentSetter
        public Builder remove(List<? extends NameValuePair> values) {
            int j = values.size();
            for (int i = 0; i < j; ++i) {
                this.remove(values.get(i));
            }
            return this;
        }

        @FluentSetter
        public Builder remove(String name) {
            for (int i = 0; i < this.entries.size(); ++i) {
                if (!this.eq(this.entries.get(i).getName(), name)) continue;
                this.entries.remove(i--);
            }
            return this;
        }

        @FluentSetter
        public Builder remove(String ... names) {
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    this.remove(names[i]);
                }
            }
            return this;
        }

        @FluentSetter
        public Builder set(NameValuePair value) {
            if (value != null) {
                boolean replaced = false;
                int j = this.entries.size();
                for (int i = 0; i < j; ++i) {
                    NameValuePair x = this.entries.get(i);
                    if (!this.eq(x.getName(), value.getName())) continue;
                    if (replaced) {
                        this.entries.remove(i);
                        --j;
                        continue;
                    }
                    this.entries.set(i, value);
                    replaced = true;
                }
                if (!replaced) {
                    this.entries.add(value);
                }
            }
            return this;
        }

        @FluentSetter
        public Builder set(NameValuePair ... values) {
            if (values != null) {
                this.set(CollectionUtils.alist(values));
            }
            return this;
        }

        public Builder set(String name, Object value) {
            return this.set(this.createPart(name, value));
        }

        public Builder set(String name, Supplier<?> value) {
            return this.set(this.createPart(name, value));
        }

        @FluentSetter
        public Builder set(List<? extends NameValuePair> values) {
            if (values != null) {
                int j1 = values.size();
                for (int i1 = 0; i1 < j1; ++i1) {
                    NameValuePair p = values.get(i1);
                    if (p == null) continue;
                    int j2 = this.entries.size();
                    for (int i2 = 0; i2 < j2; ++i2) {
                        NameValuePair x = this.entries.get(i2);
                        if (!this.eq(x.getName(), p.getName())) continue;
                        this.entries.remove(i2);
                        --j2;
                    }
                }
                int j = values.size();
                for (int i = 0; i < j; ++i) {
                    NameValuePair x = values.get(i);
                    if (x == null) continue;
                    this.entries.add(x);
                }
            }
            return this;
        }

        public Builder set(PartList values) {
            if (values != null) {
                this.set(values.entries);
            }
            return this;
        }

        @FluentSetter
        public Builder setDefault(NameValuePair value) {
            if (value != null) {
                boolean replaced = false;
                if (this.defaultEntries == null) {
                    this.defaultEntries = CollectionUtils.list(new NameValuePair[0]);
                }
                int j = this.defaultEntries.size();
                for (int i = 0; i < j; ++i) {
                    NameValuePair x = this.defaultEntries.get(i);
                    if (!this.eq(x.getName(), value.getName())) continue;
                    if (replaced) {
                        this.defaultEntries.remove(i);
                        --j;
                        continue;
                    }
                    this.defaultEntries.set(i, value);
                    replaced = true;
                }
                if (!replaced) {
                    this.defaultEntries.add(value);
                }
            }
            return this;
        }

        @FluentSetter
        public Builder setDefault(NameValuePair ... values) {
            if (values != null) {
                this.setDefault(CollectionUtils.alist(values));
            }
            return this;
        }

        public Builder setDefault(String name, Object value) {
            return this.setDefault(this.createPart(name, value));
        }

        public Builder setDefault(String name, Supplier<?> value) {
            return this.setDefault(this.createPart(name, value));
        }

        @FluentSetter
        public Builder setDefault(List<? extends NameValuePair> values) {
            if (values != null) {
                if (this.defaultEntries == null) {
                    this.defaultEntries = CollectionUtils.list(new NameValuePair[0]);
                }
                int j1 = values.size();
                for (int i1 = 0; i1 < j1; ++i1) {
                    NameValuePair p = values.get(i1);
                    if (p == null) continue;
                    int j2 = this.defaultEntries.size();
                    for (int i2 = 0; i2 < j2; ++i2) {
                        NameValuePair x2 = this.defaultEntries.get(i2);
                        if (!this.eq(x2.getName(), p.getName())) continue;
                        this.defaultEntries.remove(i2);
                        --j2;
                    }
                }
                values.forEach((? super T x) -> {
                    if (x != null) {
                        this.defaultEntries.add((NameValuePair)x);
                    }
                });
            }
            return this;
        }

        public Builder setDefault(PartList values) {
            if (values != null) {
                this.setDefault(values.entries);
            }
            return this;
        }

        @FluentSetter
        public Builder add(ListOperation flag, NameValuePair value) {
            if (flag == ListOperation.APPEND) {
                return this.append(value);
            }
            if (flag == ListOperation.PREPEND) {
                return this.prepend(value);
            }
            if (flag == ListOperation.SET) {
                return this.set(value);
            }
            if (flag == ListOperation.DEFAULT) {
                return this.setDefault(value);
            }
            throw ThrowableUtils.runtimeException("Invalid value specified for flag parameter on add(flag,value) method: {0}", new Object[]{flag});
        }

        @FluentSetter
        public Builder add(ListOperation flag, NameValuePair ... values) {
            if (flag == ListOperation.APPEND) {
                return this.append(values);
            }
            if (flag == ListOperation.PREPEND) {
                return this.prepend(values);
            }
            if (flag == ListOperation.SET) {
                return this.set(values);
            }
            if (flag == ListOperation.DEFAULT) {
                return this.setDefault(values);
            }
            throw ThrowableUtils.runtimeException("Invalid value specified for flag parameter on add(flag,values) method: {0}", new Object[]{flag});
        }

        public Builder add(ListOperation flag, String name, Object value) {
            if (flag == ListOperation.APPEND) {
                return this.append(name, value);
            }
            if (flag == ListOperation.PREPEND) {
                return this.prepend(name, value);
            }
            if (flag == ListOperation.SET) {
                return this.set(name, value);
            }
            if (flag == ListOperation.DEFAULT) {
                return this.setDefault(name, value);
            }
            throw ThrowableUtils.runtimeException("Invalid value specified for flag parameter on add(flag,name,value) method: {0}", new Object[]{flag});
        }

        public Builder add(ListOperation flag, String name, Supplier<?> value) {
            if (flag == ListOperation.APPEND) {
                return this.append(name, value);
            }
            if (flag == ListOperation.PREPEND) {
                return this.prepend(name, value);
            }
            if (flag == ListOperation.SET) {
                return this.set(name, value);
            }
            if (flag == ListOperation.DEFAULT) {
                return this.setDefault(name, value);
            }
            throw ThrowableUtils.runtimeException("Invalid value specified for flag parameter on add(flag,name,value) method: {0}", new Object[]{flag});
        }

        @FluentSetter
        public Builder add(ListOperation flag, List<NameValuePair> values) {
            if (flag == ListOperation.APPEND) {
                return this.append(values);
            }
            if (flag == ListOperation.PREPEND) {
                return this.prepend(values);
            }
            if (flag == ListOperation.SET) {
                return this.set(values);
            }
            if (flag == ListOperation.DEFAULT) {
                return this.setDefault(values);
            }
            throw ThrowableUtils.runtimeException("Invalid value specified for flag parameter on add(flag,values) method: {0}", new Object[]{flag});
        }

        public Builder add(ListOperation flag, PartList values) {
            if (flag == ListOperation.APPEND) {
                return this.append(values);
            }
            if (flag == ListOperation.PREPEND) {
                return this.prepend(values);
            }
            if (flag == ListOperation.SET) {
                return this.set(values);
            }
            if (flag == ListOperation.DEFAULT) {
                return this.setDefault(values);
            }
            throw ThrowableUtils.runtimeException("Invalid value specified for flag parameter on add(flag,values) method: {0}", new Object[]{flag});
        }

        public Builder forEach(Consumer<NameValuePair> action) {
            int j = this.entries.size();
            for (int i = 0; i < j; ++i) {
                action.accept(this.entries.get(i));
            }
            return this;
        }

        public Builder forEach(String name, Consumer<NameValuePair> action) {
            int j = this.entries.size();
            for (int i = 0; i < j; ++i) {
                NameValuePair x = this.entries.get(i);
                if (!this.eq(name, x.getName())) continue;
                action.accept(x);
            }
            return this;
        }

        private boolean isResolving() {
            return this.varResolver != null;
        }

        private Supplier<Object> resolver(Object input) {
            return () -> this.varResolver.resolve(StringUtils.stringify(this.unwrap(input)));
        }

        private Object unwrap(Object o) {
            while (o instanceof Supplier) {
                o = ((Supplier)o).get();
            }
            return o;
        }

        public NameValuePair createPart(String name, Object value) {
            if (value instanceof Supplier) {
                Supplier value2 = (Supplier)value;
                return this.isResolving() ? new BasicPart(name, this.resolver(value2)) : new BasicPart(name, value2);
            }
            return this.isResolving() ? new BasicPart(name, this.resolver(value)) : new BasicPart(name, value);
        }

        private boolean eq(String s1, String s2) {
            return this.caseInsensitive ? StringUtils.eq(s1, s2) : StringUtils.eqic(s1, s2);
        }

        public Optional<NameValuePair> getFirst(String name) {
            NameValuePair x;
            int i;
            for (i = 0; i < this.entries.size(); ++i) {
                x = this.entries.get(i);
                if (!this.eq(x.getName(), name)) continue;
                return CollectionUtils.optional(x);
            }
            if (this.defaultEntries != null) {
                for (i = 0; i < this.defaultEntries.size(); ++i) {
                    x = this.defaultEntries.get(i);
                    if (!this.eq(x.getName(), name)) continue;
                    return CollectionUtils.optional(x);
                }
            }
            return CollectionUtils.empty();
        }

        public Optional<NameValuePair> getLast(String name) {
            NameValuePair x;
            int i;
            for (i = this.entries.size() - 1; i >= 0; --i) {
                x = this.entries.get(i);
                if (!this.eq(x.getName(), name)) continue;
                return CollectionUtils.optional(x);
            }
            if (this.defaultEntries != null) {
                for (i = this.defaultEntries.size() - 1; i >= 0; --i) {
                    x = this.defaultEntries.get(i);
                    if (!this.eq(x.getName(), name)) continue;
                    return CollectionUtils.optional(x);
                }
            }
            return CollectionUtils.empty();
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }

        public String toString() {
            return "[" + StringUtils.join(this.entries, ", ") + "]";
        }
    }

    public static final class Null
    extends PartList {
    }
}

