/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.juneau.assertions.AssertionPredicate;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.internal.StringUtils;

public class AssertionPredicates {
    private static Function<Object, String> TYPENAME = x -> x == null ? null : x.getClass().getName();
    private static final Messages MESSAGES = Messages.of(AssertionPredicates.class, "Messages");
    private static final String MSG_valueWasNull = MESSAGES.getString("valueWasNull");
    private static final String MSG_valueWasNotNull = MESSAGES.getString("valueWasNotNull");
    private static final String MSG_valueDidNotMatchExpected = MESSAGES.getString("valueDidNotMatchExpected");
    private static final String MSG_valueDidNotContainExpected = MESSAGES.getString("valueDidNotContainExpected");
    private static final String MSG_valueUnexpectedlyMatched = MESSAGES.getString("valueUnexpectedlyMatched");
    private static final String MSG_valueWasNotExpectedType = MESSAGES.getString("valueWasNotExpectedType");
    private static final String MSG_valueDidNotMatchPattern = MESSAGES.getString("valueDidNotMatchPattern");

    public static final <T> AssertionPredicate<T> any() {
        return AssertionPredicates.test(x -> true, null, new Object[0]);
    }

    public static final <T> AssertionPredicate<T> notNull() {
        return AssertionPredicates.test(x -> x != null, MSG_valueWasNull, new Object[0]);
    }

    public static final <T> AssertionPredicate<T> isNull() {
        return AssertionPredicates.test(x -> x == null, MSG_valueWasNotNull, new Object[0]);
    }

    public static final <T> AssertionPredicate<T> eq(Object value) {
        return AssertionPredicates.test(x -> Objects.equals(x, value), MSG_valueDidNotMatchExpected, value, AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> eq(String value) {
        return AssertionPredicates.test(x -> Objects.equals(StringUtils.stringify(x), value), MSG_valueDidNotMatchExpected, value, AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> ne(Object value) {
        return AssertionPredicates.test(x -> !Objects.equals(x, value), MSG_valueUnexpectedlyMatched, AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> ne(String value) {
        return AssertionPredicates.test(x -> !Objects.equals(StringUtils.stringify(x), value), MSG_valueUnexpectedlyMatched, AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> eqic(String value) {
        return AssertionPredicates.test(x -> StringUtils.eqic(StringUtils.stringify(x), value), MSG_valueDidNotMatchExpected, value, AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> contains(String value) {
        return AssertionPredicates.test(x -> StringUtils.contains(StringUtils.stringify(x), value), MSG_valueDidNotContainExpected, value, AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> type(Class<?> type) {
        Assertions.assertArgNotNull("type", type);
        return AssertionPredicates.test(x -> x != null && type.isAssignableFrom(x.getClass()), MSG_valueWasNotExpectedType, type, TYPENAME);
    }

    public static final <T> AssertionPredicate<T> exactType(Class<?> type) {
        Assertions.assertArgNotNull("type", type);
        return AssertionPredicates.test(x -> x != null && x.getClass().equals(type), MSG_valueWasNotExpectedType, type, TYPENAME);
    }

    public static final <T> AssertionPredicate<T> match(String value) {
        Assertions.assertArgNotNull("value", value);
        Pattern p = StringUtils.getMatchPattern(value);
        return AssertionPredicates.test(x -> x != null && p.matcher(StringUtils.stringify(x)).matches(), MSG_valueDidNotMatchPattern, value, AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> regex(String expression) {
        Assertions.assertArgNotNull("expression", expression);
        Pattern p = Pattern.compile(expression);
        return AssertionPredicates.test(x -> x != null && p.matcher(StringUtils.stringify(x)).matches(), MSG_valueDidNotMatchPattern, expression, AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> regex(String expression, int flags) {
        Assertions.assertArgNotNull("expression", expression);
        Pattern p = Pattern.compile(expression, flags);
        return AssertionPredicates.test(x -> x != null && p.matcher(StringUtils.stringify(x)).matches(), MSG_valueDidNotMatchPattern, expression, AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> regex(Pattern value) {
        Assertions.assertArgNotNull("value", value);
        return AssertionPredicates.test(x -> x != null && value.matcher(StringUtils.stringify(x)).matches(), MSG_valueDidNotMatchPattern, value.pattern(), AssertionPredicate.VALUE);
    }

    public static final <T> AssertionPredicate<T> test(Predicate<T> predicate) {
        return new AssertionPredicate<T>(predicate, null, new Object[0]);
    }

    public static final <T> AssertionPredicate<T> test(Predicate<T> predicate, String msg, Object ... args) {
        return new AssertionPredicate<T>(predicate, msg, args);
    }

    @SafeVarargs
    public static final <T> AssertionPredicate<T> and(Predicate<T> ... predicates) {
        return new AssertionPredicate.And<T>(predicates);
    }

    @SafeVarargs
    public static final <T> AssertionPredicate<T> or(Predicate<T> ... predicates) {
        return new AssertionPredicate.Or<T>(predicates);
    }

    public static final <T> AssertionPredicate<T> not(Predicate<T> predicate) {
        return new AssertionPredicate.Not<T>(predicate);
    }
}

