/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.apache.juneau.annotation.TargetedAnnotationImpl;
import org.apache.juneau.annotation.TargetedAnnotationMBuilder;
import org.apache.juneau.rest.annotation.HookEvent;
import org.apache.juneau.rest.annotation.RestHook;

public class RestHookAnnotation {
    public static final RestHook DEFAULT = RestHookAnnotation.create().value(HookEvent.INIT).build();

    public static Builder create() {
        return new Builder();
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public RestHook[] value();
    }

    private static class Impl
    extends TargetedAnnotationImpl
    implements RestHook {
        private final HookEvent value;

        Impl(Builder b) {
            super(b);
            this.value = b.value;
            this.postConstruct();
        }

        @Override
        public HookEvent value() {
            return this.value;
        }
    }

    public static class Builder
    extends TargetedAnnotationMBuilder {
        HookEvent value = HookEvent.INIT;

        protected Builder() {
            super(RestHook.class);
        }

        public RestHook build() {
            return new Impl(this);
        }

        public Builder value(HookEvent value) {
            this.value = value;
            return this;
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }
    }
}

