/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.UriContext;
import org.apache.juneau.http.header.MediaType;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.Flag;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.json.JsonClassMeta;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.JsonWriter;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.SerializerWriter;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.swap.ObjectSwap;

public class JsonSerializerSession
extends WriterSerializerSession {
    private final JsonSerializer ctx;

    public static Builder create(JsonSerializer ctx) {
        return new Builder(ctx);
    }

    protected JsonSerializerSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws IOException, SerializeException {
        this.serializeAnything(this.getJsonWriter(out).i(this.getInitialDepth()), o, this.getExpectedRootType(o), "root", null);
    }

    protected String serializeJson(Object o) throws Exception {
        StringWriter sw = new StringWriter();
        this.serializeAnything(this.getJsonWriter(this.createPipe(sw)).i(this.getInitialDepth()), o, this.getExpectedRootType(o), "root", null);
        return sw.toString();
    }

    protected JsonWriter serializeAnything(JsonWriter out, Object o, ClassMeta<?> eType, String attrName, BeanPropertyMeta pMeta) throws SerializeException {
        String wrapperAttr;
        ClassMeta<Object> aType;
        boolean isRecursion;
        if (o == null) {
            out.append("null");
            return out;
        }
        if (eType == null) {
            eType = this.object();
        }
        boolean bl = isRecursion = (aType = this.push2(attrName, o, eType)) == null;
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        if (this.isOptional(aType)) {
            o = this.getOptionalValue(o);
            eType = this.getOptionalType(eType);
            aType = this.getClassMetaForObject(o, this.object());
        }
        ClassMeta<Object> sType = aType;
        String typeName = this.getBeanTypeName(this, eType, aType, pMeta);
        ObjectSwap<Object, ?> swap = aType.getSwap(this);
        if (swap != null) {
            o = this.swap(swap, o);
            sType = swap.getSwapClassMeta(this);
            if (sType.isObject()) {
                sType = this.getClassMetaForObject(o);
            }
        }
        if ((wrapperAttr = this.getJsonClassMeta(sType).getWrapperAttr()) != null) {
            out.w('{').cr(this.indent).attr(wrapperAttr).w(':').s(this.indent);
            ++this.indent;
        }
        if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
            out.append("null");
        } else if (sType.isNumber() || sType.isBoolean()) {
            out.append(o);
        } else if (sType.isBean()) {
            this.serializeBeanMap(out, this.toBeanMap(o), typeName);
        } else if (sType.isUri() || pMeta != null && pMeta.isUri()) {
            out.uriValue(o);
        } else if (sType.isMap()) {
            if (o instanceof BeanMap) {
                this.serializeBeanMap(out, (BeanMap)o, typeName);
            } else {
                this.serializeMap(out, (Map)o, eType);
            }
        } else if (sType.isCollection()) {
            this.serializeCollection(out, (Collection)o, eType);
        } else if (sType.isArray()) {
            this.serializeCollection(out, JsonSerializerSession.toList(sType.getInnerClass(), o), eType);
        } else if (sType.isReader()) {
            IOUtils.pipe((Reader)o, (Writer)out, SerializerSession::handleThrown);
        } else if (sType.isInputStream()) {
            IOUtils.pipe((InputStream)o, (Writer)out, SerializerSession::handleThrown);
        } else {
            out.stringValue(this.toString(o));
        }
        if (wrapperAttr != null) {
            --this.indent;
            out.cre(this.indent - 1).w('}');
        }
        if (!isRecursion) {
            this.pop();
        }
        return out;
    }

    private SerializerWriter serializeMap(JsonWriter out, Map m, ClassMeta<?> type) throws SerializeException {
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        int i = this.indent;
        out.w('{');
        Flag addComma = Flag.create();
        this.forEachEntry(m, (Map.Entry<K, V> x) -> {
            addComma.ifSet(() -> out.w(',').smi(i)).set();
            Object value = x.getValue();
            Object key = this.generalize(x.getKey(), keyType);
            out.cr(i).attr(this.toString(key)).w(':').s(i);
            this.serializeAnything(out, value, valueType, key == null ? null : this.toString(key), null);
        });
        out.cre(i - 1).w('}');
        return out;
    }

    private SerializerWriter serializeBeanMap(JsonWriter out, BeanMap<?> m, String typeName) throws SerializeException {
        int i = this.indent;
        out.w('{');
        Flag addComma = Flag.create();
        Predicate<Object> checkNull = x -> this.isKeepNullProperties() || x != null;
        if (typeName != null) {
            BeanPropertyMeta pm = m.getMeta().getTypeProperty();
            out.cr(i).attr(pm.getName()).w(':').s(i).stringValue(typeName);
            addComma.set();
        }
        m.forEachValue(checkNull, (pMeta, key, value, thrown) -> {
            ClassMeta<?> cMeta = pMeta.getClassMeta();
            if (thrown != null) {
                this.onBeanGetterException((BeanPropertyMeta)pMeta, (Throwable)thrown);
            }
            if (this.canIgnoreValue(cMeta, (String)key, value)) {
                return;
            }
            addComma.ifSet(() -> out.append(',').smi(i)).set();
            out.cr(i).attr((String)key).w(':').s(i);
            this.serializeAnything(out, value, cMeta, (String)key, (BeanPropertyMeta)pMeta);
        });
        out.cre(i - 1).w('}');
        return out;
    }

    private SerializerWriter serializeCollection(JsonWriter out, Collection c, ClassMeta<?> type) throws SerializeException {
        ClassMeta<?> elementType = type.getElementType();
        out.w('[');
        Flag addComma = Flag.create();
        this.forEachEntry(c, (E x) -> {
            addComma.ifSet(() -> out.w(',').smi(this.indent)).set();
            out.cr(this.indent);
            this.serializeAnything(out, x, elementType, "<iterator>", null);
        });
        out.cre(this.indent - 1).w(']');
        return out;
    }

    protected final JsonWriter getJsonWriter(SerializerPipe out) throws IOException {
        Object output = out.getRawOutput();
        if (output instanceof JsonWriter) {
            return (JsonWriter)output;
        }
        JsonWriter w = new JsonWriter(out.getWriter(), this.isUseWhitespace(), this.getMaxIndent(), this.isEscapeSolidus(), this.getQuoteChar(), this.isSimpleMode(), this.isTrimStrings(), this.getUriResolver());
        out.setWriter(w);
        return w;
    }

    @Override
    protected final boolean isAddBeanTypes() {
        return this.ctx.isAddBeanTypes();
    }

    protected final boolean isEscapeSolidus() {
        return this.ctx.isEscapeSolidus();
    }

    protected final boolean isSimpleMode() {
        return this.ctx.isSimpleMode();
    }

    protected JsonClassMeta getJsonClassMeta(ClassMeta<?> cm) {
        return this.ctx.getJsonClassMeta(cm);
    }

    @FluentSetters
    public static class Builder
    extends WriterSerializerSession.Builder {
        JsonSerializer ctx;

        protected Builder(JsonSerializer ctx) {
            super(ctx);
            this.ctx = ctx;
        }

        @Override
        public JsonSerializerSession build() {
            return new JsonSerializerSession(this);
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder localeDefault(Locale value) {
            super.localeDefault(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder resolver(VarResolverSession value) {
            super.resolver(value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder useWhitespace(Boolean value) {
            super.useWhitespace(value);
            return this;
        }
    }
}

