/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.juneau.assertions.Assertions;

public class MultiSet<E>
extends AbstractSet<E> {
    final Collection<E>[] l;

    @SafeVarargs
    public MultiSet(Collection<E> ... c) {
        Assertions.assertArgNotNull("c", c);
        for (Collection<E> cc : c) {
            Assertions.assertArgNotNull("c", cc);
        }
        this.l = c;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int i = 0;
            Iterator<E> i2;
            {
                this.i2 = MultiSet.this.l.length > 0 ? MultiSet.this.l[this.i++].iterator() : null;
            }

            @Override
            public boolean hasNext() {
                if (this.i2 == null) {
                    return false;
                }
                if (this.i2.hasNext()) {
                    return true;
                }
                for (int j = this.i; j < MultiSet.this.l.length; ++j) {
                    if (MultiSet.this.l[j].size() <= 0) continue;
                    return true;
                }
                return false;
            }

            @Override
            public E next() {
                if (this.i2 == null) {
                    throw new NoSuchElementException();
                }
                while (!this.i2.hasNext()) {
                    if (this.i >= MultiSet.this.l.length) {
                        throw new NoSuchElementException();
                    }
                    this.i2 = MultiSet.this.l[this.i++].iterator();
                }
                return this.i2.next();
            }

            @Override
            public void remove() {
                if (this.i2 == null) {
                    throw new NoSuchElementException();
                }
                this.i2.remove();
            }
        };
    }

    public Enumeration<E> enumerator() {
        return Collections.enumeration(this);
    }

    @Override
    public int size() {
        int i = 0;
        for (Collection<E> c : this.l) {
            i += c.size();
        }
        return i;
    }
}

